/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.observabilityadmin.model.PipelineOutputError;
import software.amazon.awssdk.services.observabilityadmin.model.Record;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineOutput> {
    private static final SdkField<Record> RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Record").getter(PipelineOutput.getter(PipelineOutput::record)).setter(PipelineOutput.setter(Builder::record)).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build()}).build();
    private static final SdkField<PipelineOutputError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(PipelineOutput.getter(PipelineOutput::error)).setter(PipelineOutput.setter(Builder::error)).constructor(PipelineOutputError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipelineOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Record record;
    private final PipelineOutputError error;

    private PipelineOutput(BuilderImpl builder) {
        this.record = builder.record;
        this.error = builder.error;
    }

    public final Record record() {
        return this.record;
    }

    public final PipelineOutputError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.record());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineOutput)) {
            return false;
        }
        PipelineOutput other = (PipelineOutput)obj;
        return Objects.equals(this.record(), other.record()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineOutput").add("Record", (Object)this.record()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Record": {
                return Optional.ofNullable(clazz.cast(this.record()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Record", RECORD_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineOutput, T> g) {
        return obj -> g.apply((PipelineOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Record record;
        private PipelineOutputError error;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineOutput model) {
            this.record(model.record);
            this.error(model.error);
        }

        public final Record.Builder getRecord() {
            return this.record != null ? this.record.toBuilder() : null;
        }

        public final void setRecord(Record.BuilderImpl record) {
            this.record = record != null ? record.build() : null;
        }

        @Override
        public final Builder record(Record record) {
            this.record = record;
            return this;
        }

        public final PipelineOutputError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(PipelineOutputError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(PipelineOutputError error) {
            this.error = error;
            return this;
        }

        public PipelineOutput build() {
            return new PipelineOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineOutput> {
        public Builder record(Record var1);

        default public Builder record(Consumer<Record.Builder> record) {
            return this.record((Record)((Record.Builder)Record.builder().applyMutation(record)).build());
        }

        public Builder error(PipelineOutputError var1);

        default public Builder error(Consumer<PipelineOutputError.Builder> error) {
            return this.error((PipelineOutputError)((PipelineOutputError.Builder)PipelineOutputError.builder().applyMutation(error)).build());
        }
    }
}

