/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration specifying where and how telemetry data should be delivered for Amazon Web Services resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelemetryDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TelemetryDestinationConfiguration.Builder, TelemetryDestinationConfiguration> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(TelemetryDestinationConfiguration::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()).build();

    private static final SdkField<String> DESTINATION_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPattern").getter(getter(TelemetryDestinationConfiguration::destinationPattern))
            .setter(setter(Builder::destinationPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPattern").build())
            .build();

    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionInDays").getter(getter(TelemetryDestinationConfiguration::retentionInDays))
            .setter(setter(Builder::retentionInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionInDays").build()).build();

    private static final SdkField<VPCFlowLogParameters> VPC_FLOW_LOG_PARAMETERS_FIELD = SdkField
            .<VPCFlowLogParameters> builder(MarshallingType.SDK_POJO).memberName("VPCFlowLogParameters")
            .getter(getter(TelemetryDestinationConfiguration::vpcFlowLogParameters))
            .setter(setter(Builder::vpcFlowLogParameters)).constructor(VPCFlowLogParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCFlowLogParameters").build())
            .build();

    private static final SdkField<CloudtrailParameters> CLOUDTRAIL_PARAMETERS_FIELD = SdkField
            .<CloudtrailParameters> builder(MarshallingType.SDK_POJO).memberName("CloudtrailParameters")
            .getter(getter(TelemetryDestinationConfiguration::cloudtrailParameters))
            .setter(setter(Builder::cloudtrailParameters)).constructor(CloudtrailParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudtrailParameters").build())
            .build();

    private static final SdkField<ELBLoadBalancerLoggingParameters> ELB_LOAD_BALANCER_LOGGING_PARAMETERS_FIELD = SdkField
            .<ELBLoadBalancerLoggingParameters> builder(MarshallingType.SDK_POJO)
            .memberName("ELBLoadBalancerLoggingParameters")
            .getter(getter(TelemetryDestinationConfiguration::elbLoadBalancerLoggingParameters))
            .setter(setter(Builder::elbLoadBalancerLoggingParameters))
            .constructor(ELBLoadBalancerLoggingParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ELBLoadBalancerLoggingParameters")
                    .build()).build();

    private static final SdkField<WAFLoggingParameters> WAF_LOGGING_PARAMETERS_FIELD = SdkField
            .<WAFLoggingParameters> builder(MarshallingType.SDK_POJO).memberName("WAFLoggingParameters")
            .getter(getter(TelemetryDestinationConfiguration::wafLoggingParameters))
            .setter(setter(Builder::wafLoggingParameters)).constructor(WAFLoggingParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WAFLoggingParameters").build())
            .build();

    private static final SdkField<LogDeliveryParameters> LOG_DELIVERY_PARAMETERS_FIELD = SdkField
            .<LogDeliveryParameters> builder(MarshallingType.SDK_POJO).memberName("LogDeliveryParameters")
            .getter(getter(TelemetryDestinationConfiguration::logDeliveryParameters))
            .setter(setter(Builder::logDeliveryParameters)).constructor(LogDeliveryParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD,
            DESTINATION_PATTERN_FIELD, RETENTION_IN_DAYS_FIELD, VPC_FLOW_LOG_PARAMETERS_FIELD, CLOUDTRAIL_PARAMETERS_FIELD,
            ELB_LOAD_BALANCER_LOGGING_PARAMETERS_FIELD, WAF_LOGGING_PARAMETERS_FIELD, LOG_DELIVERY_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationType;

    private final String destinationPattern;

    private final Integer retentionInDays;

    private final VPCFlowLogParameters vpcFlowLogParameters;

    private final CloudtrailParameters cloudtrailParameters;

    private final ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters;

    private final WAFLoggingParameters wafLoggingParameters;

    private final LogDeliveryParameters logDeliveryParameters;

    private TelemetryDestinationConfiguration(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.destinationPattern = builder.destinationPattern;
        this.retentionInDays = builder.retentionInDays;
        this.vpcFlowLogParameters = builder.vpcFlowLogParameters;
        this.cloudtrailParameters = builder.cloudtrailParameters;
        this.elbLoadBalancerLoggingParameters = builder.elbLoadBalancerLoggingParameters;
        this.wafLoggingParameters = builder.wafLoggingParameters;
        this.logDeliveryParameters = builder.logDeliveryParameters;
    }

    /**
     * <p>
     * The type of destination for the telemetry data (e.g., "Amazon CloudWatch Logs", "S3").
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of destination for the telemetry data (e.g., "Amazon CloudWatch Logs", "S3").
     * @see DestinationType
     */
    public final DestinationType destinationType() {
        return DestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * The type of destination for the telemetry data (e.g., "Amazon CloudWatch Logs", "S3").
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of destination for the telemetry data (e.g., "Amazon CloudWatch Logs", "S3").
     * @see DestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * The pattern used to generate the destination path or name, supporting macros like &lt;resourceId&gt; and
     * &lt;accountId&gt;.
     * </p>
     * 
     * @return The pattern used to generate the destination path or name, supporting macros like &lt;resourceId&gt; and
     *         &lt;accountId&gt;.
     */
    public final String destinationPattern() {
        return destinationPattern;
    }

    /**
     * <p>
     * The number of days to retain the telemetry data in the destination.
     * </p>
     * 
     * @return The number of days to retain the telemetry data in the destination.
     */
    public final Integer retentionInDays() {
        return retentionInDays;
    }

    /**
     * <p>
     * Configuration parameters specific to VPC Flow Logs when VPC is the resource type.
     * </p>
     * 
     * @return Configuration parameters specific to VPC Flow Logs when VPC is the resource type.
     */
    public final VPCFlowLogParameters vpcFlowLogParameters() {
        return vpcFlowLogParameters;
    }

    /**
     * <p>
     * Configuration parameters specific to Amazon Web Services CloudTrail when CloudTrail is the source type.
     * </p>
     * 
     * @return Configuration parameters specific to Amazon Web Services CloudTrail when CloudTrail is the source type.
     */
    public final CloudtrailParameters cloudtrailParameters() {
        return cloudtrailParameters;
    }

    /**
     * <p>
     * Configuration parameters specific to ELB load balancer logging when ELB is the resource type.
     * </p>
     * 
     * @return Configuration parameters specific to ELB load balancer logging when ELB is the resource type.
     */
    public final ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters() {
        return elbLoadBalancerLoggingParameters;
    }

    /**
     * <p>
     * Configuration parameters specific to WAF logging when WAF is the resource type.
     * </p>
     * 
     * @return Configuration parameters specific to WAF logging when WAF is the resource type.
     */
    public final WAFLoggingParameters wafLoggingParameters() {
        return wafLoggingParameters;
    }

    /**
     * <p>
     * Configuration parameters specific to Amazon Bedrock AgentCore logging when Amazon Bedrock AgentCore is the
     * resource type.
     * </p>
     * 
     * @return Configuration parameters specific to Amazon Bedrock AgentCore logging when Amazon Bedrock AgentCore is
     *         the resource type.
     */
    public final LogDeliveryParameters logDeliveryParameters() {
        return logDeliveryParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPattern());
        hashCode = 31 * hashCode + Objects.hashCode(retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(vpcFlowLogParameters());
        hashCode = 31 * hashCode + Objects.hashCode(cloudtrailParameters());
        hashCode = 31 * hashCode + Objects.hashCode(elbLoadBalancerLoggingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(wafLoggingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryDestinationConfiguration)) {
            return false;
        }
        TelemetryDestinationConfiguration other = (TelemetryDestinationConfiguration) obj;
        return Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(destinationPattern(), other.destinationPattern())
                && Objects.equals(retentionInDays(), other.retentionInDays())
                && Objects.equals(vpcFlowLogParameters(), other.vpcFlowLogParameters())
                && Objects.equals(cloudtrailParameters(), other.cloudtrailParameters())
                && Objects.equals(elbLoadBalancerLoggingParameters(), other.elbLoadBalancerLoggingParameters())
                && Objects.equals(wafLoggingParameters(), other.wafLoggingParameters())
                && Objects.equals(logDeliveryParameters(), other.logDeliveryParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelemetryDestinationConfiguration").add("DestinationType", destinationTypeAsString())
                .add("DestinationPattern", destinationPattern()).add("RetentionInDays", retentionInDays())
                .add("VPCFlowLogParameters", vpcFlowLogParameters()).add("CloudtrailParameters", cloudtrailParameters())
                .add("ELBLoadBalancerLoggingParameters", elbLoadBalancerLoggingParameters())
                .add("WAFLoggingParameters", wafLoggingParameters()).add("LogDeliveryParameters", logDeliveryParameters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "DestinationPattern":
            return Optional.ofNullable(clazz.cast(destinationPattern()));
        case "RetentionInDays":
            return Optional.ofNullable(clazz.cast(retentionInDays()));
        case "VPCFlowLogParameters":
            return Optional.ofNullable(clazz.cast(vpcFlowLogParameters()));
        case "CloudtrailParameters":
            return Optional.ofNullable(clazz.cast(cloudtrailParameters()));
        case "ELBLoadBalancerLoggingParameters":
            return Optional.ofNullable(clazz.cast(elbLoadBalancerLoggingParameters()));
        case "WAFLoggingParameters":
            return Optional.ofNullable(clazz.cast(wafLoggingParameters()));
        case "LogDeliveryParameters":
            return Optional.ofNullable(clazz.cast(logDeliveryParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationType", DESTINATION_TYPE_FIELD);
        map.put("DestinationPattern", DESTINATION_PATTERN_FIELD);
        map.put("RetentionInDays", RETENTION_IN_DAYS_FIELD);
        map.put("VPCFlowLogParameters", VPC_FLOW_LOG_PARAMETERS_FIELD);
        map.put("CloudtrailParameters", CLOUDTRAIL_PARAMETERS_FIELD);
        map.put("ELBLoadBalancerLoggingParameters", ELB_LOAD_BALANCER_LOGGING_PARAMETERS_FIELD);
        map.put("WAFLoggingParameters", WAF_LOGGING_PARAMETERS_FIELD);
        map.put("LogDeliveryParameters", LOG_DELIVERY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryDestinationConfiguration, T> g) {
        return obj -> g.apply((TelemetryDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelemetryDestinationConfiguration> {
        /**
         * <p>
         * The type of destination for the telemetry data (e.g., "Amazon CloudWatch Logs", "S3").
         * </p>
         * 
         * @param destinationType
         *        The type of destination for the telemetry data (e.g., "Amazon CloudWatch Logs", "S3").
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * The type of destination for the telemetry data (e.g., "Amazon CloudWatch Logs", "S3").
         * </p>
         * 
         * @param destinationType
         *        The type of destination for the telemetry data (e.g., "Amazon CloudWatch Logs", "S3").
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(DestinationType destinationType);

        /**
         * <p>
         * The pattern used to generate the destination path or name, supporting macros like &lt;resourceId&gt; and
         * &lt;accountId&gt;.
         * </p>
         * 
         * @param destinationPattern
         *        The pattern used to generate the destination path or name, supporting macros like &lt;resourceId&gt;
         *        and &lt;accountId&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPattern(String destinationPattern);

        /**
         * <p>
         * The number of days to retain the telemetry data in the destination.
         * </p>
         * 
         * @param retentionInDays
         *        The number of days to retain the telemetry data in the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionInDays(Integer retentionInDays);

        /**
         * <p>
         * Configuration parameters specific to VPC Flow Logs when VPC is the resource type.
         * </p>
         * 
         * @param vpcFlowLogParameters
         *        Configuration parameters specific to VPC Flow Logs when VPC is the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcFlowLogParameters(VPCFlowLogParameters vpcFlowLogParameters);

        /**
         * <p>
         * Configuration parameters specific to VPC Flow Logs when VPC is the resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPCFlowLogParameters.Builder} avoiding
         * the need to create one manually via {@link VPCFlowLogParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VPCFlowLogParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcFlowLogParameters(VPCFlowLogParameters)}.
         * 
         * @param vpcFlowLogParameters
         *        a consumer that will call methods on {@link VPCFlowLogParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcFlowLogParameters(VPCFlowLogParameters)
         */
        default Builder vpcFlowLogParameters(Consumer<VPCFlowLogParameters.Builder> vpcFlowLogParameters) {
            return vpcFlowLogParameters(VPCFlowLogParameters.builder().applyMutation(vpcFlowLogParameters).build());
        }

        /**
         * <p>
         * Configuration parameters specific to Amazon Web Services CloudTrail when CloudTrail is the source type.
         * </p>
         * 
         * @param cloudtrailParameters
         *        Configuration parameters specific to Amazon Web Services CloudTrail when CloudTrail is the source
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudtrailParameters(CloudtrailParameters cloudtrailParameters);

        /**
         * <p>
         * Configuration parameters specific to Amazon Web Services CloudTrail when CloudTrail is the source type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudtrailParameters.Builder} avoiding
         * the need to create one manually via {@link CloudtrailParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudtrailParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudtrailParameters(CloudtrailParameters)}.
         * 
         * @param cloudtrailParameters
         *        a consumer that will call methods on {@link CloudtrailParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudtrailParameters(CloudtrailParameters)
         */
        default Builder cloudtrailParameters(Consumer<CloudtrailParameters.Builder> cloudtrailParameters) {
            return cloudtrailParameters(CloudtrailParameters.builder().applyMutation(cloudtrailParameters).build());
        }

        /**
         * <p>
         * Configuration parameters specific to ELB load balancer logging when ELB is the resource type.
         * </p>
         * 
         * @param elbLoadBalancerLoggingParameters
         *        Configuration parameters specific to ELB load balancer logging when ELB is the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elbLoadBalancerLoggingParameters(ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters);

        /**
         * <p>
         * Configuration parameters specific to ELB load balancer logging when ELB is the resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ELBLoadBalancerLoggingParameters.Builder}
         * avoiding the need to create one manually via {@link ELBLoadBalancerLoggingParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ELBLoadBalancerLoggingParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #elbLoadBalancerLoggingParameters(ELBLoadBalancerLoggingParameters)}.
         * 
         * @param elbLoadBalancerLoggingParameters
         *        a consumer that will call methods on {@link ELBLoadBalancerLoggingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elbLoadBalancerLoggingParameters(ELBLoadBalancerLoggingParameters)
         */
        default Builder elbLoadBalancerLoggingParameters(
                Consumer<ELBLoadBalancerLoggingParameters.Builder> elbLoadBalancerLoggingParameters) {
            return elbLoadBalancerLoggingParameters(ELBLoadBalancerLoggingParameters.builder()
                    .applyMutation(elbLoadBalancerLoggingParameters).build());
        }

        /**
         * <p>
         * Configuration parameters specific to WAF logging when WAF is the resource type.
         * </p>
         * 
         * @param wafLoggingParameters
         *        Configuration parameters specific to WAF logging when WAF is the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wafLoggingParameters(WAFLoggingParameters wafLoggingParameters);

        /**
         * <p>
         * Configuration parameters specific to WAF logging when WAF is the resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link WAFLoggingParameters.Builder} avoiding
         * the need to create one manually via {@link WAFLoggingParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WAFLoggingParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #wafLoggingParameters(WAFLoggingParameters)}.
         * 
         * @param wafLoggingParameters
         *        a consumer that will call methods on {@link WAFLoggingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wafLoggingParameters(WAFLoggingParameters)
         */
        default Builder wafLoggingParameters(Consumer<WAFLoggingParameters.Builder> wafLoggingParameters) {
            return wafLoggingParameters(WAFLoggingParameters.builder().applyMutation(wafLoggingParameters).build());
        }

        /**
         * <p>
         * Configuration parameters specific to Amazon Bedrock AgentCore logging when Amazon Bedrock AgentCore is the
         * resource type.
         * </p>
         * 
         * @param logDeliveryParameters
         *        Configuration parameters specific to Amazon Bedrock AgentCore logging when Amazon Bedrock AgentCore is
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryParameters(LogDeliveryParameters logDeliveryParameters);

        /**
         * <p>
         * Configuration parameters specific to Amazon Bedrock AgentCore logging when Amazon Bedrock AgentCore is the
         * resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryParameters.Builder} avoiding
         * the need to create one manually via {@link LogDeliveryParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDeliveryParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #logDeliveryParameters(LogDeliveryParameters)}.
         * 
         * @param logDeliveryParameters
         *        a consumer that will call methods on {@link LogDeliveryParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryParameters(LogDeliveryParameters)
         */
        default Builder logDeliveryParameters(Consumer<LogDeliveryParameters.Builder> logDeliveryParameters) {
            return logDeliveryParameters(LogDeliveryParameters.builder().applyMutation(logDeliveryParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destinationType;

        private String destinationPattern;

        private Integer retentionInDays;

        private VPCFlowLogParameters vpcFlowLogParameters;

        private CloudtrailParameters cloudtrailParameters;

        private ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters;

        private WAFLoggingParameters wafLoggingParameters;

        private LogDeliveryParameters logDeliveryParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryDestinationConfiguration model) {
            destinationType(model.destinationType);
            destinationPattern(model.destinationPattern);
            retentionInDays(model.retentionInDays);
            vpcFlowLogParameters(model.vpcFlowLogParameters);
            cloudtrailParameters(model.cloudtrailParameters);
            elbLoadBalancerLoggingParameters(model.elbLoadBalancerLoggingParameters);
            wafLoggingParameters(model.wafLoggingParameters);
            logDeliveryParameters(model.logDeliveryParameters);
        }

        public final String getDestinationType() {
            return destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getDestinationPattern() {
            return destinationPattern;
        }

        public final void setDestinationPattern(String destinationPattern) {
            this.destinationPattern = destinationPattern;
        }

        @Override
        public final Builder destinationPattern(String destinationPattern) {
            this.destinationPattern = destinationPattern;
            return this;
        }

        public final Integer getRetentionInDays() {
            return retentionInDays;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final VPCFlowLogParameters.Builder getVpcFlowLogParameters() {
            return vpcFlowLogParameters != null ? vpcFlowLogParameters.toBuilder() : null;
        }

        public final void setVpcFlowLogParameters(VPCFlowLogParameters.BuilderImpl vpcFlowLogParameters) {
            this.vpcFlowLogParameters = vpcFlowLogParameters != null ? vpcFlowLogParameters.build() : null;
        }

        @Override
        public final Builder vpcFlowLogParameters(VPCFlowLogParameters vpcFlowLogParameters) {
            this.vpcFlowLogParameters = vpcFlowLogParameters;
            return this;
        }

        public final CloudtrailParameters.Builder getCloudtrailParameters() {
            return cloudtrailParameters != null ? cloudtrailParameters.toBuilder() : null;
        }

        public final void setCloudtrailParameters(CloudtrailParameters.BuilderImpl cloudtrailParameters) {
            this.cloudtrailParameters = cloudtrailParameters != null ? cloudtrailParameters.build() : null;
        }

        @Override
        public final Builder cloudtrailParameters(CloudtrailParameters cloudtrailParameters) {
            this.cloudtrailParameters = cloudtrailParameters;
            return this;
        }

        public final ELBLoadBalancerLoggingParameters.Builder getElbLoadBalancerLoggingParameters() {
            return elbLoadBalancerLoggingParameters != null ? elbLoadBalancerLoggingParameters.toBuilder() : null;
        }

        public final void setElbLoadBalancerLoggingParameters(
                ELBLoadBalancerLoggingParameters.BuilderImpl elbLoadBalancerLoggingParameters) {
            this.elbLoadBalancerLoggingParameters = elbLoadBalancerLoggingParameters != null ? elbLoadBalancerLoggingParameters
                    .build() : null;
        }

        @Override
        public final Builder elbLoadBalancerLoggingParameters(ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters) {
            this.elbLoadBalancerLoggingParameters = elbLoadBalancerLoggingParameters;
            return this;
        }

        public final WAFLoggingParameters.Builder getWafLoggingParameters() {
            return wafLoggingParameters != null ? wafLoggingParameters.toBuilder() : null;
        }

        public final void setWafLoggingParameters(WAFLoggingParameters.BuilderImpl wafLoggingParameters) {
            this.wafLoggingParameters = wafLoggingParameters != null ? wafLoggingParameters.build() : null;
        }

        @Override
        public final Builder wafLoggingParameters(WAFLoggingParameters wafLoggingParameters) {
            this.wafLoggingParameters = wafLoggingParameters;
            return this;
        }

        public final LogDeliveryParameters.Builder getLogDeliveryParameters() {
            return logDeliveryParameters != null ? logDeliveryParameters.toBuilder() : null;
        }

        public final void setLogDeliveryParameters(LogDeliveryParameters.BuilderImpl logDeliveryParameters) {
            this.logDeliveryParameters = logDeliveryParameters != null ? logDeliveryParameters.build() : null;
        }

        @Override
        public final Builder logDeliveryParameters(LogDeliveryParameters logDeliveryParameters) {
            this.logDeliveryParameters = logDeliveryParameters;
            return this;
        }

        @Override
        public TelemetryDestinationConfiguration build() {
            return new TelemetryDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
