/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListS3TableIntegrationsResponse extends ObservabilityAdminResponse implements
        ToCopyableBuilder<ListS3TableIntegrationsResponse.Builder, ListS3TableIntegrationsResponse> {
    private static final SdkField<List<IntegrationSummary>> INTEGRATION_SUMMARIES_FIELD = SdkField
            .<List<IntegrationSummary>> builder(MarshallingType.LIST)
            .memberName("IntegrationSummaries")
            .getter(getter(ListS3TableIntegrationsResponse::integrationSummaries))
            .setter(setter(Builder::integrationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegrationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegrationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListS3TableIntegrationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<IntegrationSummary> integrationSummaries;

    private final String nextToken;

    private ListS3TableIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.integrationSummaries = builder.integrationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegrationSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegrationSummaries() {
        return integrationSummaries != null && !(integrationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of S3 Table integration summaries containing key information about each integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegrationSummaries} method.
     * </p>
     * 
     * @return A list of S3 Table integration summaries containing key information about each integration.
     */
    public final List<IntegrationSummary> integrationSummaries() {
        return integrationSummaries;
    }

    /**
     * <p>
     * A token to resume pagination of results.
     * </p>
     * 
     * @return A token to resume pagination of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegrationSummaries() ? integrationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListS3TableIntegrationsResponse)) {
            return false;
        }
        ListS3TableIntegrationsResponse other = (ListS3TableIntegrationsResponse) obj;
        return hasIntegrationSummaries() == other.hasIntegrationSummaries()
                && Objects.equals(integrationSummaries(), other.integrationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListS3TableIntegrationsResponse")
                .add("IntegrationSummaries", hasIntegrationSummaries() ? integrationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationSummaries":
            return Optional.ofNullable(clazz.cast(integrationSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IntegrationSummaries", INTEGRATION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListS3TableIntegrationsResponse, T> g) {
        return obj -> g.apply((ListS3TableIntegrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListS3TableIntegrationsResponse> {
        /**
         * <p>
         * A list of S3 Table integration summaries containing key information about each integration.
         * </p>
         * 
         * @param integrationSummaries
         *        A list of S3 Table integration summaries containing key information about each integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationSummaries(Collection<IntegrationSummary> integrationSummaries);

        /**
         * <p>
         * A list of S3 Table integration summaries containing key information about each integration.
         * </p>
         * 
         * @param integrationSummaries
         *        A list of S3 Table integration summaries containing key information about each integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationSummaries(IntegrationSummary... integrationSummaries);

        /**
         * <p>
         * A list of S3 Table integration summaries containing key information about each integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.observabilityadmin.model.IntegrationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.observabilityadmin.model.IntegrationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.observabilityadmin.model.IntegrationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #integrationSummaries(List<IntegrationSummary>)}.
         * 
         * @param integrationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.observabilityadmin.model.IntegrationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationSummaries(java.util.Collection<IntegrationSummary>)
         */
        Builder integrationSummaries(Consumer<IntegrationSummary.Builder>... integrationSummaries);

        /**
         * <p>
         * A token to resume pagination of results.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ObservabilityAdminResponse.BuilderImpl implements Builder {
        private List<IntegrationSummary> integrationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListS3TableIntegrationsResponse model) {
            super(model);
            integrationSummaries(model.integrationSummaries);
            nextToken(model.nextToken);
        }

        public final List<IntegrationSummary.Builder> getIntegrationSummaries() {
            List<IntegrationSummary.Builder> result = IntegrationSummariesCopier.copyToBuilder(this.integrationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrationSummaries(Collection<IntegrationSummary.BuilderImpl> integrationSummaries) {
            this.integrationSummaries = IntegrationSummariesCopier.copyFromBuilder(integrationSummaries);
        }

        @Override
        public final Builder integrationSummaries(Collection<IntegrationSummary> integrationSummaries) {
            this.integrationSummaries = IntegrationSummariesCopier.copy(integrationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationSummaries(IntegrationSummary... integrationSummaries) {
            integrationSummaries(Arrays.asList(integrationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationSummaries(Consumer<IntegrationSummary.Builder>... integrationSummaries) {
            integrationSummaries(Stream.of(integrationSummaries).map(c -> IntegrationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListS3TableIntegrationsResponse build() {
            return new ListS3TableIntegrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
