/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceTelemetryRequest extends ObservabilityAdminRequest implements
        ToCopyableBuilder<ListResourceTelemetryRequest.Builder, ListResourceTelemetryRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifierPrefix").getter(getter(ListResourceTelemetryRequest::resourceIdentifierPrefix))
            .setter(setter(Builder::resourceIdentifierPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifierPrefix").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(ListResourceTelemetryRequest::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TELEMETRY_CONFIGURATION_STATE_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TelemetryConfigurationState")
            .getter(getter(ListResourceTelemetryRequest::telemetryConfigurationStateAsStrings))
            .setter(setter(Builder::telemetryConfigurationStateWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfigurationState")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ResourceTags")
            .getter(getter(ListResourceTelemetryRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResourceTelemetryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceTelemetryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_IDENTIFIER_PREFIX_FIELD, RESOURCE_TYPES_FIELD, TELEMETRY_CONFIGURATION_STATE_FIELD, RESOURCE_TAGS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceIdentifierPrefix;

    private final List<String> resourceTypes;

    private final Map<String, String> telemetryConfigurationState;

    private final Map<String, String> resourceTags;

    private final Integer maxResults;

    private final String nextToken;

    private ListResourceTelemetryRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifierPrefix = builder.resourceIdentifierPrefix;
        this.resourceTypes = builder.resourceTypes;
        this.telemetryConfigurationState = builder.telemetryConfigurationState;
        this.resourceTags = builder.resourceTags;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A string used to filter resources which have a <code>ResourceIdentifier</code> starting with the
     * <code>ResourceIdentifierPrefix</code>.
     * </p>
     * 
     * @return A string used to filter resources which have a <code>ResourceIdentifier</code> starting with the
     *         <code>ResourceIdentifierPrefix</code>.
     */
    public final String resourceIdentifierPrefix() {
        return resourceIdentifierPrefix;
    }

    /**
     * <p>
     * A list of resource types used to filter resources supported by telemetry config. If this parameter is provided,
     * the resources will be returned in the same order used in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return A list of resource types used to filter resources supported by telemetry config. If this parameter is
     *         provided, the resources will be returned in the same order used in the request.
     */
    public final List<ResourceType> resourceTypes() {
        return ResourceTypesCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource types used to filter resources supported by telemetry config. If this parameter is provided,
     * the resources will be returned in the same order used in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return A list of resource types used to filter resources supported by telemetry config. If this parameter is
     *         provided, the resources will be returned in the same order used in the request.
     */
    public final List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    /**
     * <p>
     * A key-value pair to filter resources based on the telemetry type and the state of the telemetry configuration.
     * The key is the telemetry type and the value is the state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTelemetryConfigurationState} method.
     * </p>
     * 
     * @return A key-value pair to filter resources based on the telemetry type and the state of the telemetry
     *         configuration. The key is the telemetry type and the value is the state.
     */
    public final Map<TelemetryType, TelemetryState> telemetryConfigurationState() {
        return TelemetryConfigurationStateCopier.copyStringToEnum(telemetryConfigurationState);
    }

    /**
     * For responses, this returns true if the service returned a value for the TelemetryConfigurationState property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTelemetryConfigurationState() {
        return telemetryConfigurationState != null && !(telemetryConfigurationState instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value pair to filter resources based on the telemetry type and the state of the telemetry configuration.
     * The key is the telemetry type and the value is the state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTelemetryConfigurationState} method.
     * </p>
     * 
     * @return A key-value pair to filter resources based on the telemetry type and the state of the telemetry
     *         configuration. The key is the telemetry type and the value is the state.
     */
    public final Map<String, String> telemetryConfigurationStateAsStrings() {
        return telemetryConfigurationState;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value pair to filter resources based on tags associated with the resource. For more information about tags,
     * see <a href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/what-are-tags.html">What are
     * tags?</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return A key-value pair to filter resources based on tags associated with the resource. For more information
     *         about tags, see <a
     *         href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/what-are-tags.html">What are
     *         tags?</a>
     */
    public final Map<String, String> resourceTags() {
        return resourceTags;
    }

    /**
     * <p>
     * A number field used to limit the number of results within the returned list.
     * </p>
     * 
     * @return A number field used to limit the number of results within the returned list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. A previous call generates this token.
     * </p>
     * 
     * @return The token for the next set of items to return. A previous call generates this token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifierPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasTelemetryConfigurationState() ? telemetryConfigurationStateAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTelemetryRequest)) {
            return false;
        }
        ListResourceTelemetryRequest other = (ListResourceTelemetryRequest) obj;
        return Objects.equals(resourceIdentifierPrefix(), other.resourceIdentifierPrefix())
                && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings())
                && hasTelemetryConfigurationState() == other.hasTelemetryConfigurationState()
                && Objects.equals(telemetryConfigurationStateAsStrings(), other.telemetryConfigurationStateAsStrings())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListResourceTelemetryRequest")
                .add("ResourceIdentifierPrefix", resourceIdentifierPrefix())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypesAsStrings() : null)
                .add("TelemetryConfigurationState",
                        hasTelemetryConfigurationState() ? telemetryConfigurationStateAsStrings() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifierPrefix":
            return Optional.ofNullable(clazz.cast(resourceIdentifierPrefix()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        case "TelemetryConfigurationState":
            return Optional.ofNullable(clazz.cast(telemetryConfigurationStateAsStrings()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceIdentifierPrefix", RESOURCE_IDENTIFIER_PREFIX_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("TelemetryConfigurationState", TELEMETRY_CONFIGURATION_STATE_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTelemetryRequest, T> g) {
        return obj -> g.apply((ListResourceTelemetryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceTelemetryRequest> {
        /**
         * <p>
         * A string used to filter resources which have a <code>ResourceIdentifier</code> starting with the
         * <code>ResourceIdentifierPrefix</code>.
         * </p>
         * 
         * @param resourceIdentifierPrefix
         *        A string used to filter resources which have a <code>ResourceIdentifier</code> starting with the
         *        <code>ResourceIdentifierPrefix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifierPrefix(String resourceIdentifierPrefix);

        /**
         * <p>
         * A list of resource types used to filter resources supported by telemetry config. If this parameter is
         * provided, the resources will be returned in the same order used in the request.
         * </p>
         * 
         * @param resourceTypes
         *        A list of resource types used to filter resources supported by telemetry config. If this parameter is
         *        provided, the resources will be returned in the same order used in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * A list of resource types used to filter resources supported by telemetry config. If this parameter is
         * provided, the resources will be returned in the same order used in the request.
         * </p>
         * 
         * @param resourceTypes
         *        A list of resource types used to filter resources supported by telemetry config. If this parameter is
         *        provided, the resources will be returned in the same order used in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * A list of resource types used to filter resources supported by telemetry config. If this parameter is
         * provided, the resources will be returned in the same order used in the request.
         * </p>
         * 
         * @param resourceTypes
         *        A list of resource types used to filter resources supported by telemetry config. If this parameter is
         *        provided, the resources will be returned in the same order used in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ResourceType> resourceTypes);

        /**
         * <p>
         * A list of resource types used to filter resources supported by telemetry config. If this parameter is
         * provided, the resources will be returned in the same order used in the request.
         * </p>
         * 
         * @param resourceTypes
         *        A list of resource types used to filter resources supported by telemetry config. If this parameter is
         *        provided, the resources will be returned in the same order used in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ResourceType... resourceTypes);

        /**
         * <p>
         * A key-value pair to filter resources based on the telemetry type and the state of the telemetry
         * configuration. The key is the telemetry type and the value is the state.
         * </p>
         * 
         * @param telemetryConfigurationState
         *        A key-value pair to filter resources based on the telemetry type and the state of the telemetry
         *        configuration. The key is the telemetry type and the value is the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryConfigurationStateWithStrings(Map<String, String> telemetryConfigurationState);

        /**
         * <p>
         * A key-value pair to filter resources based on the telemetry type and the state of the telemetry
         * configuration. The key is the telemetry type and the value is the state.
         * </p>
         * 
         * @param telemetryConfigurationState
         *        A key-value pair to filter resources based on the telemetry type and the state of the telemetry
         *        configuration. The key is the telemetry type and the value is the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryConfigurationState(Map<TelemetryType, TelemetryState> telemetryConfigurationState);

        /**
         * <p>
         * A key-value pair to filter resources based on tags associated with the resource. For more information about
         * tags, see <a
         * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/what-are-tags.html">What are
         * tags?</a>
         * </p>
         * 
         * @param resourceTags
         *        A key-value pair to filter resources based on tags associated with the resource. For more information
         *        about tags, see <a
         *        href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/what-are-tags.html">What
         *        are tags?</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Map<String, String> resourceTags);

        /**
         * <p>
         * A number field used to limit the number of results within the returned list.
         * </p>
         * 
         * @param maxResults
         *        A number field used to limit the number of results within the returned list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. A previous call generates this token.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. A previous call generates this token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ObservabilityAdminRequest.BuilderImpl implements Builder {
        private String resourceIdentifierPrefix;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> telemetryConfigurationState = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTelemetryRequest model) {
            super(model);
            resourceIdentifierPrefix(model.resourceIdentifierPrefix);
            resourceTypesWithStrings(model.resourceTypes);
            telemetryConfigurationStateWithStrings(model.telemetryConfigurationState);
            resourceTags(model.resourceTags);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getResourceIdentifierPrefix() {
            return resourceIdentifierPrefix;
        }

        public final void setResourceIdentifierPrefix(String resourceIdentifierPrefix) {
            this.resourceIdentifierPrefix = resourceIdentifierPrefix;
        }

        @Override
        public final Builder resourceIdentifierPrefix(String resourceIdentifierPrefix) {
            this.resourceIdentifierPrefix = resourceIdentifierPrefix;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Map<String, String> getTelemetryConfigurationState() {
            if (telemetryConfigurationState instanceof SdkAutoConstructMap) {
                return null;
            }
            return telemetryConfigurationState;
        }

        public final void setTelemetryConfigurationState(Map<String, String> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copy(telemetryConfigurationState);
        }

        @Override
        public final Builder telemetryConfigurationStateWithStrings(Map<String, String> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copy(telemetryConfigurationState);
            return this;
        }

        @Override
        public final Builder telemetryConfigurationState(Map<TelemetryType, TelemetryState> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copyEnumToString(telemetryConfigurationState);
            return this;
        }

        public final Map<String, String> getResourceTags() {
            if (resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapInputCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapInputCopier.copy(resourceTags);
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceTelemetryRequest build() {
            return new ListResourceTelemetryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
