/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for centralization destination log groups, including encryption and backup settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationLogsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationLogsConfiguration.Builder, DestinationLogsConfiguration> {
    private static final SdkField<LogsEncryptionConfiguration> LOGS_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<LogsEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LogsEncryptionConfiguration")
            .getter(getter(DestinationLogsConfiguration::logsEncryptionConfiguration))
            .setter(setter(Builder::logsEncryptionConfiguration))
            .constructor(LogsEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<LogsBackupConfiguration> BACKUP_CONFIGURATION_FIELD = SdkField
            .<LogsBackupConfiguration> builder(MarshallingType.SDK_POJO).memberName("BackupConfiguration")
            .getter(getter(DestinationLogsConfiguration::backupConfiguration)).setter(setter(Builder::backupConfiguration))
            .constructor(LogsBackupConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOGS_ENCRYPTION_CONFIGURATION_FIELD, BACKUP_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LogsEncryptionConfiguration logsEncryptionConfiguration;

    private final LogsBackupConfiguration backupConfiguration;

    private DestinationLogsConfiguration(BuilderImpl builder) {
        this.logsEncryptionConfiguration = builder.logsEncryptionConfiguration;
        this.backupConfiguration = builder.backupConfiguration;
    }

    /**
     * <p>
     * The encryption configuration for centralization destination log groups.
     * </p>
     * 
     * @return The encryption configuration for centralization destination log groups.
     */
    public final LogsEncryptionConfiguration logsEncryptionConfiguration() {
        return logsEncryptionConfiguration;
    }

    /**
     * <p>
     * Configuration defining the backup region and an optional KMS key for the backup destination.
     * </p>
     * 
     * @return Configuration defining the backup region and an optional KMS key for the backup destination.
     */
    public final LogsBackupConfiguration backupConfiguration() {
        return backupConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logsEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(backupConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationLogsConfiguration)) {
            return false;
        }
        DestinationLogsConfiguration other = (DestinationLogsConfiguration) obj;
        return Objects.equals(logsEncryptionConfiguration(), other.logsEncryptionConfiguration())
                && Objects.equals(backupConfiguration(), other.backupConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationLogsConfiguration").add("LogsEncryptionConfiguration", logsEncryptionConfiguration())
                .add("BackupConfiguration", backupConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogsEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(logsEncryptionConfiguration()));
        case "BackupConfiguration":
            return Optional.ofNullable(clazz.cast(backupConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogsEncryptionConfiguration", LOGS_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("BackupConfiguration", BACKUP_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationLogsConfiguration, T> g) {
        return obj -> g.apply((DestinationLogsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationLogsConfiguration> {
        /**
         * <p>
         * The encryption configuration for centralization destination log groups.
         * </p>
         * 
         * @param logsEncryptionConfiguration
         *        The encryption configuration for centralization destination log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsEncryptionConfiguration(LogsEncryptionConfiguration logsEncryptionConfiguration);

        /**
         * <p>
         * The encryption configuration for centralization destination log groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogsEncryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link LogsEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logsEncryptionConfiguration(LogsEncryptionConfiguration)}.
         * 
         * @param logsEncryptionConfiguration
         *        a consumer that will call methods on {@link LogsEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsEncryptionConfiguration(LogsEncryptionConfiguration)
         */
        default Builder logsEncryptionConfiguration(Consumer<LogsEncryptionConfiguration.Builder> logsEncryptionConfiguration) {
            return logsEncryptionConfiguration(LogsEncryptionConfiguration.builder().applyMutation(logsEncryptionConfiguration)
                    .build());
        }

        /**
         * <p>
         * Configuration defining the backup region and an optional KMS key for the backup destination.
         * </p>
         * 
         * @param backupConfiguration
         *        Configuration defining the backup region and an optional KMS key for the backup destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupConfiguration(LogsBackupConfiguration backupConfiguration);

        /**
         * <p>
         * Configuration defining the backup region and an optional KMS key for the backup destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogsBackupConfiguration.Builder} avoiding
         * the need to create one manually via {@link LogsBackupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsBackupConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #backupConfiguration(LogsBackupConfiguration)}.
         * 
         * @param backupConfiguration
         *        a consumer that will call methods on {@link LogsBackupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupConfiguration(LogsBackupConfiguration)
         */
        default Builder backupConfiguration(Consumer<LogsBackupConfiguration.Builder> backupConfiguration) {
            return backupConfiguration(LogsBackupConfiguration.builder().applyMutation(backupConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LogsEncryptionConfiguration logsEncryptionConfiguration;

        private LogsBackupConfiguration backupConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationLogsConfiguration model) {
            logsEncryptionConfiguration(model.logsEncryptionConfiguration);
            backupConfiguration(model.backupConfiguration);
        }

        public final LogsEncryptionConfiguration.Builder getLogsEncryptionConfiguration() {
            return logsEncryptionConfiguration != null ? logsEncryptionConfiguration.toBuilder() : null;
        }

        public final void setLogsEncryptionConfiguration(LogsEncryptionConfiguration.BuilderImpl logsEncryptionConfiguration) {
            this.logsEncryptionConfiguration = logsEncryptionConfiguration != null ? logsEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder logsEncryptionConfiguration(LogsEncryptionConfiguration logsEncryptionConfiguration) {
            this.logsEncryptionConfiguration = logsEncryptionConfiguration;
            return this;
        }

        public final LogsBackupConfiguration.Builder getBackupConfiguration() {
            return backupConfiguration != null ? backupConfiguration.toBuilder() : null;
        }

        public final void setBackupConfiguration(LogsBackupConfiguration.BuilderImpl backupConfiguration) {
            this.backupConfiguration = backupConfiguration != null ? backupConfiguration.build() : null;
        }

        @Override
        public final Builder backupConfiguration(LogsBackupConfiguration backupConfiguration) {
            this.backupConfiguration = backupConfiguration;
            return this;
        }

        @Override
        public DestinationLogsConfiguration build() {
            return new DestinationLogsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
