/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummariesCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTelemetryRulesResponse
extends ObservabilityAdminResponse
implements ToCopyableBuilder<Builder, ListTelemetryRulesResponse> {
    private static final SdkField<List<TelemetryRuleSummary>> TELEMETRY_RULE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TelemetryRuleSummaries").getter(ListTelemetryRulesResponse.getter(ListTelemetryRulesResponse::telemetryRuleSummaries)).setter(ListTelemetryRulesResponse.setter(Builder::telemetryRuleSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryRuleSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TelemetryRuleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTelemetryRulesResponse.getter(ListTelemetryRulesResponse::nextToken)).setter(ListTelemetryRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_RULE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTelemetryRulesResponse.memberNameToFieldInitializer();
    private final List<TelemetryRuleSummary> telemetryRuleSummaries;
    private final String nextToken;

    private ListTelemetryRulesResponse(BuilderImpl builder) {
        super(builder);
        this.telemetryRuleSummaries = builder.telemetryRuleSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTelemetryRuleSummaries() {
        return this.telemetryRuleSummaries != null && !(this.telemetryRuleSummaries instanceof SdkAutoConstructList);
    }

    public final List<TelemetryRuleSummary> telemetryRuleSummaries() {
        return this.telemetryRuleSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetryRuleSummaries() ? this.telemetryRuleSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTelemetryRulesResponse)) {
            return false;
        }
        ListTelemetryRulesResponse other = (ListTelemetryRulesResponse)((Object)obj);
        return this.hasTelemetryRuleSummaries() == other.hasTelemetryRuleSummaries() && Objects.equals(this.telemetryRuleSummaries(), other.telemetryRuleSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTelemetryRulesResponse").add("TelemetryRuleSummaries", this.hasTelemetryRuleSummaries() ? this.telemetryRuleSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TelemetryRuleSummaries": {
                return Optional.ofNullable(clazz.cast(this.telemetryRuleSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TelemetryRuleSummaries", TELEMETRY_RULE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTelemetryRulesResponse, T> g) {
        return obj -> g.apply((ListTelemetryRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminResponse.BuilderImpl
    implements Builder {
        private List<TelemetryRuleSummary> telemetryRuleSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTelemetryRulesResponse model) {
            super(model);
            this.telemetryRuleSummaries(model.telemetryRuleSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<TelemetryRuleSummary.Builder> getTelemetryRuleSummaries() {
            List<TelemetryRuleSummary.Builder> result = TelemetryRuleSummariesCopier.copyToBuilder(this.telemetryRuleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTelemetryRuleSummaries(Collection<TelemetryRuleSummary.BuilderImpl> telemetryRuleSummaries) {
            this.telemetryRuleSummaries = TelemetryRuleSummariesCopier.copyFromBuilder(telemetryRuleSummaries);
        }

        @Override
        public final Builder telemetryRuleSummaries(Collection<TelemetryRuleSummary> telemetryRuleSummaries) {
            this.telemetryRuleSummaries = TelemetryRuleSummariesCopier.copy(telemetryRuleSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRuleSummaries(TelemetryRuleSummary ... telemetryRuleSummaries) {
            this.telemetryRuleSummaries(Arrays.asList(telemetryRuleSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRuleSummaries(Consumer<TelemetryRuleSummary.Builder> ... telemetryRuleSummaries) {
            this.telemetryRuleSummaries(Stream.of(telemetryRuleSummaries).map(c -> (TelemetryRuleSummary)((TelemetryRuleSummary.Builder)TelemetryRuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTelemetryRulesResponse build() {
            return new ListTelemetryRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTelemetryRulesResponse> {
        public Builder telemetryRuleSummaries(Collection<TelemetryRuleSummary> var1);

        public Builder telemetryRuleSummaries(TelemetryRuleSummary ... var1);

        public Builder telemetryRuleSummaries(Consumer<TelemetryRuleSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

