/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration;

public class ListResourceTelemetryIterable
implements SdkIterable<ListResourceTelemetryResponse> {
    private final ObservabilityAdminClient client;
    private final ListResourceTelemetryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceTelemetryIterable(ObservabilityAdminClient client, ListResourceTelemetryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceTelemetryResponseFetcher();
    }

    public Iterator<ListResourceTelemetryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TelemetryConfiguration> telemetryConfigurations() {
        Function<ListResourceTelemetryResponse, Iterator> getIterator = response -> {
            if (response != null && response.telemetryConfigurations() != null) {
                return response.telemetryConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceTelemetryResponseFetcher
    implements SyncPageFetcher<ListResourceTelemetryResponse> {
        private ListResourceTelemetryResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTelemetryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceTelemetryResponse nextPage(ListResourceTelemetryResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTelemetryIterable.this.client.listResourceTelemetry(ListResourceTelemetryIterable.this.firstRequest);
            }
            return ListResourceTelemetryIterable.this.client.listResourceTelemetry((ListResourceTelemetryRequest)((Object)ListResourceTelemetryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

