/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceTelemetryResponse
extends ObservabilityAdminResponse
implements ToCopyableBuilder<Builder, ListResourceTelemetryResponse> {
    private static final SdkField<List<TelemetryConfiguration>> TELEMETRY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TelemetryConfigurations").getter(ListResourceTelemetryResponse.getter(ListResourceTelemetryResponse::telemetryConfigurations)).setter(ListResourceTelemetryResponse.setter(Builder::telemetryConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TelemetryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceTelemetryResponse.getter(ListResourceTelemetryResponse::nextToken)).setter(ListResourceTelemetryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TelemetryConfigurations", TELEMETRY_CONFIGURATIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TelemetryConfiguration> telemetryConfigurations;
    private final String nextToken;

    private ListResourceTelemetryResponse(BuilderImpl builder) {
        super(builder);
        this.telemetryConfigurations = builder.telemetryConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTelemetryConfigurations() {
        return this.telemetryConfigurations != null && !(this.telemetryConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TelemetryConfiguration> telemetryConfigurations() {
        return this.telemetryConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetryConfigurations() ? this.telemetryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTelemetryResponse)) {
            return false;
        }
        ListResourceTelemetryResponse other = (ListResourceTelemetryResponse)((Object)obj);
        return this.hasTelemetryConfigurations() == other.hasTelemetryConfigurations() && Objects.equals(this.telemetryConfigurations(), other.telemetryConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceTelemetryResponse").add("TelemetryConfigurations", this.hasTelemetryConfigurations() ? this.telemetryConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TelemetryConfigurations": {
                return Optional.ofNullable(clazz.cast(this.telemetryConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTelemetryResponse, T> g) {
        return obj -> g.apply((ListResourceTelemetryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminResponse.BuilderImpl
    implements Builder {
        private List<TelemetryConfiguration> telemetryConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTelemetryResponse model) {
            super(model);
            this.telemetryConfigurations(model.telemetryConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<TelemetryConfiguration.Builder> getTelemetryConfigurations() {
            List<TelemetryConfiguration.Builder> result = TelemetryConfigurationsCopier.copyToBuilder(this.telemetryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTelemetryConfigurations(Collection<TelemetryConfiguration.BuilderImpl> telemetryConfigurations) {
            this.telemetryConfigurations = TelemetryConfigurationsCopier.copyFromBuilder(telemetryConfigurations);
        }

        @Override
        public final Builder telemetryConfigurations(Collection<TelemetryConfiguration> telemetryConfigurations) {
            this.telemetryConfigurations = TelemetryConfigurationsCopier.copy(telemetryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryConfigurations(TelemetryConfiguration ... telemetryConfigurations) {
            this.telemetryConfigurations(Arrays.asList(telemetryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryConfigurations(Consumer<TelemetryConfiguration.Builder> ... telemetryConfigurations) {
            this.telemetryConfigurations(Stream.of(telemetryConfigurations).map(c -> (TelemetryConfiguration)((TelemetryConfiguration.Builder)TelemetryConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceTelemetryResponse build() {
            return new ListResourceTelemetryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ObservabilityAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceTelemetryResponse> {
        public Builder telemetryConfigurations(Collection<TelemetryConfiguration> var1);

        public Builder telemetryConfigurations(TelemetryConfiguration ... var1);

        public Builder telemetryConfigurations(Consumer<TelemetryConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

