/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.oam.model.LinkConfiguration;
import software.amazon.awssdk.services.oam.model.OamRequest;
import software.amazon.awssdk.services.oam.model.ResourceType;
import software.amazon.awssdk.services.oam.model.ResourceTypesInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLinkRequest
extends OamRequest
implements ToCopyableBuilder<Builder, UpdateLinkRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateLinkRequest.getter(UpdateLinkRequest::identifier)).setter(UpdateLinkRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTags").getter(UpdateLinkRequest.getter(UpdateLinkRequest::includeTags)).setter(UpdateLinkRequest.setter(Builder::includeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTags").build()}).build();
    private static final SdkField<LinkConfiguration> LINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinkConfiguration").getter(UpdateLinkRequest.getter(UpdateLinkRequest::linkConfiguration)).setter(UpdateLinkRequest.setter(Builder::linkConfiguration)).constructor(LinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkConfiguration").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(UpdateLinkRequest.getter(UpdateLinkRequest::resourceTypesAsStrings)).setter(UpdateLinkRequest.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, INCLUDE_TAGS_FIELD, LINK_CONFIGURATION_FIELD, RESOURCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLinkRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final Boolean includeTags;
    private final LinkConfiguration linkConfiguration;
    private final List<String> resourceTypes;

    private UpdateLinkRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.includeTags = builder.includeTags;
        this.linkConfiguration = builder.linkConfiguration;
        this.resourceTypes = builder.resourceTypes;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final Boolean includeTags() {
        return this.includeTags;
    }

    public final LinkConfiguration linkConfiguration() {
        return this.linkConfiguration;
    }

    public final List<ResourceType> resourceTypes() {
        return ResourceTypesInputCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkRequest)) {
            return false;
        }
        UpdateLinkRequest other = (UpdateLinkRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.includeTags(), other.includeTags()) && Objects.equals(this.linkConfiguration(), other.linkConfiguration()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLinkRequest").add("Identifier", (Object)this.identifier()).add("IncludeTags", (Object)this.includeTags()).add("LinkConfiguration", (Object)this.linkConfiguration()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "IncludeTags": {
                return Optional.ofNullable(clazz.cast(this.includeTags()));
            }
            case "LinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.linkConfiguration()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("IncludeTags", INCLUDE_TAGS_FIELD);
        map.put("LinkConfiguration", LINK_CONFIGURATION_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLinkRequest, T> g) {
        return obj -> g.apply((UpdateLinkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OamRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private Boolean includeTags;
        private LinkConfiguration linkConfiguration;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLinkRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.includeTags(model.includeTags);
            this.linkConfiguration(model.linkConfiguration);
            this.resourceTypesWithStrings(model.resourceTypes);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Boolean getIncludeTags() {
            return this.includeTags;
        }

        public final void setIncludeTags(Boolean includeTags) {
            this.includeTags = includeTags;
        }

        @Override
        public final Builder includeTags(Boolean includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        public final LinkConfiguration.Builder getLinkConfiguration() {
            return this.linkConfiguration != null ? this.linkConfiguration.toBuilder() : null;
        }

        public final void setLinkConfiguration(LinkConfiguration.BuilderImpl linkConfiguration) {
            this.linkConfiguration = linkConfiguration != null ? linkConfiguration.build() : null;
        }

        @Override
        public final Builder linkConfiguration(LinkConfiguration linkConfiguration) {
            this.linkConfiguration = linkConfiguration;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLinkRequest build() {
            return new UpdateLinkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLinkRequest> {
        public Builder identifier(String var1);

        public Builder includeTags(Boolean var1);

        public Builder linkConfiguration(LinkConfiguration var1);

        default public Builder linkConfiguration(Consumer<LinkConfiguration.Builder> linkConfiguration) {
            return this.linkConfiguration((LinkConfiguration)((LinkConfiguration.Builder)LinkConfiguration.builder().applyMutation(linkConfiguration)).build());
        }

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceType> var1);

        public Builder resourceTypes(ResourceType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

