/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.novaact.model.CompatibilityInformation;
import software.amazon.awssdk.services.novaact.model.ModelAlias;
import software.amazon.awssdk.services.novaact.model.ModelAliasesCopier;
import software.amazon.awssdk.services.novaact.model.ModelSummariesCopier;
import software.amazon.awssdk.services.novaact.model.ModelSummary;
import software.amazon.awssdk.services.novaact.model.NovaActResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelsResponse
extends NovaActResponse
implements ToCopyableBuilder<Builder, ListModelsResponse> {
    private static final SdkField<List<ModelSummary>> MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelSummaries").getter(ListModelsResponse.getter(ListModelsResponse::modelSummaries)).setter(ListModelsResponse.setter(Builder::modelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ModelAlias>> MODEL_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelAliases").getter(ListModelsResponse.getter(ListModelsResponse::modelAliases)).setter(ListModelsResponse.setter(Builder::modelAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CompatibilityInformation> COMPATIBILITY_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("compatibilityInformation").getter(ListModelsResponse.getter(ListModelsResponse::compatibilityInformation)).setter(ListModelsResponse.setter(Builder::compatibilityInformation)).constructor(CompatibilityInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibilityInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_SUMMARIES_FIELD, MODEL_ALIASES_FIELD, COMPATIBILITY_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelsResponse.memberNameToFieldInitializer();
    private final List<ModelSummary> modelSummaries;
    private final List<ModelAlias> modelAliases;
    private final CompatibilityInformation compatibilityInformation;

    private ListModelsResponse(BuilderImpl builder) {
        super(builder);
        this.modelSummaries = builder.modelSummaries;
        this.modelAliases = builder.modelAliases;
        this.compatibilityInformation = builder.compatibilityInformation;
    }

    public final boolean hasModelSummaries() {
        return this.modelSummaries != null && !(this.modelSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelSummary> modelSummaries() {
        return this.modelSummaries;
    }

    public final boolean hasModelAliases() {
        return this.modelAliases != null && !(this.modelAliases instanceof SdkAutoConstructList);
    }

    public final List<ModelAlias> modelAliases() {
        return this.modelAliases;
    }

    public final CompatibilityInformation compatibilityInformation() {
        return this.compatibilityInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelSummaries() ? this.modelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelAliases() ? this.modelAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibilityInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelsResponse)) {
            return false;
        }
        ListModelsResponse other = (ListModelsResponse)((Object)obj);
        return this.hasModelSummaries() == other.hasModelSummaries() && Objects.equals(this.modelSummaries(), other.modelSummaries()) && this.hasModelAliases() == other.hasModelAliases() && Objects.equals(this.modelAliases(), other.modelAliases()) && Objects.equals(this.compatibilityInformation(), other.compatibilityInformation());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelsResponse").add("ModelSummaries", this.hasModelSummaries() ? this.modelSummaries() : null).add("ModelAliases", this.hasModelAliases() ? this.modelAliases() : null).add("CompatibilityInformation", (Object)this.compatibilityInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelSummaries()));
            }
            case "modelAliases": {
                return Optional.ofNullable(clazz.cast(this.modelAliases()));
            }
            case "compatibilityInformation": {
                return Optional.ofNullable(clazz.cast(this.compatibilityInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelSummaries", MODEL_SUMMARIES_FIELD);
        map.put("modelAliases", MODEL_ALIASES_FIELD);
        map.put("compatibilityInformation", COMPATIBILITY_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelsResponse, T> g) {
        return obj -> g.apply((ListModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActResponse.BuilderImpl
    implements Builder {
        private List<ModelSummary> modelSummaries = DefaultSdkAutoConstructList.getInstance();
        private List<ModelAlias> modelAliases = DefaultSdkAutoConstructList.getInstance();
        private CompatibilityInformation compatibilityInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelsResponse model) {
            super(model);
            this.modelSummaries(model.modelSummaries);
            this.modelAliases(model.modelAliases);
            this.compatibilityInformation(model.compatibilityInformation);
        }

        public final List<ModelSummary.Builder> getModelSummaries() {
            List<ModelSummary.Builder> result = ModelSummariesCopier.copyToBuilder(this.modelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelSummaries(Collection<ModelSummary.BuilderImpl> modelSummaries) {
            this.modelSummaries = ModelSummariesCopier.copyFromBuilder(modelSummaries);
        }

        @Override
        public final Builder modelSummaries(Collection<ModelSummary> modelSummaries) {
            this.modelSummaries = ModelSummariesCopier.copy(modelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(ModelSummary ... modelSummaries) {
            this.modelSummaries(Arrays.asList(modelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(Consumer<ModelSummary.Builder> ... modelSummaries) {
            this.modelSummaries(Stream.of(modelSummaries).map(c -> (ModelSummary)((ModelSummary.Builder)ModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ModelAlias.Builder> getModelAliases() {
            List<ModelAlias.Builder> result = ModelAliasesCopier.copyToBuilder(this.modelAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelAliases(Collection<ModelAlias.BuilderImpl> modelAliases) {
            this.modelAliases = ModelAliasesCopier.copyFromBuilder(modelAliases);
        }

        @Override
        public final Builder modelAliases(Collection<ModelAlias> modelAliases) {
            this.modelAliases = ModelAliasesCopier.copy(modelAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelAliases(ModelAlias ... modelAliases) {
            this.modelAliases(Arrays.asList(modelAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelAliases(Consumer<ModelAlias.Builder> ... modelAliases) {
            this.modelAliases(Stream.of(modelAliases).map(c -> (ModelAlias)((ModelAlias.Builder)ModelAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CompatibilityInformation.Builder getCompatibilityInformation() {
            return this.compatibilityInformation != null ? this.compatibilityInformation.toBuilder() : null;
        }

        public final void setCompatibilityInformation(CompatibilityInformation.BuilderImpl compatibilityInformation) {
            this.compatibilityInformation = compatibilityInformation != null ? compatibilityInformation.build() : null;
        }

        @Override
        public final Builder compatibilityInformation(CompatibilityInformation compatibilityInformation) {
            this.compatibilityInformation = compatibilityInformation;
            return this;
        }

        @Override
        public ListModelsResponse build() {
            return new ListModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelsResponse> {
        public Builder modelSummaries(Collection<ModelSummary> var1);

        public Builder modelSummaries(ModelSummary ... var1);

        public Builder modelSummaries(Consumer<ModelSummary.Builder> ... var1);

        public Builder modelAliases(Collection<ModelAlias> var1);

        public Builder modelAliases(ModelAlias ... var1);

        public Builder modelAliases(Consumer<ModelAlias.Builder> ... var1);

        public Builder compatibilityInformation(CompatibilityInformation var1);

        default public Builder compatibilityInformation(Consumer<CompatibilityInformation.Builder> compatibilityInformation) {
            return this.compatibilityInformation((CompatibilityInformation)((CompatibilityInformation.Builder)CompatibilityInformation.builder().applyMutation(compatibilityInformation)).build());
        }
    }
}

