/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.novaact.model.ClientInfo;
import software.amazon.awssdk.services.novaact.model.NovaActRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowRunRequest
extends NovaActRequest
implements ToCopyableBuilder<Builder, CreateWorkflowRunRequest> {
    private static final SdkField<String> WORKFLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowDefinitionName").getter(CreateWorkflowRunRequest.getter(CreateWorkflowRunRequest::workflowDefinitionName)).setter(CreateWorkflowRunRequest.setter(Builder::workflowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowDefinitionName").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(CreateWorkflowRunRequest.getter(CreateWorkflowRunRequest::modelId)).setter(CreateWorkflowRunRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateWorkflowRunRequest.getter(CreateWorkflowRunRequest::clientToken)).setter(CreateWorkflowRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(CreateWorkflowRunRequest.getter(CreateWorkflowRunRequest::logGroupName)).setter(CreateWorkflowRunRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<ClientInfo> CLIENT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("clientInfo").getter(CreateWorkflowRunRequest.getter(CreateWorkflowRunRequest::clientInfo)).setter(CreateWorkflowRunRequest.setter(Builder::clientInfo)).constructor(ClientInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_DEFINITION_NAME_FIELD, MODEL_ID_FIELD, CLIENT_TOKEN_FIELD, LOG_GROUP_NAME_FIELD, CLIENT_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkflowRunRequest.memberNameToFieldInitializer();
    private final String workflowDefinitionName;
    private final String modelId;
    private final String clientToken;
    private final String logGroupName;
    private final ClientInfo clientInfo;

    private CreateWorkflowRunRequest(BuilderImpl builder) {
        super(builder);
        this.workflowDefinitionName = builder.workflowDefinitionName;
        this.modelId = builder.modelId;
        this.clientToken = builder.clientToken;
        this.logGroupName = builder.logGroupName;
        this.clientInfo = builder.clientInfo;
    }

    public final String workflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final ClientInfo clientInfo() {
        return this.clientInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRunRequest)) {
            return false;
        }
        CreateWorkflowRunRequest other = (CreateWorkflowRunRequest)((Object)obj);
        return Objects.equals(this.workflowDefinitionName(), other.workflowDefinitionName()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.clientInfo(), other.clientInfo());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowRunRequest").add("WorkflowDefinitionName", (Object)this.workflowDefinitionName()).add("ModelId", (Object)this.modelId()).add("ClientToken", (Object)this.clientToken()).add("LogGroupName", (Object)this.logGroupName()).add("ClientInfo", (Object)this.clientInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.workflowDefinitionName()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "clientInfo": {
                return Optional.ofNullable(clazz.cast(this.clientInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowDefinitionName", WORKFLOW_DEFINITION_NAME_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("clientInfo", CLIENT_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRunRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActRequest.BuilderImpl
    implements Builder {
        private String workflowDefinitionName;
        private String modelId;
        private String clientToken;
        private String logGroupName;
        private ClientInfo clientInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRunRequest model) {
            super(model);
            this.workflowDefinitionName(model.workflowDefinitionName);
            this.modelId(model.modelId);
            this.clientToken(model.clientToken);
            this.logGroupName(model.logGroupName);
            this.clientInfo(model.clientInfo);
        }

        public final String getWorkflowDefinitionName() {
            return this.workflowDefinitionName;
        }

        public final void setWorkflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
        }

        @Override
        public final Builder workflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final ClientInfo.Builder getClientInfo() {
            return this.clientInfo != null ? this.clientInfo.toBuilder() : null;
        }

        public final void setClientInfo(ClientInfo.BuilderImpl clientInfo) {
            this.clientInfo = clientInfo != null ? clientInfo.build() : null;
        }

        @Override
        public final Builder clientInfo(ClientInfo clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRunRequest build() {
            return new CreateWorkflowRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowRunRequest> {
        public Builder workflowDefinitionName(String var1);

        public Builder modelId(String var1);

        public Builder clientToken(String var1);

        public Builder logGroupName(String var1);

        public Builder clientInfo(ClientInfo var1);

        default public Builder clientInfo(Consumer<ClientInfo.Builder> clientInfo) {
            return this.clientInfo((ClientInfo)((ClientInfo.Builder)ClientInfo.builder().applyMutation(clientInfo)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

