/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.novaact.model.ActError;
import software.amazon.awssdk.services.novaact.model.ActStatus;
import software.amazon.awssdk.services.novaact.model.NovaActRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateActRequest
extends NovaActRequest
implements ToCopyableBuilder<Builder, UpdateActRequest> {
    private static final SdkField<String> WORKFLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowDefinitionName").getter(UpdateActRequest.getter(UpdateActRequest::workflowDefinitionName)).setter(UpdateActRequest.setter(Builder::workflowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowDefinitionName").build()}).build();
    private static final SdkField<String> WORKFLOW_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowRunId").getter(UpdateActRequest.getter(UpdateActRequest::workflowRunId)).setter(UpdateActRequest.setter(Builder::workflowRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowRunId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateActRequest.getter(UpdateActRequest::sessionId)).setter(UpdateActRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> ACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actId").getter(UpdateActRequest.getter(UpdateActRequest::actId)).setter(UpdateActRequest.setter(Builder::actId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("actId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateActRequest.getter(UpdateActRequest::statusAsString)).setter(UpdateActRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ActError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(UpdateActRequest.getter(UpdateActRequest::error)).setter(UpdateActRequest.setter(Builder::error)).constructor(ActError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_DEFINITION_NAME_FIELD, WORKFLOW_RUN_ID_FIELD, SESSION_ID_FIELD, ACT_ID_FIELD, STATUS_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateActRequest.memberNameToFieldInitializer();
    private final String workflowDefinitionName;
    private final String workflowRunId;
    private final String sessionId;
    private final String actId;
    private final String status;
    private final ActError error;

    private UpdateActRequest(BuilderImpl builder) {
        super(builder);
        this.workflowDefinitionName = builder.workflowDefinitionName;
        this.workflowRunId = builder.workflowRunId;
        this.sessionId = builder.sessionId;
        this.actId = builder.actId;
        this.status = builder.status;
        this.error = builder.error;
    }

    public final String workflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public final String workflowRunId() {
        return this.workflowRunId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String actId() {
        return this.actId;
    }

    public final ActStatus status() {
        return ActStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ActError error() {
        return this.error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateActRequest)) {
            return false;
        }
        UpdateActRequest other = (UpdateActRequest)((Object)obj);
        return Objects.equals(this.workflowDefinitionName(), other.workflowDefinitionName()) && Objects.equals(this.workflowRunId(), other.workflowRunId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.actId(), other.actId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateActRequest").add("WorkflowDefinitionName", (Object)this.workflowDefinitionName()).add("WorkflowRunId", (Object)this.workflowRunId()).add("SessionId", (Object)this.sessionId()).add("ActId", (Object)this.actId()).add("Status", (Object)this.statusAsString()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.workflowDefinitionName()));
            }
            case "workflowRunId": {
                return Optional.ofNullable(clazz.cast(this.workflowRunId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "actId": {
                return Optional.ofNullable(clazz.cast(this.actId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowDefinitionName", WORKFLOW_DEFINITION_NAME_FIELD);
        map.put("workflowRunId", WORKFLOW_RUN_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("actId", ACT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateActRequest, T> g) {
        return obj -> g.apply((UpdateActRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActRequest.BuilderImpl
    implements Builder {
        private String workflowDefinitionName;
        private String workflowRunId;
        private String sessionId;
        private String actId;
        private String status;
        private ActError error;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateActRequest model) {
            super(model);
            this.workflowDefinitionName(model.workflowDefinitionName);
            this.workflowRunId(model.workflowRunId);
            this.sessionId(model.sessionId);
            this.actId(model.actId);
            this.status(model.status);
            this.error(model.error);
        }

        public final String getWorkflowDefinitionName() {
            return this.workflowDefinitionName;
        }

        public final void setWorkflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
        }

        @Override
        public final Builder workflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
            return this;
        }

        public final String getWorkflowRunId() {
            return this.workflowRunId;
        }

        public final void setWorkflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
        }

        @Override
        public final Builder workflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getActId() {
            return this.actId;
        }

        public final void setActId(String actId) {
            this.actId = actId;
        }

        @Override
        public final Builder actId(String actId) {
            this.actId = actId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ActError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ActError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ActError error) {
            this.error = error;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateActRequest build() {
            return new UpdateActRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateActRequest> {
        public Builder workflowDefinitionName(String var1);

        public Builder workflowRunId(String var1);

        public Builder sessionId(String var1);

        public Builder actId(String var1);

        public Builder status(String var1);

        public Builder status(ActStatus var1);

        public Builder error(ActError var1);

        default public Builder error(Consumer<ActError.Builder> error) {
            return this.error((ActError)((ActError.Builder)ActError.builder().applyMutation(error)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

