/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.novaact.model.NovaActRequest;
import software.amazon.awssdk.services.novaact.model.ToolSpec;
import software.amazon.awssdk.services.novaact.model.ToolSpecsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateActRequest
extends NovaActRequest
implements ToCopyableBuilder<Builder, CreateActRequest> {
    private static final SdkField<String> WORKFLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowDefinitionName").getter(CreateActRequest.getter(CreateActRequest::workflowDefinitionName)).setter(CreateActRequest.setter(Builder::workflowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowDefinitionName").build()}).build();
    private static final SdkField<String> WORKFLOW_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowRunId").getter(CreateActRequest.getter(CreateActRequest::workflowRunId)).setter(CreateActRequest.setter(Builder::workflowRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowRunId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(CreateActRequest.getter(CreateActRequest::sessionId)).setter(CreateActRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("task").getter(CreateActRequest.getter(CreateActRequest::task)).setter(CreateActRequest.setter(Builder::task)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()}).build();
    private static final SdkField<List<ToolSpec>> TOOL_SPECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("toolSpecs").getter(CreateActRequest.getter(CreateActRequest::toolSpecs)).setter(CreateActRequest.setter(Builder::toolSpecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolSpecs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToolSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateActRequest.getter(CreateActRequest::clientToken)).setter(CreateActRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_DEFINITION_NAME_FIELD, WORKFLOW_RUN_ID_FIELD, SESSION_ID_FIELD, TASK_FIELD, TOOL_SPECS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateActRequest.memberNameToFieldInitializer();
    private final String workflowDefinitionName;
    private final String workflowRunId;
    private final String sessionId;
    private final String task;
    private final List<ToolSpec> toolSpecs;
    private final String clientToken;

    private CreateActRequest(BuilderImpl builder) {
        super(builder);
        this.workflowDefinitionName = builder.workflowDefinitionName;
        this.workflowRunId = builder.workflowRunId;
        this.sessionId = builder.sessionId;
        this.task = builder.task;
        this.toolSpecs = builder.toolSpecs;
        this.clientToken = builder.clientToken;
    }

    public final String workflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public final String workflowRunId() {
        return this.workflowRunId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String task() {
        return this.task;
    }

    public final boolean hasToolSpecs() {
        return this.toolSpecs != null && !(this.toolSpecs instanceof SdkAutoConstructList);
    }

    public final List<ToolSpec> toolSpecs() {
        return this.toolSpecs;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToolSpecs() ? this.toolSpecs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActRequest)) {
            return false;
        }
        CreateActRequest other = (CreateActRequest)((Object)obj);
        return Objects.equals(this.workflowDefinitionName(), other.workflowDefinitionName()) && Objects.equals(this.workflowRunId(), other.workflowRunId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.task(), other.task()) && this.hasToolSpecs() == other.hasToolSpecs() && Objects.equals(this.toolSpecs(), other.toolSpecs()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateActRequest").add("WorkflowDefinitionName", (Object)this.workflowDefinitionName()).add("WorkflowRunId", (Object)this.workflowRunId()).add("SessionId", (Object)this.sessionId()).add("Task", (Object)(this.task() == null ? null : "*** Sensitive Data Redacted ***")).add("ToolSpecs", this.hasToolSpecs() ? this.toolSpecs() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.workflowDefinitionName()));
            }
            case "workflowRunId": {
                return Optional.ofNullable(clazz.cast(this.workflowRunId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "toolSpecs": {
                return Optional.ofNullable(clazz.cast(this.toolSpecs()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowDefinitionName", WORKFLOW_DEFINITION_NAME_FIELD);
        map.put("workflowRunId", WORKFLOW_RUN_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("task", TASK_FIELD);
        map.put("toolSpecs", TOOL_SPECS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateActRequest, T> g) {
        return obj -> g.apply((CreateActRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActRequest.BuilderImpl
    implements Builder {
        private String workflowDefinitionName;
        private String workflowRunId;
        private String sessionId;
        private String task;
        private List<ToolSpec> toolSpecs = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActRequest model) {
            super(model);
            this.workflowDefinitionName(model.workflowDefinitionName);
            this.workflowRunId(model.workflowRunId);
            this.sessionId(model.sessionId);
            this.task(model.task);
            this.toolSpecs(model.toolSpecs);
            this.clientToken(model.clientToken);
        }

        public final String getWorkflowDefinitionName() {
            return this.workflowDefinitionName;
        }

        public final void setWorkflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
        }

        @Override
        public final Builder workflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
            return this;
        }

        public final String getWorkflowRunId() {
            return this.workflowRunId;
        }

        public final void setWorkflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
        }

        @Override
        public final Builder workflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTask() {
            return this.task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final List<ToolSpec.Builder> getToolSpecs() {
            List<ToolSpec.Builder> result = ToolSpecsCopier.copyToBuilder(this.toolSpecs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToolSpecs(Collection<ToolSpec.BuilderImpl> toolSpecs) {
            this.toolSpecs = ToolSpecsCopier.copyFromBuilder(toolSpecs);
        }

        @Override
        public final Builder toolSpecs(Collection<ToolSpec> toolSpecs) {
            this.toolSpecs = ToolSpecsCopier.copy(toolSpecs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolSpecs(ToolSpec ... toolSpecs) {
            this.toolSpecs(Arrays.asList(toolSpecs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolSpecs(Consumer<ToolSpec.Builder> ... toolSpecs) {
            this.toolSpecs(Stream.of(toolSpecs).map(c -> (ToolSpec)((ToolSpec.Builder)ToolSpec.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateActRequest build() {
            return new CreateActRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateActRequest> {
        public Builder workflowDefinitionName(String var1);

        public Builder workflowRunId(String var1);

        public Builder sessionId(String var1);

        public Builder task(String var1);

        public Builder toolSpecs(Collection<ToolSpec> var1);

        public Builder toolSpecs(ToolSpec ... var1);

        public Builder toolSpecs(Consumer<ToolSpec.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

