/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.SampleAggregationDimensionValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SummarizationDimensionOverview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SummarizationDimensionOverview> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SummarizationDimensionOverview.getter(SummarizationDimensionOverview::name)).setter(SummarizationDimensionOverview.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(SummarizationDimensionOverview.getter(SummarizationDimensionOverview::count)).setter(SummarizationDimensionOverview.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<List<String>> SAMPLE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sampleValues").getter(SummarizationDimensionOverview.getter(SummarizationDimensionOverview::sampleValues)).setter(SummarizationDimensionOverview.setter(Builder::sampleValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COUNT_FIELD, SAMPLE_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SummarizationDimensionOverview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer count;
    private final List<String> sampleValues;

    private SummarizationDimensionOverview(BuilderImpl builder) {
        this.name = builder.name;
        this.count = builder.count;
        this.sampleValues = builder.sampleValues;
    }

    public final String name() {
        return this.name;
    }

    public final Integer count() {
        return this.count;
    }

    public final boolean hasSampleValues() {
        return this.sampleValues != null && !(this.sampleValues instanceof SdkAutoConstructList);
    }

    public final List<String> sampleValues() {
        return this.sampleValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleValues() ? this.sampleValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizationDimensionOverview)) {
            return false;
        }
        SummarizationDimensionOverview other = (SummarizationDimensionOverview)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.count(), other.count()) && this.hasSampleValues() == other.hasSampleValues() && Objects.equals(this.sampleValues(), other.sampleValues());
    }

    public final String toString() {
        return ToString.builder((String)"SummarizationDimensionOverview").add("Name", (Object)this.name()).add("Count", (Object)this.count()).add("SampleValues", this.hasSampleValues() ? this.sampleValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "sampleValues": {
                return Optional.ofNullable(clazz.cast(this.sampleValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("sampleValues", SAMPLE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SummarizationDimensionOverview, T> g) {
        return obj -> g.apply((SummarizationDimensionOverview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer count;
        private List<String> sampleValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SummarizationDimensionOverview model) {
            this.name(model.name);
            this.count(model.count);
            this.sampleValues(model.sampleValues);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getSampleValues() {
            if (this.sampleValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sampleValues;
        }

        public final void setSampleValues(Collection<String> sampleValues) {
            this.sampleValues = SampleAggregationDimensionValuesCopier.copy(sampleValues);
        }

        @Override
        public final Builder sampleValues(Collection<String> sampleValues) {
            this.sampleValues = SampleAggregationDimensionValuesCopier.copy(sampleValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleValues(String ... sampleValues) {
            this.sampleValues(Arrays.asList(sampleValues));
            return this;
        }

        public SummarizationDimensionOverview build() {
            return new SummarizationDimensionOverview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SummarizationDimensionOverview> {
        public Builder name(String var1);

        public Builder count(Integer var1);

        public Builder sampleValues(Collection<String> var1);

        public Builder sampleValues(String ... var1);
    }
}

