/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.LocaleCode;
import software.amazon.awssdk.services.notifications.model.NotificationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedNotificationEventsRequest
extends NotificationsRequest
implements ToCopyableBuilder<Builder, ListManagedNotificationEventsRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListManagedNotificationEventsRequest.getter(ListManagedNotificationEventsRequest::startTime)).setter(ListManagedNotificationEventsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListManagedNotificationEventsRequest.getter(ListManagedNotificationEventsRequest::endTime)).setter(ListManagedNotificationEventsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(ListManagedNotificationEventsRequest.getter(ListManagedNotificationEventsRequest::localeAsString)).setter(ListManagedNotificationEventsRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locale").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ListManagedNotificationEventsRequest.getter(ListManagedNotificationEventsRequest::source)).setter(ListManagedNotificationEventsRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("source").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListManagedNotificationEventsRequest.getter(ListManagedNotificationEventsRequest::maxResults)).setter(ListManagedNotificationEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListManagedNotificationEventsRequest.getter(ListManagedNotificationEventsRequest::nextToken)).setter(ListManagedNotificationEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationalUnitId").getter(ListManagedNotificationEventsRequest.getter(ListManagedNotificationEventsRequest::organizationalUnitId)).setter(ListManagedNotificationEventsRequest.setter(Builder::organizationalUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("organizationalUnitId").build()}).build();
    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedAccount").getter(ListManagedNotificationEventsRequest.getter(ListManagedNotificationEventsRequest::relatedAccount)).setter(ListManagedNotificationEventsRequest.setter(Builder::relatedAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("relatedAccount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, LOCALE_FIELD, SOURCE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD, RELATED_ACCOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedNotificationEventsRequest.memberNameToFieldInitializer();
    private final Instant startTime;
    private final Instant endTime;
    private final String locale;
    private final String source;
    private final Integer maxResults;
    private final String nextToken;
    private final String organizationalUnitId;
    private final String relatedAccount;

    private ListManagedNotificationEventsRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.locale = builder.locale;
        this.source = builder.source;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.relatedAccount = builder.relatedAccount;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final LocaleCode locale() {
        return LocaleCode.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    public final String source() {
        return this.source;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String organizationalUnitId() {
        return this.organizationalUnitId;
    }

    public final String relatedAccount() {
        return this.relatedAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedAccount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedNotificationEventsRequest)) {
            return false;
        }
        ListManagedNotificationEventsRequest other = (ListManagedNotificationEventsRequest)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.organizationalUnitId(), other.organizationalUnitId()) && Objects.equals(this.relatedAccount(), other.relatedAccount());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedNotificationEventsRequest").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Locale", (Object)this.localeAsString()).add("Source", (Object)this.source()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OrganizationalUnitId", (Object)this.organizationalUnitId()).add("RelatedAccount", (Object)this.relatedAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "organizationalUnitId": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitId()));
            }
            case "relatedAccount": {
                return Optional.ofNullable(clazz.cast(this.relatedAccount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedNotificationEventsRequest, T> g) {
        return obj -> g.apply((ListManagedNotificationEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsRequest.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private String locale;
        private String source;
        private Integer maxResults;
        private String nextToken;
        private String organizationalUnitId;
        private String relatedAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedNotificationEventsRequest model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.locale(model.locale);
            this.source(model.source);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.organizationalUnitId(model.organizationalUnitId);
            this.relatedAccount(model.relatedAccount);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleCode locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final String getRelatedAccount() {
            return this.relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListManagedNotificationEventsRequest build() {
            return new ListManagedNotificationEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedNotificationEventsRequest> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder locale(String var1);

        public Builder locale(LocaleCode var1);

        public Builder source(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder organizationalUnitId(String var1);

        public Builder relatedAccount(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

