/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsAsyncClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChannelAssociationSummary;

public class ListManagedNotificationChannelAssociationsPublisher
implements SdkPublisher<ListManagedNotificationChannelAssociationsResponse> {
    private final NotificationsAsyncClient client;
    private final ListManagedNotificationChannelAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedNotificationChannelAssociationsPublisher(NotificationsAsyncClient client, ListManagedNotificationChannelAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedNotificationChannelAssociationsPublisher(NotificationsAsyncClient client, ListManagedNotificationChannelAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedNotificationChannelAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedNotificationChannelAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedNotificationChannelAssociationSummary> channelAssociations() {
        Function<ListManagedNotificationChannelAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channelAssociations() != null) {
                return response.channelAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedNotificationChannelAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedNotificationChannelAssociationsResponseFetcher
    implements AsyncPageFetcher<ListManagedNotificationChannelAssociationsResponse> {
        private ListManagedNotificationChannelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedNotificationChannelAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedNotificationChannelAssociationsResponse> nextPage(ListManagedNotificationChannelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedNotificationChannelAssociationsPublisher.this.client.listManagedNotificationChannelAssociations(ListManagedNotificationChannelAssociationsPublisher.this.firstRequest);
            }
            return ListManagedNotificationChannelAssociationsPublisher.this.client.listManagedNotificationChannelAssociations((ListManagedNotificationChannelAssociationsRequest)((Object)ListManagedNotificationChannelAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

