/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEvent;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetManagedNotificationChildEventResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, GetManagedNotificationChildEventResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetManagedNotificationChildEventResponse.getter(GetManagedNotificationChildEventResponse::arn)).setter(GetManagedNotificationChildEventResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedNotificationConfigurationArn").getter(GetManagedNotificationChildEventResponse.getter(GetManagedNotificationChildEventResponse::managedNotificationConfigurationArn)).setter(GetManagedNotificationChildEventResponse.setter(Builder::managedNotificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedNotificationConfigurationArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetManagedNotificationChildEventResponse.getter(GetManagedNotificationChildEventResponse::creationTime)).setter(GetManagedNotificationChildEventResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ManagedNotificationChildEvent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(GetManagedNotificationChildEventResponse.getter(GetManagedNotificationChildEventResponse::content)).setter(GetManagedNotificationChildEventResponse.setter(Builder::content)).constructor(ManagedNotificationChildEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD, CREATION_TIME_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetManagedNotificationChildEventResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String managedNotificationConfigurationArn;
    private final Instant creationTime;
    private final ManagedNotificationChildEvent content;

    private GetManagedNotificationChildEventResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.managedNotificationConfigurationArn = builder.managedNotificationConfigurationArn;
        this.creationTime = builder.creationTime;
        this.content = builder.content;
    }

    public final String arn() {
        return this.arn;
    }

    public final String managedNotificationConfigurationArn() {
        return this.managedNotificationConfigurationArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ManagedNotificationChildEvent content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedNotificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedNotificationChildEventResponse)) {
            return false;
        }
        GetManagedNotificationChildEventResponse other = (GetManagedNotificationChildEventResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.managedNotificationConfigurationArn(), other.managedNotificationConfigurationArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"GetManagedNotificationChildEventResponse").add("Arn", (Object)this.arn()).add("ManagedNotificationConfigurationArn", (Object)this.managedNotificationConfigurationArn()).add("CreationTime", (Object)this.creationTime()).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "managedNotificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.managedNotificationConfigurationArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("managedNotificationConfigurationArn", MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedNotificationChildEventResponse, T> g) {
        return obj -> g.apply((GetManagedNotificationChildEventResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String managedNotificationConfigurationArn;
        private Instant creationTime;
        private ManagedNotificationChildEvent content;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedNotificationChildEventResponse model) {
            super(model);
            this.arn(model.arn);
            this.managedNotificationConfigurationArn(model.managedNotificationConfigurationArn);
            this.creationTime(model.creationTime);
            this.content(model.content);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getManagedNotificationConfigurationArn() {
            return this.managedNotificationConfigurationArn;
        }

        public final void setManagedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
        }

        @Override
        public final Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ManagedNotificationChildEvent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(ManagedNotificationChildEvent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ManagedNotificationChildEvent content) {
            this.content = content;
            return this;
        }

        @Override
        public GetManagedNotificationChildEventResponse build() {
            return new GetManagedNotificationChildEventResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetManagedNotificationChildEventResponse> {
        public Builder arn(String var1);

        public Builder managedNotificationConfigurationArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder content(ManagedNotificationChildEvent var1);

        default public Builder content(Consumer<ManagedNotificationChildEvent.Builder> content) {
            return this.content((ManagedNotificationChildEvent)((ManagedNotificationChildEvent.Builder)ManagedNotificationChildEvent.builder().applyMutation(content)).build());
        }
    }
}

