/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.internal.UserAgentUtils;
import software.amazon.awssdk.services.nimble.model.EulaAcceptance;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse;

public class ListEulaAcceptancesIterable
implements SdkIterable<ListEulaAcceptancesResponse> {
    private final NimbleClient client;
    private final ListEulaAcceptancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEulaAcceptancesIterable(NimbleClient client, ListEulaAcceptancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEulaAcceptancesResponseFetcher();
    }

    public Iterator<ListEulaAcceptancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EulaAcceptance> eulaAcceptances() {
        Function<ListEulaAcceptancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eulaAcceptances() != null) {
                return response.eulaAcceptances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEulaAcceptancesResponseFetcher
    implements SyncPageFetcher<ListEulaAcceptancesResponse> {
        private ListEulaAcceptancesResponseFetcher() {
        }

        public boolean hasNextPage(ListEulaAcceptancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEulaAcceptancesResponse nextPage(ListEulaAcceptancesResponse previousPage) {
            if (previousPage == null) {
                return ListEulaAcceptancesIterable.this.client.listEulaAcceptances(ListEulaAcceptancesIterable.this.firstRequest);
            }
            return ListEulaAcceptancesIterable.this.client.listEulaAcceptances((ListEulaAcceptancesRequest)((Object)ListEulaAcceptancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

