/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmonitor.model.MonitorState;
import software.amazon.awssdk.services.networkmonitor.model.NetworkMonitorResponse;
import software.amazon.awssdk.services.networkmonitor.model.Probe;
import software.amazon.awssdk.services.networkmonitor.model.ProbeListCopier;
import software.amazon.awssdk.services.networkmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMonitorResponse
extends NetworkMonitorResponse
implements ToCopyableBuilder<Builder, GetMonitorResponse> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorArn").getter(GetMonitorResponse.getter(GetMonitorResponse::monitorArn)).setter(GetMonitorResponse.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorArn").build()}).build();
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(GetMonitorResponse.getter(GetMonitorResponse::monitorName)).setter(GetMonitorResponse.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(GetMonitorResponse.getter(GetMonitorResponse::stateAsString)).setter(GetMonitorResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Long> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("aggregationPeriod").getter(GetMonitorResponse.getter(GetMonitorResponse::aggregationPeriod)).setter(GetMonitorResponse.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationPeriod").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetMonitorResponse.getter(GetMonitorResponse::tags)).setter(GetMonitorResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Probe>> PROBES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("probes").getter(GetMonitorResponse.getter(GetMonitorResponse::probes)).setter(GetMonitorResponse.setter(Builder::probes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("probes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Probe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetMonitorResponse.getter(GetMonitorResponse::createdAt)).setter(GetMonitorResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(GetMonitorResponse.getter(GetMonitorResponse::modifiedAt)).setter(GetMonitorResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD, MONITOR_NAME_FIELD, STATE_FIELD, AGGREGATION_PERIOD_FIELD, TAGS_FIELD, PROBES_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMonitorResponse.memberNameToFieldInitializer();
    private final String monitorArn;
    private final String monitorName;
    private final String state;
    private final Long aggregationPeriod;
    private final Map<String, String> tags;
    private final List<Probe> probes;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private GetMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.state = builder.state;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.tags = builder.tags;
        this.probes = builder.probes;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final MonitorState state() {
        return MonitorState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Long aggregationPeriod() {
        return this.aggregationPeriod;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasProbes() {
        return this.probes != null && !(this.probes instanceof SdkAutoConstructList);
    }

    public final List<Probe> probes() {
        return this.probes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProbes() ? this.probes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMonitorResponse)) {
            return false;
        }
        GetMonitorResponse other = (GetMonitorResponse)((Object)obj);
        return Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.aggregationPeriod(), other.aggregationPeriod()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasProbes() == other.hasProbes() && Objects.equals(this.probes(), other.probes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetMonitorResponse").add("MonitorArn", (Object)this.monitorArn()).add("MonitorName", (Object)this.monitorName()).add("State", (Object)this.stateAsString()).add("AggregationPeriod", (Object)this.aggregationPeriod()).add("Tags", this.hasTags() ? this.tags() : null).add("Probes", this.hasProbes() ? this.probes() : null).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "aggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriod()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "probes": {
                return Optional.ofNullable(clazz.cast(this.probes()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("monitorArn", MONITOR_ARN_FIELD);
        map.put("monitorName", MONITOR_NAME_FIELD);
        map.put("state", STATE_FIELD);
        map.put("aggregationPeriod", AGGREGATION_PERIOD_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("probes", PROBES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMonitorResponse, T> g) {
        return obj -> g.apply((GetMonitorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkMonitorResponse.BuilderImpl
    implements Builder {
        private String monitorArn;
        private String monitorName;
        private String state;
        private Long aggregationPeriod;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<Probe> probes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMonitorResponse model) {
            super(model);
            this.monitorArn(model.monitorArn);
            this.monitorName(model.monitorName);
            this.state(model.state);
            this.aggregationPeriod(model.aggregationPeriod);
            this.tags(model.tags);
            this.probes(model.probes);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MonitorState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Long getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(Long aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(Long aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<Probe.Builder> getProbes() {
            List<Probe.Builder> result = ProbeListCopier.copyToBuilder(this.probes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProbes(Collection<Probe.BuilderImpl> probes) {
            this.probes = ProbeListCopier.copyFromBuilder(probes);
        }

        @Override
        public final Builder probes(Collection<Probe> probes) {
            this.probes = ProbeListCopier.copy(probes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder probes(Probe ... probes) {
            this.probes(Arrays.asList(probes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder probes(Consumer<Probe.Builder> ... probes) {
            this.probes(Stream.of(probes).map(c -> (Probe)((Probe.Builder)Probe.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public GetMonitorResponse build() {
            return new GetMonitorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMonitorResponse> {
        public Builder monitorArn(String var1);

        public Builder monitorName(String var1);

        public Builder state(String var1);

        public Builder state(MonitorState var1);

        public Builder aggregationPeriod(Long var1);

        public Builder tags(Map<String, String> var1);

        public Builder probes(Collection<Probe> var1);

        public Builder probes(Probe ... var1);

        public Builder probes(Consumer<Probe.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

