/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitorState {
    PENDING("PENDING"),
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    ERROR("ERROR"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitorState> VALUE_MAP;
    private final String value;

    private MonitorState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorState> knownValues() {
        EnumSet<MonitorState> knownValues = EnumSet.allOf(MonitorState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitorState.class, MonitorState::toString);
    }
}

