/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkRoutingInformation;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkRoutingInformationRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkRoutingInformationResponse;

public class ListCoreNetworkRoutingInformationPublisher
implements SdkPublisher<ListCoreNetworkRoutingInformationResponse> {
    private final NetworkManagerAsyncClient client;
    private final ListCoreNetworkRoutingInformationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCoreNetworkRoutingInformationPublisher(NetworkManagerAsyncClient client, ListCoreNetworkRoutingInformationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCoreNetworkRoutingInformationPublisher(NetworkManagerAsyncClient client, ListCoreNetworkRoutingInformationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCoreNetworkRoutingInformationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCoreNetworkRoutingInformationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CoreNetworkRoutingInformation> coreNetworkRoutingInformation() {
        Function<ListCoreNetworkRoutingInformationResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworkRoutingInformation() != null) {
                return response.coreNetworkRoutingInformation().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCoreNetworkRoutingInformationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCoreNetworkRoutingInformationResponseFetcher
    implements AsyncPageFetcher<ListCoreNetworkRoutingInformationResponse> {
        private ListCoreNetworkRoutingInformationResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreNetworkRoutingInformationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCoreNetworkRoutingInformationResponse> nextPage(ListCoreNetworkRoutingInformationResponse previousPage) {
            if (previousPage == null) {
                return ListCoreNetworkRoutingInformationPublisher.this.client.listCoreNetworkRoutingInformation(ListCoreNetworkRoutingInformationPublisher.this.firstRequest);
            }
            return ListCoreNetworkRoutingInformationPublisher.this.client.listCoreNetworkRoutingInformation((ListCoreNetworkRoutingInformationRequest)((Object)ListCoreNetworkRoutingInformationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

