/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkRouteDestination;
import software.amazon.awssdk.services.networkmanager.model.NetworkRouteDestinationListCopier;
import software.amazon.awssdk.services.networkmanager.model.RouteState;
import software.amazon.awssdk.services.networkmanager.model.RouteType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkRoute> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(NetworkRoute.getter(NetworkRoute::destinationCidrBlock)).setter(NetworkRoute.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<List<NetworkRouteDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(NetworkRoute.getter(NetworkRoute::destinations)).setter(NetworkRoute.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkRouteDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(NetworkRoute.getter(NetworkRoute::prefixListId)).setter(NetworkRoute.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(NetworkRoute.getter(NetworkRoute::stateAsString)).setter(NetworkRoute.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(NetworkRoute.getter(NetworkRoute::typeAsString)).setter(NetworkRoute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, DESTINATIONS_FIELD, PREFIX_LIST_ID_FIELD, STATE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkRoute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationCidrBlock;
    private final List<NetworkRouteDestination> destinations;
    private final String prefixListId;
    private final String state;
    private final String type;

    private NetworkRoute(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinations = builder.destinations;
        this.prefixListId = builder.prefixListId;
        this.state = builder.state;
        this.type = builder.type;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<NetworkRouteDestination> destinations() {
        return this.destinations;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final RouteState state() {
        return RouteState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final RouteType type() {
        return RouteType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkRoute)) {
            return false;
        }
        NetworkRoute other = (NetworkRoute)obj;
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkRoute").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("PrefixListId", (Object)this.prefixListId()).add("State", (Object)this.stateAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("Destinations", DESTINATIONS_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkRoute, T> g) {
        return obj -> g.apply((NetworkRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private List<NetworkRouteDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private String prefixListId;
        private String state;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkRoute model) {
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinations(model.destinations);
            this.prefixListId(model.prefixListId);
            this.state(model.state);
            this.type(model.type);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final List<NetworkRouteDestination.Builder> getDestinations() {
            List<NetworkRouteDestination.Builder> result = NetworkRouteDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<NetworkRouteDestination.BuilderImpl> destinations) {
            this.destinations = NetworkRouteDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<NetworkRouteDestination> destinations) {
            this.destinations = NetworkRouteDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(NetworkRouteDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<NetworkRouteDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (NetworkRouteDestination)((NetworkRouteDestination.Builder)NetworkRouteDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public NetworkRoute build() {
            return new NetworkRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkRoute> {
        public Builder destinationCidrBlock(String var1);

        public Builder destinations(Collection<NetworkRouteDestination> var1);

        public Builder destinations(NetworkRouteDestination ... var1);

        public Builder destinations(Consumer<NetworkRouteDestination.Builder> ... var1);

        public Builder prefixListId(String var1);

        public Builder state(String var1);

        public Builder state(RouteState var1);

        public Builder type(String var1);

        public Builder type(RouteType var1);
    }
}

