/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteState {
    ACTIVE("ACTIVE"),
    BLACKHOLE("BLACKHOLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteState> VALUE_MAP;
    private final String value;

    private RouteState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteState> knownValues() {
        EnumSet<RouteState> knownValues = EnumSet.allOf(RouteState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteState.class, RouteState::toString);
    }
}

