/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.AWSLocation;
import software.amazon.awssdk.services.networkmanager.model.DeviceState;
import software.amazon.awssdk.services.networkmanager.model.Location;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Device
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Device> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(Device.getter(Device::deviceId)).setter(Device.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceArn").getter(Device.getter(Device::deviceArn)).setter(Device.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()}).build();
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(Device.getter(Device::globalNetworkId)).setter(Device.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()}).build();
    private static final SdkField<AWSLocation> AWS_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AWSLocation").getter(Device.getter(Device::awsLocation)).setter(Device.setter(Builder::awsLocation)).constructor(AWSLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSLocation").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Device.getter(Device::description)).setter(Device.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Device.getter(Device::type)).setter(Device.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Vendor").getter(Device.getter(Device::vendor)).setter(Device.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(Device.getter(Device::model)).setter(Device.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(Device.getter(Device::serialNumber)).setter(Device.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(Device.getter(Device::location)).setter(Device.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteId").getter(Device.getter(Device::siteId)).setter(Device.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Device.getter(Device::createdAt)).setter(Device.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Device.getter(Device::stateAsString)).setter(Device.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Device.getter(Device::tags)).setter(Device.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, DEVICE_ARN_FIELD, GLOBAL_NETWORK_ID_FIELD, AWS_LOCATION_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, VENDOR_FIELD, MODEL_FIELD, SERIAL_NUMBER_FIELD, LOCATION_FIELD, SITE_ID_FIELD, CREATED_AT_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final String deviceArn;
    private final String globalNetworkId;
    private final AWSLocation awsLocation;
    private final String description;
    private final String type;
    private final String vendor;
    private final String model;
    private final String serialNumber;
    private final Location location;
    private final String siteId;
    private final Instant createdAt;
    private final String state;
    private final List<Tag> tags;

    private Device(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.deviceArn = builder.deviceArn;
        this.globalNetworkId = builder.globalNetworkId;
        this.awsLocation = builder.awsLocation;
        this.description = builder.description;
        this.type = builder.type;
        this.vendor = builder.vendor;
        this.model = builder.model;
        this.serialNumber = builder.serialNumber;
        this.location = builder.location;
        this.siteId = builder.siteId;
        this.createdAt = builder.createdAt;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final AWSLocation awsLocation() {
        return this.awsLocation;
    }

    public final String description() {
        return this.description;
    }

    public final String type() {
        return this.type;
    }

    public final String vendor() {
        return this.vendor;
    }

    public final String model() {
        return this.model;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final Location location() {
        return this.location;
    }

    public final String siteId() {
        return this.siteId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeviceState state() {
        return DeviceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.awsLocation(), other.awsLocation()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.vendor(), other.vendor()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.siteId(), other.siteId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Device").add("DeviceId", (Object)this.deviceId()).add("DeviceArn", (Object)this.deviceArn()).add("GlobalNetworkId", (Object)this.globalNetworkId()).add("AWSLocation", (Object)this.awsLocation()).add("Description", (Object)this.description()).add("Type", (Object)this.type()).add("Vendor", (Object)this.vendor()).add("Model", (Object)this.model()).add("SerialNumber", (Object)this.serialNumber()).add("Location", (Object)(this.location() == null ? null : "*** Sensitive Data Redacted ***")).add("SiteId", (Object)this.siteId()).add("CreatedAt", (Object)this.createdAt()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "AWSLocation": {
                return Optional.ofNullable(clazz.cast(this.awsLocation()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "SiteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private String deviceArn;
        private String globalNetworkId;
        private AWSLocation awsLocation;
        private String description;
        private String type;
        private String vendor;
        private String model;
        private String serialNumber;
        private Location location;
        private String siteId;
        private Instant createdAt;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.deviceId(model.deviceId);
            this.deviceArn(model.deviceArn);
            this.globalNetworkId(model.globalNetworkId);
            this.awsLocation(model.awsLocation);
            this.description(model.description);
            this.type(model.type);
            this.vendor(model.vendor);
            this.model(model.model);
            this.serialNumber(model.serialNumber);
            this.location(model.location);
            this.siteId(model.siteId);
            this.createdAt(model.createdAt);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final AWSLocation.Builder getAwsLocation() {
            return this.awsLocation != null ? this.awsLocation.toBuilder() : null;
        }

        public final void setAwsLocation(AWSLocation.BuilderImpl awsLocation) {
            this.awsLocation = awsLocation != null ? awsLocation.build() : null;
        }

        @Override
        public final Builder awsLocation(AWSLocation awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVendor() {
            return this.vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DeviceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Device build() {
            return new Device(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Device> {
        public Builder deviceId(String var1);

        public Builder deviceArn(String var1);

        public Builder globalNetworkId(String var1);

        public Builder awsLocation(AWSLocation var1);

        default public Builder awsLocation(Consumer<AWSLocation.Builder> awsLocation) {
            return this.awsLocation((AWSLocation)((AWSLocation.Builder)AWSLocation.builder().applyMutation(awsLocation)).build());
        }

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder vendor(String var1);

        public Builder model(String var1);

        public Builder serialNumber(String var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder siteId(String var1);

        public Builder createdAt(Instant var1);

        public Builder state(String var1);

        public Builder state(DeviceState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

