/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry;

public class GetNetworkTelemetryPublisher
implements SdkPublisher<GetNetworkTelemetryResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetNetworkTelemetryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetNetworkTelemetryPublisher(NetworkManagerAsyncClient client, GetNetworkTelemetryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetNetworkTelemetryPublisher(NetworkManagerAsyncClient client, GetNetworkTelemetryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetNetworkTelemetryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetNetworkTelemetryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkTelemetry> networkTelemetry() {
        Function<GetNetworkTelemetryResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkTelemetry() != null) {
                return response.networkTelemetry().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetNetworkTelemetryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetNetworkTelemetryResponseFetcher
    implements AsyncPageFetcher<GetNetworkTelemetryResponse> {
        private GetNetworkTelemetryResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkTelemetryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetNetworkTelemetryResponse> nextPage(GetNetworkTelemetryResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkTelemetryPublisher.this.client.getNetworkTelemetry(GetNetworkTelemetryPublisher.this.firstRequest);
            }
            return GetNetworkTelemetryPublisher.this.client.getNetworkTelemetry((GetNetworkTelemetryRequest)((Object)GetNetworkTelemetryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

