/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.networkmanager.DefaultNetworkManagerBaseClientBuilder;
import software.amazon.awssdk.services.networkmanager.DefaultNetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClientBuilder;
import software.amazon.awssdk.services.networkmanager.NetworkManagerServiceClientConfiguration;
import software.amazon.awssdk.services.networkmanager.endpoints.NetworkManagerEndpointProvider;

@SdkInternalApi
final class DefaultNetworkManagerClientBuilder
extends DefaultNetworkManagerBaseClientBuilder<NetworkManagerClientBuilder, NetworkManagerClient>
implements NetworkManagerClientBuilder {
    DefaultNetworkManagerClientBuilder() {
    }

    @Override
    public DefaultNetworkManagerClientBuilder endpointProvider(NetworkManagerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final NetworkManagerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultNetworkManagerClientBuilder.validateClientOptions(clientConfiguration);
        NetworkManagerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultNetworkManagerClient client = new DefaultNetworkManagerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private NetworkManagerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return NetworkManagerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

