/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AWSLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AWSLocation> {
    private static final SdkField<String> ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Zone").getter(AWSLocation.getter(AWSLocation::zone)).setter(AWSLocation.setter(Builder::zone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zone").build()}).build();
    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetArn").getter(AWSLocation.getter(AWSLocation::subnetArn)).setter(AWSLocation.setter(Builder::subnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONE_FIELD, SUBNET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String zone;
    private final String subnetArn;

    private AWSLocation(BuilderImpl builder) {
        this.zone = builder.zone;
        this.subnetArn = builder.subnetArn;
    }

    public final String zone() {
        return this.zone;
    }

    public final String subnetArn() {
        return this.subnetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.zone());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSLocation)) {
            return false;
        }
        AWSLocation other = (AWSLocation)obj;
        return Objects.equals(this.zone(), other.zone()) && Objects.equals(this.subnetArn(), other.subnetArn());
    }

    public final String toString() {
        return ToString.builder((String)"AWSLocation").add("Zone", (Object)this.zone()).add("SubnetArn", (Object)this.subnetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Zone": {
                return Optional.ofNullable(clazz.cast(this.zone()));
            }
            case "SubnetArn": {
                return Optional.ofNullable(clazz.cast(this.subnetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AWSLocation, T> g) {
        return obj -> g.apply((AWSLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String zone;
        private String subnetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSLocation model) {
            this.zone(model.zone);
            this.subnetArn(model.subnetArn);
        }

        public final String getZone() {
            return this.zone;
        }

        public final void setZone(String zone) {
            this.zone = zone;
        }

        @Override
        @Transient
        public final Builder zone(String zone) {
            this.zone = zone;
            return this;
        }

        public final String getSubnetArn() {
            return this.subnetArn;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        @Override
        @Transient
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        public AWSLocation build() {
            return new AWSLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AWSLocation> {
        public Builder zone(String var1);

        public Builder subnetArn(String var1);
    }
}

