/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGlobalNetworksRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, DescribeGlobalNetworksRequest> {
    private static final SdkField<List<String>> GLOBAL_NETWORK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalNetworkIds").getter(DescribeGlobalNetworksRequest.getter(DescribeGlobalNetworksRequest::globalNetworkIds)).setter(DescribeGlobalNetworksRequest.setter(Builder::globalNetworkIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("globalNetworkIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeGlobalNetworksRequest.getter(DescribeGlobalNetworksRequest::maxResults)).setter(DescribeGlobalNetworksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeGlobalNetworksRequest.getter(DescribeGlobalNetworksRequest::nextToken)).setter(DescribeGlobalNetworksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> globalNetworkIds;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeGlobalNetworksRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkIds = builder.globalNetworkIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public boolean hasGlobalNetworkIds() {
        return this.globalNetworkIds != null && !(this.globalNetworkIds instanceof SdkAutoConstructList);
    }

    public List<String> globalNetworkIds() {
        return this.globalNetworkIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalNetworksRequest)) {
            return false;
        }
        DescribeGlobalNetworksRequest other = (DescribeGlobalNetworksRequest)((Object)obj);
        return Objects.equals(this.globalNetworkIds(), other.globalNetworkIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGlobalNetworksRequest").add("GlobalNetworkIds", this.globalNetworkIds()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkIds": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkIds()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalNetworksRequest, T> g) {
        return obj -> g.apply((DescribeGlobalNetworksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private List<String> globalNetworkIds = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalNetworksRequest model) {
            super(model);
            this.globalNetworkIds(model.globalNetworkIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getGlobalNetworkIds() {
            return this.globalNetworkIds;
        }

        @Override
        public final Builder globalNetworkIds(Collection<String> globalNetworkIds) {
            this.globalNetworkIds = StringListCopier.copy(globalNetworkIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNetworkIds(String ... globalNetworkIds) {
            this.globalNetworkIds(Arrays.asList(globalNetworkIds));
            return this;
        }

        public final void setGlobalNetworkIds(Collection<String> globalNetworkIds) {
            this.globalNetworkIds = StringListCopier.copy(globalNetworkIds);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGlobalNetworksRequest build() {
            return new DescribeGlobalNetworksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGlobalNetworksRequest> {
        public Builder globalNetworkIds(Collection<String> var1);

        public Builder globalNetworkIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

