/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.GlobalNetwork;
import software.amazon.awssdk.services.networkmanager.model.GlobalNetworkListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGlobalNetworksResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, DescribeGlobalNetworksResponse> {
    private static final SdkField<List<GlobalNetwork>> GLOBAL_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeGlobalNetworksResponse.getter(DescribeGlobalNetworksResponse::globalNetworks)).setter(DescribeGlobalNetworksResponse.setter(Builder::globalNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGlobalNetworksResponse.getter(DescribeGlobalNetworksResponse::nextToken)).setter(DescribeGlobalNetworksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GlobalNetwork> globalNetworks;
    private final String nextToken;

    private DescribeGlobalNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.globalNetworks = builder.globalNetworks;
        this.nextToken = builder.nextToken;
    }

    public List<GlobalNetwork> globalNetworks() {
        return this.globalNetworks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalNetworksResponse)) {
            return false;
        }
        DescribeGlobalNetworksResponse other = (DescribeGlobalNetworksResponse)((Object)obj);
        return Objects.equals(this.globalNetworks(), other.globalNetworks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGlobalNetworksResponse").add("GlobalNetworks", this.globalNetworks()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworks": {
                return Optional.ofNullable(clazz.cast(this.globalNetworks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalNetworksResponse, T> g) {
        return obj -> g.apply((DescribeGlobalNetworksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<GlobalNetwork> globalNetworks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalNetworksResponse model) {
            super(model);
            this.globalNetworks(model.globalNetworks);
            this.nextToken(model.nextToken);
        }

        public final Collection<GlobalNetwork.Builder> getGlobalNetworks() {
            return this.globalNetworks != null ? (Collection)this.globalNetworks.stream().map(GlobalNetwork::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalNetworks(Collection<GlobalNetwork> globalNetworks) {
            this.globalNetworks = GlobalNetworkListCopier.copy(globalNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNetworks(GlobalNetwork ... globalNetworks) {
            this.globalNetworks(Arrays.asList(globalNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNetworks(Consumer<GlobalNetwork.Builder> ... globalNetworks) {
            this.globalNetworks(Stream.of(globalNetworks).map(c -> (GlobalNetwork)((GlobalNetwork.Builder)GlobalNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalNetworks(Collection<GlobalNetwork.BuilderImpl> globalNetworks) {
            this.globalNetworks = GlobalNetworkListCopier.copyFromBuilder(globalNetworks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeGlobalNetworksResponse build() {
            return new DescribeGlobalNetworksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGlobalNetworksResponse> {
        public Builder globalNetworks(Collection<GlobalNetwork> var1);

        public Builder globalNetworks(GlobalNetwork ... var1);

        public Builder globalNetworks(Consumer<GlobalNetwork.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

