/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A row for a top contributor for a scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadInsightsTopContributorsRow implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadInsightsTopContributorsRow.Builder, WorkloadInsightsTopContributorsRow> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(WorkloadInsightsTopContributorsRow::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> LOCAL_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localSubnetId").getter(getter(WorkloadInsightsTopContributorsRow::localSubnetId))
            .setter(setter(Builder::localSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localSubnetId").build()).build();

    private static final SdkField<String> LOCAL_AZ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localAz").getter(getter(WorkloadInsightsTopContributorsRow::localAz)).setter(setter(Builder::localAz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localAz").build()).build();

    private static final SdkField<String> LOCAL_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localVpcId").getter(getter(WorkloadInsightsTopContributorsRow::localVpcId))
            .setter(setter(Builder::localVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localVpcId").build()).build();

    private static final SdkField<String> LOCAL_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localRegion").getter(getter(WorkloadInsightsTopContributorsRow::localRegion))
            .setter(setter(Builder::localRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localRegion").build()).build();

    private static final SdkField<String> REMOTE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteIdentifier").getter(getter(WorkloadInsightsTopContributorsRow::remoteIdentifier))
            .setter(setter(Builder::remoteIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIdentifier").build()).build();

    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("value")
            .getter(getter(WorkloadInsightsTopContributorsRow::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> LOCAL_SUBNET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localSubnetArn").getter(getter(WorkloadInsightsTopContributorsRow::localSubnetArn))
            .setter(setter(Builder::localSubnetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localSubnetArn").build()).build();

    private static final SdkField<String> LOCAL_VPC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localVpcArn").getter(getter(WorkloadInsightsTopContributorsRow::localVpcArn))
            .setter(setter(Builder::localVpcArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localVpcArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            LOCAL_SUBNET_ID_FIELD, LOCAL_AZ_FIELD, LOCAL_VPC_ID_FIELD, LOCAL_REGION_FIELD, REMOTE_IDENTIFIER_FIELD, VALUE_FIELD,
            LOCAL_SUBNET_ARN_FIELD, LOCAL_VPC_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String localSubnetId;

    private final String localAz;

    private final String localVpcId;

    private final String localRegion;

    private final String remoteIdentifier;

    private final Long value;

    private final String localSubnetArn;

    private final String localVpcArn;

    private WorkloadInsightsTopContributorsRow(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.localSubnetId = builder.localSubnetId;
        this.localAz = builder.localAz;
        this.localVpcId = builder.localVpcId;
        this.localRegion = builder.localRegion;
        this.remoteIdentifier = builder.remoteIdentifier;
        this.value = builder.value;
        this.localSubnetArn = builder.localSubnetArn;
        this.localVpcArn = builder.localVpcArn;
    }

    /**
     * <p>
     * The account ID for a specific row of data.
     * </p>
     * 
     * @return The account ID for a specific row of data.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The subnet identifier for the local resource.
     * </p>
     * 
     * @return The subnet identifier for the local resource.
     */
    public final String localSubnetId() {
        return localSubnetId;
    }

    /**
     * <p>
     * The identifier for the Availability Zone where the local resource is located.
     * </p>
     * 
     * @return The identifier for the Availability Zone where the local resource is located.
     */
    public final String localAz() {
        return localAz;
    }

    /**
     * <p>
     * The identifier for the VPC for the local resource.
     * </p>
     * 
     * @return The identifier for the VPC for the local resource.
     */
    public final String localVpcId() {
        return localVpcId;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the local resource is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the local resource is located.
     */
    public final String localRegion() {
        return localRegion;
    }

    /**
     * <p>
     * The identifier of a remote resource. For a VPC or subnet, this identifier is the VPC Amazon Resource Name (ARN)
     * or subnet ARN. For an Availability Zone, this identifier is the AZ name, for example, us-west-2b. For an Amazon
     * Web Services Region , this identifier is the Region name, for example, us-west-2.
     * </p>
     * 
     * @return The identifier of a remote resource. For a VPC or subnet, this identifier is the VPC Amazon Resource Name
     *         (ARN) or subnet ARN. For an Availability Zone, this identifier is the AZ name, for example, us-west-2b.
     *         For an Amazon Web Services Region , this identifier is the Region name, for example, us-west-2.
     */
    public final String remoteIdentifier() {
        return remoteIdentifier;
    }

    /**
     * <p>
     * The value for a metric.
     * </p>
     * 
     * @return The value for a metric.
     */
    public final Long value() {
        return value;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a local subnet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a local subnet.
     */
    public final String localSubnetArn() {
        return localSubnetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a local VPC.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a local VPC.
     */
    public final String localVpcArn() {
        return localVpcArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(localSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(localAz());
        hashCode = 31 * hashCode + Objects.hashCode(localVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(localRegion());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(localSubnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(localVpcArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadInsightsTopContributorsRow)) {
            return false;
        }
        WorkloadInsightsTopContributorsRow other = (WorkloadInsightsTopContributorsRow) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(localSubnetId(), other.localSubnetId())
                && Objects.equals(localAz(), other.localAz()) && Objects.equals(localVpcId(), other.localVpcId())
                && Objects.equals(localRegion(), other.localRegion())
                && Objects.equals(remoteIdentifier(), other.remoteIdentifier()) && Objects.equals(value(), other.value())
                && Objects.equals(localSubnetArn(), other.localSubnetArn()) && Objects.equals(localVpcArn(), other.localVpcArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadInsightsTopContributorsRow").add("AccountId", accountId())
                .add("LocalSubnetId", localSubnetId()).add("LocalAz", localAz()).add("LocalVpcId", localVpcId())
                .add("LocalRegion", localRegion()).add("RemoteIdentifier", remoteIdentifier()).add("Value", value())
                .add("LocalSubnetArn", localSubnetArn()).add("LocalVpcArn", localVpcArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "localSubnetId":
            return Optional.ofNullable(clazz.cast(localSubnetId()));
        case "localAz":
            return Optional.ofNullable(clazz.cast(localAz()));
        case "localVpcId":
            return Optional.ofNullable(clazz.cast(localVpcId()));
        case "localRegion":
            return Optional.ofNullable(clazz.cast(localRegion()));
        case "remoteIdentifier":
            return Optional.ofNullable(clazz.cast(remoteIdentifier()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "localSubnetArn":
            return Optional.ofNullable(clazz.cast(localSubnetArn()));
        case "localVpcArn":
            return Optional.ofNullable(clazz.cast(localVpcArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("localSubnetId", LOCAL_SUBNET_ID_FIELD);
        map.put("localAz", LOCAL_AZ_FIELD);
        map.put("localVpcId", LOCAL_VPC_ID_FIELD);
        map.put("localRegion", LOCAL_REGION_FIELD);
        map.put("remoteIdentifier", REMOTE_IDENTIFIER_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("localSubnetArn", LOCAL_SUBNET_ARN_FIELD);
        map.put("localVpcArn", LOCAL_VPC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadInsightsTopContributorsRow, T> g) {
        return obj -> g.apply((WorkloadInsightsTopContributorsRow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadInsightsTopContributorsRow> {
        /**
         * <p>
         * The account ID for a specific row of data.
         * </p>
         * 
         * @param accountId
         *        The account ID for a specific row of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The subnet identifier for the local resource.
         * </p>
         * 
         * @param localSubnetId
         *        The subnet identifier for the local resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSubnetId(String localSubnetId);

        /**
         * <p>
         * The identifier for the Availability Zone where the local resource is located.
         * </p>
         * 
         * @param localAz
         *        The identifier for the Availability Zone where the local resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localAz(String localAz);

        /**
         * <p>
         * The identifier for the VPC for the local resource.
         * </p>
         * 
         * @param localVpcId
         *        The identifier for the VPC for the local resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localVpcId(String localVpcId);

        /**
         * <p>
         * The Amazon Web Services Region where the local resource is located.
         * </p>
         * 
         * @param localRegion
         *        The Amazon Web Services Region where the local resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localRegion(String localRegion);

        /**
         * <p>
         * The identifier of a remote resource. For a VPC or subnet, this identifier is the VPC Amazon Resource Name
         * (ARN) or subnet ARN. For an Availability Zone, this identifier is the AZ name, for example, us-west-2b. For
         * an Amazon Web Services Region , this identifier is the Region name, for example, us-west-2.
         * </p>
         * 
         * @param remoteIdentifier
         *        The identifier of a remote resource. For a VPC or subnet, this identifier is the VPC Amazon Resource
         *        Name (ARN) or subnet ARN. For an Availability Zone, this identifier is the AZ name, for example,
         *        us-west-2b. For an Amazon Web Services Region , this identifier is the Region name, for example,
         *        us-west-2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIdentifier(String remoteIdentifier);

        /**
         * <p>
         * The value for a metric.
         * </p>
         * 
         * @param value
         *        The value for a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a local subnet.
         * </p>
         * 
         * @param localSubnetArn
         *        The Amazon Resource Name (ARN) of a local subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSubnetArn(String localSubnetArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a local VPC.
         * </p>
         * 
         * @param localVpcArn
         *        The Amazon Resource Name (ARN) of a local VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localVpcArn(String localVpcArn);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String localSubnetId;

        private String localAz;

        private String localVpcId;

        private String localRegion;

        private String remoteIdentifier;

        private Long value;

        private String localSubnetArn;

        private String localVpcArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadInsightsTopContributorsRow model) {
            accountId(model.accountId);
            localSubnetId(model.localSubnetId);
            localAz(model.localAz);
            localVpcId(model.localVpcId);
            localRegion(model.localRegion);
            remoteIdentifier(model.remoteIdentifier);
            value(model.value);
            localSubnetArn(model.localSubnetArn);
            localVpcArn(model.localVpcArn);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getLocalSubnetId() {
            return localSubnetId;
        }

        public final void setLocalSubnetId(String localSubnetId) {
            this.localSubnetId = localSubnetId;
        }

        @Override
        public final Builder localSubnetId(String localSubnetId) {
            this.localSubnetId = localSubnetId;
            return this;
        }

        public final String getLocalAz() {
            return localAz;
        }

        public final void setLocalAz(String localAz) {
            this.localAz = localAz;
        }

        @Override
        public final Builder localAz(String localAz) {
            this.localAz = localAz;
            return this;
        }

        public final String getLocalVpcId() {
            return localVpcId;
        }

        public final void setLocalVpcId(String localVpcId) {
            this.localVpcId = localVpcId;
        }

        @Override
        public final Builder localVpcId(String localVpcId) {
            this.localVpcId = localVpcId;
            return this;
        }

        public final String getLocalRegion() {
            return localRegion;
        }

        public final void setLocalRegion(String localRegion) {
            this.localRegion = localRegion;
        }

        @Override
        public final Builder localRegion(String localRegion) {
            this.localRegion = localRegion;
            return this;
        }

        public final String getRemoteIdentifier() {
            return remoteIdentifier;
        }

        public final void setRemoteIdentifier(String remoteIdentifier) {
            this.remoteIdentifier = remoteIdentifier;
        }

        @Override
        public final Builder remoteIdentifier(String remoteIdentifier) {
            this.remoteIdentifier = remoteIdentifier;
            return this;
        }

        public final Long getValue() {
            return value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final String getLocalSubnetArn() {
            return localSubnetArn;
        }

        public final void setLocalSubnetArn(String localSubnetArn) {
            this.localSubnetArn = localSubnetArn;
        }

        @Override
        public final Builder localSubnetArn(String localSubnetArn) {
            this.localSubnetArn = localSubnetArn;
            return this;
        }

        public final String getLocalVpcArn() {
            return localVpcArn;
        }

        public final void setLocalVpcArn(String localVpcArn) {
            this.localVpcArn = localVpcArn;
        }

        @Override
        public final Builder localVpcArn(String localVpcArn) {
            this.localVpcArn = localVpcArn;
            return this;
        }

        @Override
        public WorkloadInsightsTopContributorsRow build() {
            return new WorkloadInsightsTopContributorsRow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
