/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScopeResponse extends NetworkFlowMonitorResponse implements
        ToCopyableBuilder<UpdateScopeResponse.Builder, UpdateScopeResponse> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scopeId").getter(getter(UpdateScopeResponse::scopeId)).setter(setter(Builder::scopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateScopeResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SCOPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scopeArn").getter(getter(UpdateScopeResponse::scopeArn)).setter(setter(Builder::scopeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(UpdateScopeResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD, STATUS_FIELD,
            SCOPE_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scopeId;

    private final String status;

    private final String scopeArn;

    private final Map<String, String> tags;

    private UpdateScopeResponse(BuilderImpl builder) {
        super(builder);
        this.scopeId = builder.scopeId;
        this.status = builder.status;
        this.scopeArn = builder.scopeArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier for the scope that includes the resources you want to get data results for. A scope ID is an
     * internally-generated identifier that includes all the resources for a specific root account.
     * </p>
     * 
     * @return The identifier for the scope that includes the resources you want to get data results for. A scope ID is
     *         an internally-generated identifier that includes all the resources for a specific root account.
     */
    public final String scopeId() {
        return scopeId;
    }

    /**
     * <p>
     * The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>, <code>IN_PROGRESS</code>,
     * <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>.
     * </p>
     * <p>
     * A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network Flow
     * Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that the
     * deactivating process is complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ScopeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
     *         <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>
     *         .</p>
     *         <p>
     *         A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network
     *         Flow Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that
     *         the deactivating process is complete.
     * @see ScopeStatus
     */
    public final ScopeStatus status() {
        return ScopeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>, <code>IN_PROGRESS</code>,
     * <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>.
     * </p>
     * <p>
     * A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network Flow
     * Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that the
     * deactivating process is complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ScopeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
     *         <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>
     *         .</p>
     *         <p>
     *         A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network
     *         Flow Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that
     *         the deactivating process is complete.
     * @see ScopeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scope.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scope.
     */
    public final String scopeArn() {
        return scopeArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for a scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for a scope.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scopeArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScopeResponse)) {
            return false;
        }
        UpdateScopeResponse other = (UpdateScopeResponse) obj;
        return Objects.equals(scopeId(), other.scopeId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(scopeArn(), other.scopeArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateScopeResponse").add("ScopeId", scopeId()).add("Status", statusAsString())
                .add("ScopeArn", scopeArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scopeId":
            return Optional.ofNullable(clazz.cast(scopeId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "scopeArn":
            return Optional.ofNullable(clazz.cast(scopeArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scopeId", SCOPE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("scopeArn", SCOPE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScopeResponse, T> g) {
        return obj -> g.apply((UpdateScopeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateScopeResponse> {
        /**
         * <p>
         * The identifier for the scope that includes the resources you want to get data results for. A scope ID is an
         * internally-generated identifier that includes all the resources for a specific root account.
         * </p>
         * 
         * @param scopeId
         *        The identifier for the scope that includes the resources you want to get data results for. A scope ID
         *        is an internally-generated identifier that includes all the resources for a specific root account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeId(String scopeId);

        /**
         * <p>
         * The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
         * <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>.
         * </p>
         * <p>
         * A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network Flow
         * Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that the
         * deactivating process is complete.
         * </p>
         * 
         * @param status
         *        The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
         *        <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>
         *        .</p>
         *        <p>
         *        A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and
         *        Network Flow Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code>
         *        means that the deactivating process is complete.
         * @see ScopeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScopeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
         * <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>.
         * </p>
         * <p>
         * A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network Flow
         * Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that the
         * deactivating process is complete.
         * </p>
         * 
         * @param status
         *        The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
         *        <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>
         *        .</p>
         *        <p>
         *        A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and
         *        Network Flow Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code>
         *        means that the deactivating process is complete.
         * @see ScopeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScopeStatus
         */
        Builder status(ScopeStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scope.
         * </p>
         * 
         * @param scopeArn
         *        The Amazon Resource Name (ARN) of the scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeArn(String scopeArn);

        /**
         * <p>
         * The tags for a scope.
         * </p>
         * 
         * @param tags
         *        The tags for a scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends NetworkFlowMonitorResponse.BuilderImpl implements Builder {
        private String scopeId;

        private String status;

        private String scopeArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScopeResponse model) {
            super(model);
            scopeId(model.scopeId);
            status(model.status);
            scopeArn(model.scopeArn);
            tags(model.tags);
        }

        public final String getScopeId() {
            return scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScopeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getScopeArn() {
            return scopeArn;
        }

        public final void setScopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
        }

        @Override
        public final Builder scopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateScopeResponse build() {
            return new UpdateScopeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
