/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMonitorRequest extends NetworkFlowMonitorRequest implements
        ToCopyableBuilder<UpdateMonitorRequest.Builder, UpdateMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorName").getter(getter(UpdateMonitorRequest::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("monitorName").build()).build();

    private static final SdkField<List<MonitorLocalResource>> LOCAL_RESOURCES_TO_ADD_FIELD = SdkField
            .<List<MonitorLocalResource>> builder(MarshallingType.LIST)
            .memberName("localResourcesToAdd")
            .getter(getter(UpdateMonitorRequest::localResourcesToAdd))
            .setter(setter(Builder::localResourcesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localResourcesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorLocalResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorLocalResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MonitorLocalResource>> LOCAL_RESOURCES_TO_REMOVE_FIELD = SdkField
            .<List<MonitorLocalResource>> builder(MarshallingType.LIST)
            .memberName("localResourcesToRemove")
            .getter(getter(UpdateMonitorRequest::localResourcesToRemove))
            .setter(setter(Builder::localResourcesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localResourcesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorLocalResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorLocalResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MonitorRemoteResource>> REMOTE_RESOURCES_TO_ADD_FIELD = SdkField
            .<List<MonitorRemoteResource>> builder(MarshallingType.LIST)
            .memberName("remoteResourcesToAdd")
            .getter(getter(UpdateMonitorRequest::remoteResourcesToAdd))
            .setter(setter(Builder::remoteResourcesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteResourcesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorRemoteResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorRemoteResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MonitorRemoteResource>> REMOTE_RESOURCES_TO_REMOVE_FIELD = SdkField
            .<List<MonitorRemoteResource>> builder(MarshallingType.LIST)
            .memberName("remoteResourcesToRemove")
            .getter(getter(UpdateMonitorRequest::remoteResourcesToRemove))
            .setter(setter(Builder::remoteResourcesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteResourcesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorRemoteResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorRemoteResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateMonitorRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD,
            LOCAL_RESOURCES_TO_ADD_FIELD, LOCAL_RESOURCES_TO_REMOVE_FIELD, REMOTE_RESOURCES_TO_ADD_FIELD,
            REMOTE_RESOURCES_TO_REMOVE_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String monitorName;

    private final List<MonitorLocalResource> localResourcesToAdd;

    private final List<MonitorLocalResource> localResourcesToRemove;

    private final List<MonitorRemoteResource> remoteResourcesToAdd;

    private final List<MonitorRemoteResource> remoteResourcesToRemove;

    private final String clientToken;

    private UpdateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.localResourcesToAdd = builder.localResourcesToAdd;
        this.localResourcesToRemove = builder.localResourcesToRemove;
        this.remoteResourcesToAdd = builder.remoteResourcesToAdd;
        this.remoteResourcesToRemove = builder.remoteResourcesToRemove;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalResourcesToAdd property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLocalResourcesToAdd() {
        return localResourcesToAdd != null && !(localResourcesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional local resources to specify network flows for a monitor, as an array of resources with identifiers and
     * types. A local resource in a workload is the location of hosts where the Network Flow Monitor agent is installed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalResourcesToAdd} method.
     * </p>
     * 
     * @return Additional local resources to specify network flows for a monitor, as an array of resources with
     *         identifiers and types. A local resource in a workload is the location of hosts where the Network Flow
     *         Monitor agent is installed.
     */
    public final List<MonitorLocalResource> localResourcesToAdd() {
        return localResourcesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalResourcesToRemove property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLocalResourcesToRemove() {
        return localResourcesToRemove != null && !(localResourcesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The local resources to remove, as an array of resources with identifiers and types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalResourcesToRemove} method.
     * </p>
     * 
     * @return The local resources to remove, as an array of resources with identifiers and types.
     */
    public final List<MonitorLocalResource> localResourcesToRemove() {
        return localResourcesToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoteResourcesToAdd property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoteResourcesToAdd() {
        return remoteResourcesToAdd != null && !(remoteResourcesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The remote resources to add, as an array of resources with identifiers and types.
     * </p>
     * <p>
     * A remote resource is the other endpoint in the flow of a workload, with a local resource. For example, Amazon
     * Dynamo DB can be a remote resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoteResourcesToAdd} method.
     * </p>
     * 
     * @return The remote resources to add, as an array of resources with identifiers and types.</p>
     *         <p>
     *         A remote resource is the other endpoint in the flow of a workload, with a local resource. For example,
     *         Amazon Dynamo DB can be a remote resource.
     */
    public final List<MonitorRemoteResource> remoteResourcesToAdd() {
        return remoteResourcesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoteResourcesToRemove property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoteResourcesToRemove() {
        return remoteResourcesToRemove != null && !(remoteResourcesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The remote resources to remove, as an array of resources with identifiers and types.
     * </p>
     * <p>
     * A remote resource is the other endpoint specified for the network flow of a workload, with a local resource. For
     * example, Amazon Dynamo DB can be a remote resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoteResourcesToRemove} method.
     * </p>
     * 
     * @return The remote resources to remove, as an array of resources with identifiers and types.</p>
     *         <p>
     *         A remote resource is the other endpoint specified for the network flow of a workload, with a local
     *         resource. For example, Amazon Dynamo DB can be a remote resource.
     */
    public final List<MonitorRemoteResource> remoteResourcesToRemove() {
        return remoteResourcesToRemove;
    }

    /**
     * <p>
     * A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API request.
     * Don't reuse the same client token for other API requests.
     * </p>
     * 
     * @return A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API
     *         request. Don't reuse the same client token for other API requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalResourcesToAdd() ? localResourcesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalResourcesToRemove() ? localResourcesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoteResourcesToAdd() ? remoteResourcesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoteResourcesToRemove() ? remoteResourcesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitorRequest)) {
            return false;
        }
        UpdateMonitorRequest other = (UpdateMonitorRequest) obj;
        return Objects.equals(monitorName(), other.monitorName()) && hasLocalResourcesToAdd() == other.hasLocalResourcesToAdd()
                && Objects.equals(localResourcesToAdd(), other.localResourcesToAdd())
                && hasLocalResourcesToRemove() == other.hasLocalResourcesToRemove()
                && Objects.equals(localResourcesToRemove(), other.localResourcesToRemove())
                && hasRemoteResourcesToAdd() == other.hasRemoteResourcesToAdd()
                && Objects.equals(remoteResourcesToAdd(), other.remoteResourcesToAdd())
                && hasRemoteResourcesToRemove() == other.hasRemoteResourcesToRemove()
                && Objects.equals(remoteResourcesToRemove(), other.remoteResourcesToRemove())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMonitorRequest").add("MonitorName", monitorName())
                .add("LocalResourcesToAdd", hasLocalResourcesToAdd() ? localResourcesToAdd() : null)
                .add("LocalResourcesToRemove", hasLocalResourcesToRemove() ? localResourcesToRemove() : null)
                .add("RemoteResourcesToAdd", hasRemoteResourcesToAdd() ? remoteResourcesToAdd() : null)
                .add("RemoteResourcesToRemove", hasRemoteResourcesToRemove() ? remoteResourcesToRemove() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "localResourcesToAdd":
            return Optional.ofNullable(clazz.cast(localResourcesToAdd()));
        case "localResourcesToRemove":
            return Optional.ofNullable(clazz.cast(localResourcesToRemove()));
        case "remoteResourcesToAdd":
            return Optional.ofNullable(clazz.cast(remoteResourcesToAdd()));
        case "remoteResourcesToRemove":
            return Optional.ofNullable(clazz.cast(remoteResourcesToRemove()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("monitorName", MONITOR_NAME_FIELD);
        map.put("localResourcesToAdd", LOCAL_RESOURCES_TO_ADD_FIELD);
        map.put("localResourcesToRemove", LOCAL_RESOURCES_TO_REMOVE_FIELD);
        map.put("remoteResourcesToAdd", REMOTE_RESOURCES_TO_ADD_FIELD);
        map.put("remoteResourcesToRemove", REMOTE_RESOURCES_TO_REMOVE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitorRequest, T> g) {
        return obj -> g.apply((UpdateMonitorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMonitorRequest> {
        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * Additional local resources to specify network flows for a monitor, as an array of resources with identifiers
         * and types. A local resource in a workload is the location of hosts where the Network Flow Monitor agent is
         * installed.
         * </p>
         * 
         * @param localResourcesToAdd
         *        Additional local resources to specify network flows for a monitor, as an array of resources with
         *        identifiers and types. A local resource in a workload is the location of hosts where the Network Flow
         *        Monitor agent is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localResourcesToAdd(Collection<MonitorLocalResource> localResourcesToAdd);

        /**
         * <p>
         * Additional local resources to specify network flows for a monitor, as an array of resources with identifiers
         * and types. A local resource in a workload is the location of hosts where the Network Flow Monitor agent is
         * installed.
         * </p>
         * 
         * @param localResourcesToAdd
         *        Additional local resources to specify network flows for a monitor, as an array of resources with
         *        identifiers and types. A local resource in a workload is the location of hosts where the Network Flow
         *        Monitor agent is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localResourcesToAdd(MonitorLocalResource... localResourcesToAdd);

        /**
         * <p>
         * Additional local resources to specify network flows for a monitor, as an array of resources with identifiers
         * and types. A local resource in a workload is the location of hosts where the Network Flow Monitor agent is
         * installed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder#build()} is
         * called immediately and its result is passed to {@link #localResourcesToAdd(List<MonitorLocalResource>)}.
         * 
         * @param localResourcesToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localResourcesToAdd(java.util.Collection<MonitorLocalResource>)
         */
        Builder localResourcesToAdd(Consumer<MonitorLocalResource.Builder>... localResourcesToAdd);

        /**
         * <p>
         * The local resources to remove, as an array of resources with identifiers and types.
         * </p>
         * 
         * @param localResourcesToRemove
         *        The local resources to remove, as an array of resources with identifiers and types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localResourcesToRemove(Collection<MonitorLocalResource> localResourcesToRemove);

        /**
         * <p>
         * The local resources to remove, as an array of resources with identifiers and types.
         * </p>
         * 
         * @param localResourcesToRemove
         *        The local resources to remove, as an array of resources with identifiers and types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localResourcesToRemove(MonitorLocalResource... localResourcesToRemove);

        /**
         * <p>
         * The local resources to remove, as an array of resources with identifiers and types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder#build()} is
         * called immediately and its result is passed to {@link #localResourcesToRemove(List<MonitorLocalResource>)}.
         * 
         * @param localResourcesToRemove
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localResourcesToRemove(java.util.Collection<MonitorLocalResource>)
         */
        Builder localResourcesToRemove(Consumer<MonitorLocalResource.Builder>... localResourcesToRemove);

        /**
         * <p>
         * The remote resources to add, as an array of resources with identifiers and types.
         * </p>
         * <p>
         * A remote resource is the other endpoint in the flow of a workload, with a local resource. For example, Amazon
         * Dynamo DB can be a remote resource.
         * </p>
         * 
         * @param remoteResourcesToAdd
         *        The remote resources to add, as an array of resources with identifiers and types.</p>
         *        <p>
         *        A remote resource is the other endpoint in the flow of a workload, with a local resource. For example,
         *        Amazon Dynamo DB can be a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteResourcesToAdd(Collection<MonitorRemoteResource> remoteResourcesToAdd);

        /**
         * <p>
         * The remote resources to add, as an array of resources with identifiers and types.
         * </p>
         * <p>
         * A remote resource is the other endpoint in the flow of a workload, with a local resource. For example, Amazon
         * Dynamo DB can be a remote resource.
         * </p>
         * 
         * @param remoteResourcesToAdd
         *        The remote resources to add, as an array of resources with identifiers and types.</p>
         *        <p>
         *        A remote resource is the other endpoint in the flow of a workload, with a local resource. For example,
         *        Amazon Dynamo DB can be a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteResourcesToAdd(MonitorRemoteResource... remoteResourcesToAdd);

        /**
         * <p>
         * The remote resources to add, as an array of resources with identifiers and types.
         * </p>
         * <p>
         * A remote resource is the other endpoint in the flow of a workload, with a local resource. For example, Amazon
         * Dynamo DB can be a remote resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder#build()} is
         * called immediately and its result is passed to {@link #remoteResourcesToAdd(List<MonitorRemoteResource>)}.
         * 
         * @param remoteResourcesToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteResourcesToAdd(java.util.Collection<MonitorRemoteResource>)
         */
        Builder remoteResourcesToAdd(Consumer<MonitorRemoteResource.Builder>... remoteResourcesToAdd);

        /**
         * <p>
         * The remote resources to remove, as an array of resources with identifiers and types.
         * </p>
         * <p>
         * A remote resource is the other endpoint specified for the network flow of a workload, with a local resource.
         * For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * 
         * @param remoteResourcesToRemove
         *        The remote resources to remove, as an array of resources with identifiers and types.</p>
         *        <p>
         *        A remote resource is the other endpoint specified for the network flow of a workload, with a local
         *        resource. For example, Amazon Dynamo DB can be a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteResourcesToRemove(Collection<MonitorRemoteResource> remoteResourcesToRemove);

        /**
         * <p>
         * The remote resources to remove, as an array of resources with identifiers and types.
         * </p>
         * <p>
         * A remote resource is the other endpoint specified for the network flow of a workload, with a local resource.
         * For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * 
         * @param remoteResourcesToRemove
         *        The remote resources to remove, as an array of resources with identifiers and types.</p>
         *        <p>
         *        A remote resource is the other endpoint specified for the network flow of a workload, with a local
         *        resource. For example, Amazon Dynamo DB can be a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteResourcesToRemove(MonitorRemoteResource... remoteResourcesToRemove);

        /**
         * <p>
         * The remote resources to remove, as an array of resources with identifiers and types.
         * </p>
         * <p>
         * A remote resource is the other endpoint specified for the network flow of a workload, with a local resource.
         * For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder#build()} is
         * called immediately and its result is passed to {@link #remoteResourcesToRemove(List<MonitorRemoteResource>)}.
         * 
         * @param remoteResourcesToRemove
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteResourcesToRemove(java.util.Collection<MonitorRemoteResource>)
         */
        Builder remoteResourcesToRemove(Consumer<MonitorRemoteResource.Builder>... remoteResourcesToRemove);

        /**
         * <p>
         * A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API
         * request. Don't reuse the same client token for other API requests.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent
         *        API request. Don't reuse the same client token for other API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFlowMonitorRequest.BuilderImpl implements Builder {
        private String monitorName;

        private List<MonitorLocalResource> localResourcesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<MonitorLocalResource> localResourcesToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<MonitorRemoteResource> remoteResourcesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<MonitorRemoteResource> remoteResourcesToRemove = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitorRequest model) {
            super(model);
            monitorName(model.monitorName);
            localResourcesToAdd(model.localResourcesToAdd);
            localResourcesToRemove(model.localResourcesToRemove);
            remoteResourcesToAdd(model.remoteResourcesToAdd);
            remoteResourcesToRemove(model.remoteResourcesToRemove);
            clientToken(model.clientToken);
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final List<MonitorLocalResource.Builder> getLocalResourcesToAdd() {
            List<MonitorLocalResource.Builder> result = MonitorLocalResourcesCopier.copyToBuilder(this.localResourcesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalResourcesToAdd(Collection<MonitorLocalResource.BuilderImpl> localResourcesToAdd) {
            this.localResourcesToAdd = MonitorLocalResourcesCopier.copyFromBuilder(localResourcesToAdd);
        }

        @Override
        public final Builder localResourcesToAdd(Collection<MonitorLocalResource> localResourcesToAdd) {
            this.localResourcesToAdd = MonitorLocalResourcesCopier.copy(localResourcesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResourcesToAdd(MonitorLocalResource... localResourcesToAdd) {
            localResourcesToAdd(Arrays.asList(localResourcesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResourcesToAdd(Consumer<MonitorLocalResource.Builder>... localResourcesToAdd) {
            localResourcesToAdd(Stream.of(localResourcesToAdd).map(c -> MonitorLocalResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorLocalResource.Builder> getLocalResourcesToRemove() {
            List<MonitorLocalResource.Builder> result = MonitorLocalResourcesCopier.copyToBuilder(this.localResourcesToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalResourcesToRemove(Collection<MonitorLocalResource.BuilderImpl> localResourcesToRemove) {
            this.localResourcesToRemove = MonitorLocalResourcesCopier.copyFromBuilder(localResourcesToRemove);
        }

        @Override
        public final Builder localResourcesToRemove(Collection<MonitorLocalResource> localResourcesToRemove) {
            this.localResourcesToRemove = MonitorLocalResourcesCopier.copy(localResourcesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResourcesToRemove(MonitorLocalResource... localResourcesToRemove) {
            localResourcesToRemove(Arrays.asList(localResourcesToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResourcesToRemove(Consumer<MonitorLocalResource.Builder>... localResourcesToRemove) {
            localResourcesToRemove(Stream.of(localResourcesToRemove)
                    .map(c -> MonitorLocalResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorRemoteResource.Builder> getRemoteResourcesToAdd() {
            List<MonitorRemoteResource.Builder> result = MonitorRemoteResourcesCopier.copyToBuilder(this.remoteResourcesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteResourcesToAdd(Collection<MonitorRemoteResource.BuilderImpl> remoteResourcesToAdd) {
            this.remoteResourcesToAdd = MonitorRemoteResourcesCopier.copyFromBuilder(remoteResourcesToAdd);
        }

        @Override
        public final Builder remoteResourcesToAdd(Collection<MonitorRemoteResource> remoteResourcesToAdd) {
            this.remoteResourcesToAdd = MonitorRemoteResourcesCopier.copy(remoteResourcesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResourcesToAdd(MonitorRemoteResource... remoteResourcesToAdd) {
            remoteResourcesToAdd(Arrays.asList(remoteResourcesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResourcesToAdd(Consumer<MonitorRemoteResource.Builder>... remoteResourcesToAdd) {
            remoteResourcesToAdd(Stream.of(remoteResourcesToAdd)
                    .map(c -> MonitorRemoteResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorRemoteResource.Builder> getRemoteResourcesToRemove() {
            List<MonitorRemoteResource.Builder> result = MonitorRemoteResourcesCopier.copyToBuilder(this.remoteResourcesToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteResourcesToRemove(Collection<MonitorRemoteResource.BuilderImpl> remoteResourcesToRemove) {
            this.remoteResourcesToRemove = MonitorRemoteResourcesCopier.copyFromBuilder(remoteResourcesToRemove);
        }

        @Override
        public final Builder remoteResourcesToRemove(Collection<MonitorRemoteResource> remoteResourcesToRemove) {
            this.remoteResourcesToRemove = MonitorRemoteResourcesCopier.copy(remoteResourcesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResourcesToRemove(MonitorRemoteResource... remoteResourcesToRemove) {
            remoteResourcesToRemove(Arrays.asList(remoteResourcesToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResourcesToRemove(Consumer<MonitorRemoteResource.Builder>... remoteResourcesToRemove) {
            remoteResourcesToRemove(Stream.of(remoteResourcesToRemove)
                    .map(c -> MonitorRemoteResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitorRequest build() {
            return new UpdateMonitorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
