/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A target resource in a scope. The resource is identified by a Region and an account, defined by a target identifier.
 * A target identifier is made up of a target ID (currently always an account ID) and a target type (currently always
 * <code>ACCOUNT</code>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetResource implements SdkPojo, Serializable, ToCopyableBuilder<TargetResource.Builder, TargetResource> {
    private static final SdkField<TargetIdentifier> TARGET_IDENTIFIER_FIELD = SdkField
            .<TargetIdentifier> builder(MarshallingType.SDK_POJO).memberName("targetIdentifier")
            .getter(getter(TargetResource::targetIdentifier)).setter(setter(Builder::targetIdentifier))
            .constructor(TargetIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(TargetResource::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_IDENTIFIER_FIELD,
            REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TargetIdentifier targetIdentifier;

    private final String region;

    private TargetResource(BuilderImpl builder) {
        this.targetIdentifier = builder.targetIdentifier;
        this.region = builder.region;
    }

    /**
     * <p>
     * A target identifier is a pair of identifying information for a scope. A target identifier is made up of a
     * targetID (currently always an account ID) and a targetType (currently always an account).
     * </p>
     * 
     * @return A target identifier is a pair of identifying information for a scope. A target identifier is made up of a
     *         targetID (currently always an account ID) and a targetType (currently always an account).
     */
    public final TargetIdentifier targetIdentifier() {
        return targetIdentifier;
    }

    /**
     * <p>
     * The Amazon Web Services Region for the scope.
     * </p>
     * 
     * @return The Amazon Web Services Region for the scope.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetResource)) {
            return false;
        }
        TargetResource other = (TargetResource) obj;
        return Objects.equals(targetIdentifier(), other.targetIdentifier()) && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetResource").add("TargetIdentifier", targetIdentifier()).add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        map.put("region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetResource, T> g) {
        return obj -> g.apply((TargetResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetResource> {
        /**
         * <p>
         * A target identifier is a pair of identifying information for a scope. A target identifier is made up of a
         * targetID (currently always an account ID) and a targetType (currently always an account).
         * </p>
         * 
         * @param targetIdentifier
         *        A target identifier is a pair of identifying information for a scope. A target identifier is made up
         *        of a targetID (currently always an account ID) and a targetType (currently always an account).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(TargetIdentifier targetIdentifier);

        /**
         * <p>
         * A target identifier is a pair of identifying information for a scope. A target identifier is made up of a
         * targetID (currently always an account ID) and a targetType (currently always an account).
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetIdentifier.Builder} avoiding the
         * need to create one manually via {@link TargetIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #targetIdentifier(TargetIdentifier)}.
         * 
         * @param targetIdentifier
         *        a consumer that will call methods on {@link TargetIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetIdentifier(TargetIdentifier)
         */
        default Builder targetIdentifier(Consumer<TargetIdentifier.Builder> targetIdentifier) {
            return targetIdentifier(TargetIdentifier.builder().applyMutation(targetIdentifier).build());
        }

        /**
         * <p>
         * The Amazon Web Services Region for the scope.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region for the scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private TargetIdentifier targetIdentifier;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetResource model) {
            targetIdentifier(model.targetIdentifier);
            region(model.region);
        }

        public final TargetIdentifier.Builder getTargetIdentifier() {
            return targetIdentifier != null ? targetIdentifier.toBuilder() : null;
        }

        public final void setTargetIdentifier(TargetIdentifier.BuilderImpl targetIdentifier) {
            this.targetIdentifier = targetIdentifier != null ? targetIdentifier.build() : null;
        }

        @Override
        public final Builder targetIdentifier(TargetIdentifier targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public TargetResource build() {
            return new TargetResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
