/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartQueryWorkloadInsightsTopContributorsDataRequest extends NetworkFlowMonitorRequest
        implements
        ToCopyableBuilder<StartQueryWorkloadInsightsTopContributorsDataRequest.Builder, StartQueryWorkloadInsightsTopContributorsDataRequest> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scopeId").getter(getter(StartQueryWorkloadInsightsTopContributorsDataRequest::scopeId))
            .setter(setter(Builder::scopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("scopeId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(StartQueryWorkloadInsightsTopContributorsDataRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(StartQueryWorkloadInsightsTopContributorsDataRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(StartQueryWorkloadInsightsTopContributorsDataRequest::metricNameAsString))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> DESTINATION_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationCategory")
            .getter(getter(StartQueryWorkloadInsightsTopContributorsDataRequest::destinationCategoryAsString))
            .setter(setter(Builder::destinationCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCategory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, METRIC_NAME_FIELD, DESTINATION_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scopeId;

    private final Instant startTime;

    private final Instant endTime;

    private final String metricName;

    private final String destinationCategory;

    private StartQueryWorkloadInsightsTopContributorsDataRequest(BuilderImpl builder) {
        super(builder);
        this.scopeId = builder.scopeId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.metricName = builder.metricName;
        this.destinationCategory = builder.destinationCategory;
    }

    /**
     * <p>
     * The identifier for the scope that includes the resources you want to get data results for. A scope ID is an
     * internally-generated identifier that includes all the resources for a specific root account.
     * </p>
     * 
     * @return The identifier for the scope that includes the resources you want to get data results for. A scope ID is
     *         an internally-generated identifier that includes all the resources for a specific root account.
     */
    public final String scopeId() {
        return scopeId;
    }

    /**
     * <p>
     * The timestamp that is the date and time that is the beginning of the period that you want to retrieve results for
     * with your query.
     * </p>
     * 
     * @return The timestamp that is the date and time that is the beginning of the period that you want to retrieve
     *         results for with your query.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp that is the date and time end of the period that you want to retrieve results for with your query.
     * </p>
     * 
     * @return The timestamp that is the date and time end of the period that you want to retrieve results for with your
     *         query.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The metric that you want to query top contributors for. That is, you can specify this metric to return the top
     * contributor network flows, for this type of metric, for a monitor and (optionally) within a specific category,
     * such as network flows between Availability Zones.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link WorkloadInsightsMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric that you want to query top contributors for. That is, you can specify this metric to return
     *         the top contributor network flows, for this type of metric, for a monitor and (optionally) within a
     *         specific category, such as network flows between Availability Zones.
     * @see WorkloadInsightsMetric
     */
    public final WorkloadInsightsMetric metricName() {
        return WorkloadInsightsMetric.fromValue(metricName);
    }

    /**
     * <p>
     * The metric that you want to query top contributors for. That is, you can specify this metric to return the top
     * contributor network flows, for this type of metric, for a monitor and (optionally) within a specific category,
     * such as network flows between Availability Zones.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link WorkloadInsightsMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric that you want to query top contributors for. That is, you can specify this metric to return
     *         the top contributor network flows, for this type of metric, for a monitor and (optionally) within a
     *         specific category, such as network flows between Availability Zones.
     * @see WorkloadInsightsMetric
     */
    public final String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * The destination category for a top contributors. Destination categories can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_VPC</code>: Top contributor network flows between VPCs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationCategory} will return {@link DestinationCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #destinationCategoryAsString}.
     * </p>
     * 
     * @return The destination category for a top contributors. Destination categories can be one of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_VPC</code>: Top contributor network flows between VPCs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
     *         </p>
     *         </li>
     * @see DestinationCategory
     */
    public final DestinationCategory destinationCategory() {
        return DestinationCategory.fromValue(destinationCategory);
    }

    /**
     * <p>
     * The destination category for a top contributors. Destination categories can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_VPC</code>: Top contributor network flows between VPCs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationCategory} will return {@link DestinationCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #destinationCategoryAsString}.
     * </p>
     * 
     * @return The destination category for a top contributors. Destination categories can be one of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_VPC</code>: Top contributor network flows between VPCs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
     *         </p>
     *         </li>
     * @see DestinationCategory
     */
    public final String destinationCategoryAsString() {
        return destinationCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCategoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryWorkloadInsightsTopContributorsDataRequest)) {
            return false;
        }
        StartQueryWorkloadInsightsTopContributorsDataRequest other = (StartQueryWorkloadInsightsTopContributorsDataRequest) obj;
        return Objects.equals(scopeId(), other.scopeId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(metricNameAsString(), other.metricNameAsString())
                && Objects.equals(destinationCategoryAsString(), other.destinationCategoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartQueryWorkloadInsightsTopContributorsDataRequest").add("ScopeId", scopeId())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("MetricName", metricNameAsString())
                .add("DestinationCategory", destinationCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scopeId":
            return Optional.ofNullable(clazz.cast(scopeId()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "destinationCategory":
            return Optional.ofNullable(clazz.cast(destinationCategoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scopeId", SCOPE_ID_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("destinationCategory", DESTINATION_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartQueryWorkloadInsightsTopContributorsDataRequest, T> g) {
        return obj -> g.apply((StartQueryWorkloadInsightsTopContributorsDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartQueryWorkloadInsightsTopContributorsDataRequest> {
        /**
         * <p>
         * The identifier for the scope that includes the resources you want to get data results for. A scope ID is an
         * internally-generated identifier that includes all the resources for a specific root account.
         * </p>
         * 
         * @param scopeId
         *        The identifier for the scope that includes the resources you want to get data results for. A scope ID
         *        is an internally-generated identifier that includes all the resources for a specific root account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeId(String scopeId);

        /**
         * <p>
         * The timestamp that is the date and time that is the beginning of the period that you want to retrieve results
         * for with your query.
         * </p>
         * 
         * @param startTime
         *        The timestamp that is the date and time that is the beginning of the period that you want to retrieve
         *        results for with your query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp that is the date and time end of the period that you want to retrieve results for with your
         * query.
         * </p>
         * 
         * @param endTime
         *        The timestamp that is the date and time end of the period that you want to retrieve results for with
         *        your query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The metric that you want to query top contributors for. That is, you can specify this metric to return the
         * top contributor network flows, for this type of metric, for a monitor and (optionally) within a specific
         * category, such as network flows between Availability Zones.
         * </p>
         * 
         * @param metricName
         *        The metric that you want to query top contributors for. That is, you can specify this metric to return
         *        the top contributor network flows, for this type of metric, for a monitor and (optionally) within a
         *        specific category, such as network flows between Availability Zones.
         * @see WorkloadInsightsMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadInsightsMetric
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric that you want to query top contributors for. That is, you can specify this metric to return the
         * top contributor network flows, for this type of metric, for a monitor and (optionally) within a specific
         * category, such as network flows between Availability Zones.
         * </p>
         * 
         * @param metricName
         *        The metric that you want to query top contributors for. That is, you can specify this metric to return
         *        the top contributor network flows, for this type of metric, for a monitor and (optionally) within a
         *        specific category, such as network flows between Availability Zones.
         * @see WorkloadInsightsMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadInsightsMetric
         */
        Builder metricName(WorkloadInsightsMetric metricName);

        /**
         * <p>
         * The destination category for a top contributors. Destination categories can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_VPC</code>: Top contributor network flows between VPCs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationCategory
         *        The destination category for a top contributors. Destination categories can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another
         *        Region)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_VPC</code>: Top contributor network flows between VPCs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
         *        </p>
         *        </li>
         * @see DestinationCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationCategory
         */
        Builder destinationCategory(String destinationCategory);

        /**
         * <p>
         * The destination category for a top contributors. Destination categories can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_VPC</code>: Top contributor network flows between VPCs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationCategory
         *        The destination category for a top contributors. Destination categories can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another
         *        Region)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_VPC</code>: Top contributor network flows between VPCs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
         *        </p>
         *        </li>
         * @see DestinationCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationCategory
         */
        Builder destinationCategory(DestinationCategory destinationCategory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFlowMonitorRequest.BuilderImpl implements Builder {
        private String scopeId;

        private Instant startTime;

        private Instant endTime;

        private String metricName;

        private String destinationCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryWorkloadInsightsTopContributorsDataRequest model) {
            super(model);
            scopeId(model.scopeId);
            startTime(model.startTime);
            endTime(model.endTime);
            metricName(model.metricName);
            destinationCategory(model.destinationCategory);
        }

        public final String getScopeId() {
            return scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(WorkloadInsightsMetric metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final String getDestinationCategory() {
            return destinationCategory;
        }

        public final void setDestinationCategory(String destinationCategory) {
            this.destinationCategory = destinationCategory;
        }

        @Override
        public final Builder destinationCategory(String destinationCategory) {
            this.destinationCategory = destinationCategory;
            return this;
        }

        @Override
        public final Builder destinationCategory(DestinationCategory destinationCategory) {
            this.destinationCategory(destinationCategory == null ? null : destinationCategory.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryWorkloadInsightsTopContributorsDataRequest build() {
            return new StartQueryWorkloadInsightsTopContributorsDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
