/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a scope, including the ARN, target ID, and Amazon Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScopeSummary implements SdkPojo, Serializable, ToCopyableBuilder<ScopeSummary.Builder, ScopeSummary> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scopeId").getter(getter(ScopeSummary::scopeId)).setter(setter(Builder::scopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ScopeSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SCOPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scopeArn").getter(getter(ScopeSummary::scopeArn)).setter(setter(Builder::scopeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD, STATUS_FIELD,
            SCOPE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scopeId;

    private final String status;

    private final String scopeArn;

    private ScopeSummary(BuilderImpl builder) {
        this.scopeId = builder.scopeId;
        this.status = builder.status;
        this.scopeArn = builder.scopeArn;
    }

    /**
     * <p>
     * The identifier for the scope that includes the resources that you want to get data results for. A scope ID is an
     * internally-generated identifier that includes all the resources for the accounts in a scope.
     * </p>
     * 
     * @return The identifier for the scope that includes the resources that you want to get data results for. A scope
     *         ID is an internally-generated identifier that includes all the resources for the accounts in a scope.
     */
    public final String scopeId() {
        return scopeId;
    }

    /**
     * <p>
     * The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>, <code>IN_PROGRESS</code>,
     * <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>.
     * </p>
     * <p>
     * A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network Flow
     * Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that the
     * deactivating process is complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ScopeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
     *         <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>
     *         .</p>
     *         <p>
     *         A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network
     *         Flow Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that
     *         the deactivating process is complete.
     * @see ScopeStatus
     */
    public final ScopeStatus status() {
        return ScopeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>, <code>IN_PROGRESS</code>,
     * <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>.
     * </p>
     * <p>
     * A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network Flow
     * Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that the
     * deactivating process is complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ScopeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
     *         <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>
     *         .</p>
     *         <p>
     *         A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network
     *         Flow Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that
     *         the deactivating process is complete.
     * @see ScopeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scope.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scope.
     */
    public final String scopeArn() {
        return scopeArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scopeArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeSummary)) {
            return false;
        }
        ScopeSummary other = (ScopeSummary) obj;
        return Objects.equals(scopeId(), other.scopeId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(scopeArn(), other.scopeArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScopeSummary").add("ScopeId", scopeId()).add("Status", statusAsString())
                .add("ScopeArn", scopeArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scopeId":
            return Optional.ofNullable(clazz.cast(scopeId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "scopeArn":
            return Optional.ofNullable(clazz.cast(scopeArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scopeId", SCOPE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("scopeArn", SCOPE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScopeSummary, T> g) {
        return obj -> g.apply((ScopeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScopeSummary> {
        /**
         * <p>
         * The identifier for the scope that includes the resources that you want to get data results for. A scope ID is
         * an internally-generated identifier that includes all the resources for the accounts in a scope.
         * </p>
         * 
         * @param scopeId
         *        The identifier for the scope that includes the resources that you want to get data results for. A
         *        scope ID is an internally-generated identifier that includes all the resources for the accounts in a
         *        scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeId(String scopeId);

        /**
         * <p>
         * The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
         * <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>.
         * </p>
         * <p>
         * A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network Flow
         * Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that the
         * deactivating process is complete.
         * </p>
         * 
         * @param status
         *        The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
         *        <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>
         *        .</p>
         *        <p>
         *        A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and
         *        Network Flow Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code>
         *        means that the deactivating process is complete.
         * @see ScopeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScopeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
         * <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>.
         * </p>
         * <p>
         * A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and Network Flow
         * Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code> means that the
         * deactivating process is complete.
         * </p>
         * 
         * @param status
         *        The status for a scope. The status can be one of the following: <code>SUCCEEDED</code>,
         *        <code>IN_PROGRESS</code>, <code>FAILED</code>, <code>DEACTIVATING</code>, or <code>DEACTIVATED</code>
         *        .</p>
         *        <p>
         *        A status of <code>DEACTIVATING</code> means that you've requested a scope to be deactivated and
         *        Network Flow Monitor is in the process of deactivating the scope. A status of <code>DEACTIVATED</code>
         *        means that the deactivating process is complete.
         * @see ScopeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScopeStatus
         */
        Builder status(ScopeStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scope.
         * </p>
         * 
         * @param scopeArn
         *        The Amazon Resource Name (ARN) of the scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeArn(String scopeArn);
    }

    static final class BuilderImpl implements Builder {
        private String scopeId;

        private String status;

        private String scopeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ScopeSummary model) {
            scopeId(model.scopeId);
            status(model.status);
            scopeArn(model.scopeArn);
        }

        public final String getScopeId() {
            return scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScopeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getScopeArn() {
            return scopeArn;
        }

        public final void setScopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
        }

        @Override
        public final Builder scopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
            return this;
        }

        @Override
        public ScopeSummary build() {
            return new ScopeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
