/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a monitor, including the ARN, the name, and the status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitorSummary implements SdkPojo, Serializable, ToCopyableBuilder<MonitorSummary.Builder, MonitorSummary> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorArn").getter(getter(MonitorSummary::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorArn").build()).build();

    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorName").getter(getter(MonitorSummary::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()).build();

    private static final SdkField<String> MONITOR_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorStatus").getter(getter(MonitorSummary::monitorStatusAsString))
            .setter(setter(Builder::monitorStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD,
            MONITOR_NAME_FIELD, MONITOR_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String monitorArn;

    private final String monitorName;

    private final String monitorStatus;

    private MonitorSummary(BuilderImpl builder) {
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.monitorStatus = builder.monitorStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitor.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * <p>
     * The status of a monitor. The status can be one of the following
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The monitor is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The monitor is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>: The monitor is inactive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: Monitor creation failed due to an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: The monitor is in the process of being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitorStatus}
     * will return {@link MonitorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monitorStatusAsString}.
     * </p>
     * 
     * @return The status of a monitor. The status can be one of the following</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The monitor is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The monitor is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>: The monitor is inactive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: Monitor creation failed due to an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: The monitor is in the process of being deleted.
     *         </p>
     *         </li>
     * @see MonitorStatus
     */
    public final MonitorStatus monitorStatus() {
        return MonitorStatus.fromValue(monitorStatus);
    }

    /**
     * <p>
     * The status of a monitor. The status can be one of the following
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The monitor is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The monitor is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>: The monitor is inactive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: Monitor creation failed due to an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: The monitor is in the process of being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitorStatus}
     * will return {@link MonitorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monitorStatusAsString}.
     * </p>
     * 
     * @return The status of a monitor. The status can be one of the following</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The monitor is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The monitor is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>: The monitor is inactive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: Monitor creation failed due to an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: The monitor is in the process of being deleted.
     *         </p>
     *         </li>
     * @see MonitorStatus
     */
    public final String monitorStatusAsString() {
        return monitorStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(monitorStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorSummary)) {
            return false;
        }
        MonitorSummary other = (MonitorSummary) obj;
        return Objects.equals(monitorArn(), other.monitorArn()) && Objects.equals(monitorName(), other.monitorName())
                && Objects.equals(monitorStatusAsString(), other.monitorStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitorSummary").add("MonitorArn", monitorArn()).add("MonitorName", monitorName())
                .add("MonitorStatus", monitorStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "monitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "monitorStatus":
            return Optional.ofNullable(clazz.cast(monitorStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("monitorArn", MONITOR_ARN_FIELD);
        map.put("monitorName", MONITOR_NAME_FIELD);
        map.put("monitorStatus", MONITOR_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitorSummary, T> g) {
        return obj -> g.apply((MonitorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitorSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitor.
         * </p>
         * 
         * @param monitorArn
         *        The Amazon Resource Name (ARN) of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The status of a monitor. The status can be one of the following
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The monitor is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The monitor is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>: The monitor is inactive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Monitor creation failed due to an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: The monitor is in the process of being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param monitorStatus
         *        The status of a monitor. The status can be one of the following</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The monitor is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The monitor is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>: The monitor is inactive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Monitor creation failed due to an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: The monitor is in the process of being deleted.
         *        </p>
         *        </li>
         * @see MonitorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorStatus
         */
        Builder monitorStatus(String monitorStatus);

        /**
         * <p>
         * The status of a monitor. The status can be one of the following
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The monitor is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The monitor is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>: The monitor is inactive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Monitor creation failed due to an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: The monitor is in the process of being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param monitorStatus
         *        The status of a monitor. The status can be one of the following</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The monitor is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The monitor is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>: The monitor is inactive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Monitor creation failed due to an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: The monitor is in the process of being deleted.
         *        </p>
         *        </li>
         * @see MonitorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorStatus
         */
        Builder monitorStatus(MonitorStatus monitorStatus);
    }

    static final class BuilderImpl implements Builder {
        private String monitorArn;

        private String monitorName;

        private String monitorStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorSummary model) {
            monitorArn(model.monitorArn);
            monitorName(model.monitorName);
            monitorStatus(model.monitorStatus);
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorStatus() {
            return monitorStatus;
        }

        public final void setMonitorStatus(String monitorStatus) {
            this.monitorStatus = monitorStatus;
        }

        @Override
        public final Builder monitorStatus(String monitorStatus) {
            this.monitorStatus = monitorStatus;
            return this;
        }

        @Override
        public final Builder monitorStatus(MonitorStatus monitorStatus) {
            this.monitorStatus(monitorStatus == null ? null : monitorStatus.toString());
            return this;
        }

        @Override
        public MonitorSummary build() {
            return new MonitorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
