/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScopesResponse extends NetworkFlowMonitorResponse implements
        ToCopyableBuilder<ListScopesResponse.Builder, ListScopesResponse> {
    private static final SdkField<List<ScopeSummary>> SCOPES_FIELD = SdkField
            .<List<ScopeSummary>> builder(MarshallingType.LIST)
            .memberName("scopes")
            .getter(getter(ListScopesResponse::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScopeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScopeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListScopesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCOPES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ScopeSummary> scopes;

    private final String nextToken;

    private ListScopesResponse(BuilderImpl builder) {
        super(builder);
        this.scopes = builder.scopes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scopes returned by the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return The scopes returned by the call.
     */
    public final List<ScopeSummary> scopes() {
        return scopes;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScopesResponse)) {
            return false;
        }
        ListScopesResponse other = (ListScopesResponse) obj;
        return hasScopes() == other.hasScopes() && Objects.equals(scopes(), other.scopes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScopesResponse").add("Scopes", hasScopes() ? scopes() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scopes", SCOPES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScopesResponse, T> g) {
        return obj -> g.apply((ListScopesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListScopesResponse> {
        /**
         * <p>
         * The scopes returned by the call.
         * </p>
         * 
         * @param scopes
         *        The scopes returned by the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<ScopeSummary> scopes);

        /**
         * <p>
         * The scopes returned by the call.
         * </p>
         * 
         * @param scopes
         *        The scopes returned by the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(ScopeSummary... scopes);

        /**
         * <p>
         * The scopes returned by the call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.ScopeSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.ScopeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.ScopeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #scopes(List<ScopeSummary>)}.
         * 
         * @param scopes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ScopeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopes(java.util.Collection<ScopeSummary>)
         */
        Builder scopes(Consumer<ScopeSummary.Builder>... scopes);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkFlowMonitorResponse.BuilderImpl implements Builder {
        private List<ScopeSummary> scopes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScopesResponse model) {
            super(model);
            scopes(model.scopes);
            nextToken(model.nextToken);
        }

        public final List<ScopeSummary.Builder> getScopes() {
            List<ScopeSummary.Builder> result = ScopeSummaryListCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<ScopeSummary.BuilderImpl> scopes) {
            this.scopes = ScopeSummaryListCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Collection<ScopeSummary> scopes) {
            this.scopes = ScopeSummaryListCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(ScopeSummary... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<ScopeSummary.Builder>... scopes) {
            scopes(Stream.of(scopes).map(c -> ScopeSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScopesResponse build() {
            return new ListScopesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
