/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMonitorRequest extends NetworkFlowMonitorRequest implements
        ToCopyableBuilder<CreateMonitorRequest.Builder, CreateMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorName").getter(getter(CreateMonitorRequest::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()).build();

    private static final SdkField<List<MonitorLocalResource>> LOCAL_RESOURCES_FIELD = SdkField
            .<List<MonitorLocalResource>> builder(MarshallingType.LIST)
            .memberName("localResources")
            .getter(getter(CreateMonitorRequest::localResources))
            .setter(setter(Builder::localResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorLocalResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorLocalResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MonitorRemoteResource>> REMOTE_RESOURCES_FIELD = SdkField
            .<List<MonitorRemoteResource>> builder(MarshallingType.LIST)
            .memberName("remoteResources")
            .getter(getter(CreateMonitorRequest::remoteResources))
            .setter(setter(Builder::remoteResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorRemoteResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorRemoteResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCOPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scopeArn").getter(getter(CreateMonitorRequest::scopeArn)).setter(setter(Builder::scopeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateMonitorRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMonitorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD,
            LOCAL_RESOURCES_FIELD, REMOTE_RESOURCES_FIELD, SCOPE_ARN_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String monitorName;

    private final List<MonitorLocalResource> localResources;

    private final List<MonitorRemoteResource> remoteResources;

    private final String scopeArn;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.localResources = builder.localResources;
        this.remoteResources = builder.remoteResources;
        this.scopeArn = builder.scopeArn;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLocalResources() {
        return localResources != null && !(localResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The local resources to monitor. A local resource in a workload is the location of the host, or hosts, where the
     * Network Flow Monitor agent is installed. For example, if a workload consists of an interaction between a web
     * service and a backend database (for example, Amazon Dynamo DB), the subnet with the EC2 instance that hosts the
     * web service, which also runs the agent, is the local resource.
     * </p>
     * <p>
     * Be aware that all local resources must belong to the current Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalResources} method.
     * </p>
     * 
     * @return The local resources to monitor. A local resource in a workload is the location of the host, or hosts,
     *         where the Network Flow Monitor agent is installed. For example, if a workload consists of an interaction
     *         between a web service and a backend database (for example, Amazon Dynamo DB), the subnet with the EC2
     *         instance that hosts the web service, which also runs the agent, is the local resource.</p>
     *         <p>
     *         Be aware that all local resources must belong to the current Region.
     */
    public final List<MonitorLocalResource> localResources() {
        return localResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoteResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoteResources() {
        return remoteResources != null && !(remoteResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The remote resources to monitor. A remote resource is the other endpoint in the bi-directional flow of a
     * workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
     * </p>
     * <p>
     * When you specify remote resources, be aware that specific combinations of resources are allowed and others are
     * not, including the following constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All remote resources that you specify must all belong to a single Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify Amazon Web Services services as remote resources, any other remote resources that you specify must
     * be in the current Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you specify a remote resource for another Region, you can only specify the <code>Region</code> resource
     * type. You cannot specify a subnet, VPC, or Availability Zone in another Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you leave the <code>RemoteResources</code> parameter empty, the monitor will include all network flows that
     * terminate in the current Region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoteResources} method.
     * </p>
     * 
     * @return The remote resources to monitor. A remote resource is the other endpoint in the bi-directional flow of a
     *         workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.</p>
     *         <p>
     *         When you specify remote resources, be aware that specific combinations of resources are allowed and
     *         others are not, including the following constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All remote resources that you specify must all belong to a single Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify Amazon Web Services services as remote resources, any other remote resources that you
     *         specify must be in the current Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When you specify a remote resource for another Region, you can only specify the <code>Region</code>
     *         resource type. You cannot specify a subnet, VPC, or Availability Zone in another Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you leave the <code>RemoteResources</code> parameter empty, the monitor will include all network flows
     *         that terminate in the current Region.
     *         </p>
     *         </li>
     */
    public final List<MonitorRemoteResource> remoteResources() {
        return remoteResources;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scope for the monitor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scope for the monitor.
     */
    public final String scopeArn() {
        return scopeArn;
    }

    /**
     * <p>
     * A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API request.
     * Don't reuse the same client token for other API requests.
     * </p>
     * 
     * @return A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API
     *         request. Don't reuse the same client token for other API requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for a monitor. You can add a maximum of 200 tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for a monitor. You can add a maximum of 200 tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalResources() ? localResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoteResources() ? remoteResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scopeArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorRequest)) {
            return false;
        }
        CreateMonitorRequest other = (CreateMonitorRequest) obj;
        return Objects.equals(monitorName(), other.monitorName()) && hasLocalResources() == other.hasLocalResources()
                && Objects.equals(localResources(), other.localResources()) && hasRemoteResources() == other.hasRemoteResources()
                && Objects.equals(remoteResources(), other.remoteResources()) && Objects.equals(scopeArn(), other.scopeArn())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMonitorRequest").add("MonitorName", monitorName())
                .add("LocalResources", hasLocalResources() ? localResources() : null)
                .add("RemoteResources", hasRemoteResources() ? remoteResources() : null).add("ScopeArn", scopeArn())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "localResources":
            return Optional.ofNullable(clazz.cast(localResources()));
        case "remoteResources":
            return Optional.ofNullable(clazz.cast(remoteResources()));
        case "scopeArn":
            return Optional.ofNullable(clazz.cast(scopeArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("monitorName", MONITOR_NAME_FIELD);
        map.put("localResources", LOCAL_RESOURCES_FIELD);
        map.put("remoteResources", REMOTE_RESOURCES_FIELD);
        map.put("scopeArn", SCOPE_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitorRequest, T> g) {
        return obj -> g.apply((CreateMonitorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMonitorRequest> {
        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The local resources to monitor. A local resource in a workload is the location of the host, or hosts, where
         * the Network Flow Monitor agent is installed. For example, if a workload consists of an interaction between a
         * web service and a backend database (for example, Amazon Dynamo DB), the subnet with the EC2 instance that
         * hosts the web service, which also runs the agent, is the local resource.
         * </p>
         * <p>
         * Be aware that all local resources must belong to the current Region.
         * </p>
         * 
         * @param localResources
         *        The local resources to monitor. A local resource in a workload is the location of the host, or hosts,
         *        where the Network Flow Monitor agent is installed. For example, if a workload consists of an
         *        interaction between a web service and a backend database (for example, Amazon Dynamo DB), the subnet
         *        with the EC2 instance that hosts the web service, which also runs the agent, is the local
         *        resource.</p>
         *        <p>
         *        Be aware that all local resources must belong to the current Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localResources(Collection<MonitorLocalResource> localResources);

        /**
         * <p>
         * The local resources to monitor. A local resource in a workload is the location of the host, or hosts, where
         * the Network Flow Monitor agent is installed. For example, if a workload consists of an interaction between a
         * web service and a backend database (for example, Amazon Dynamo DB), the subnet with the EC2 instance that
         * hosts the web service, which also runs the agent, is the local resource.
         * </p>
         * <p>
         * Be aware that all local resources must belong to the current Region.
         * </p>
         * 
         * @param localResources
         *        The local resources to monitor. A local resource in a workload is the location of the host, or hosts,
         *        where the Network Flow Monitor agent is installed. For example, if a workload consists of an
         *        interaction between a web service and a backend database (for example, Amazon Dynamo DB), the subnet
         *        with the EC2 instance that hosts the web service, which also runs the agent, is the local
         *        resource.</p>
         *        <p>
         *        Be aware that all local resources must belong to the current Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localResources(MonitorLocalResource... localResources);

        /**
         * <p>
         * The local resources to monitor. A local resource in a workload is the location of the host, or hosts, where
         * the Network Flow Monitor agent is installed. For example, if a workload consists of an interaction between a
         * web service and a backend database (for example, Amazon Dynamo DB), the subnet with the EC2 instance that
         * hosts the web service, which also runs the agent, is the local resource.
         * </p>
         * <p>
         * Be aware that all local resources must belong to the current Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder#build()} is
         * called immediately and its result is passed to {@link #localResources(List<MonitorLocalResource>)}.
         * 
         * @param localResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localResources(java.util.Collection<MonitorLocalResource>)
         */
        Builder localResources(Consumer<MonitorLocalResource.Builder>... localResources);

        /**
         * <p>
         * The remote resources to monitor. A remote resource is the other endpoint in the bi-directional flow of a
         * workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * <p>
         * When you specify remote resources, be aware that specific combinations of resources are allowed and others
         * are not, including the following constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All remote resources that you specify must all belong to a single Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify Amazon Web Services services as remote resources, any other remote resources that you specify
         * must be in the current Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you specify a remote resource for another Region, you can only specify the <code>Region</code> resource
         * type. You cannot specify a subnet, VPC, or Availability Zone in another Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you leave the <code>RemoteResources</code> parameter empty, the monitor will include all network flows
         * that terminate in the current Region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param remoteResources
         *        The remote resources to monitor. A remote resource is the other endpoint in the bi-directional flow of
         *        a workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.</p>
         *        <p>
         *        When you specify remote resources, be aware that specific combinations of resources are allowed and
         *        others are not, including the following constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All remote resources that you specify must all belong to a single Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify Amazon Web Services services as remote resources, any other remote resources that you
         *        specify must be in the current Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you specify a remote resource for another Region, you can only specify the <code>Region</code>
         *        resource type. You cannot specify a subnet, VPC, or Availability Zone in another Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you leave the <code>RemoteResources</code> parameter empty, the monitor will include all network
         *        flows that terminate in the current Region.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteResources(Collection<MonitorRemoteResource> remoteResources);

        /**
         * <p>
         * The remote resources to monitor. A remote resource is the other endpoint in the bi-directional flow of a
         * workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * <p>
         * When you specify remote resources, be aware that specific combinations of resources are allowed and others
         * are not, including the following constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All remote resources that you specify must all belong to a single Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify Amazon Web Services services as remote resources, any other remote resources that you specify
         * must be in the current Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you specify a remote resource for another Region, you can only specify the <code>Region</code> resource
         * type. You cannot specify a subnet, VPC, or Availability Zone in another Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you leave the <code>RemoteResources</code> parameter empty, the monitor will include all network flows
         * that terminate in the current Region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param remoteResources
         *        The remote resources to monitor. A remote resource is the other endpoint in the bi-directional flow of
         *        a workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.</p>
         *        <p>
         *        When you specify remote resources, be aware that specific combinations of resources are allowed and
         *        others are not, including the following constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All remote resources that you specify must all belong to a single Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify Amazon Web Services services as remote resources, any other remote resources that you
         *        specify must be in the current Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you specify a remote resource for another Region, you can only specify the <code>Region</code>
         *        resource type. You cannot specify a subnet, VPC, or Availability Zone in another Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you leave the <code>RemoteResources</code> parameter empty, the monitor will include all network
         *        flows that terminate in the current Region.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteResources(MonitorRemoteResource... remoteResources);

        /**
         * <p>
         * The remote resources to monitor. A remote resource is the other endpoint in the bi-directional flow of a
         * workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * <p>
         * When you specify remote resources, be aware that specific combinations of resources are allowed and others
         * are not, including the following constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All remote resources that you specify must all belong to a single Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify Amazon Web Services services as remote resources, any other remote resources that you specify
         * must be in the current Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you specify a remote resource for another Region, you can only specify the <code>Region</code> resource
         * type. You cannot specify a subnet, VPC, or Availability Zone in another Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you leave the <code>RemoteResources</code> parameter empty, the monitor will include all network flows
         * that terminate in the current Region.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder#build()} is
         * called immediately and its result is passed to {@link #remoteResources(List<MonitorRemoteResource>)}.
         * 
         * @param remoteResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteResources(java.util.Collection<MonitorRemoteResource>)
         */
        Builder remoteResources(Consumer<MonitorRemoteResource.Builder>... remoteResources);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scope for the monitor.
         * </p>
         * 
         * @param scopeArn
         *        The Amazon Resource Name (ARN) of the scope for the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeArn(String scopeArn);

        /**
         * <p>
         * A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API
         * request. Don't reuse the same client token for other API requests.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent
         *        API request. Don't reuse the same client token for other API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags for a monitor. You can add a maximum of 200 tags.
         * </p>
         * 
         * @param tags
         *        The tags for a monitor. You can add a maximum of 200 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFlowMonitorRequest.BuilderImpl implements Builder {
        private String monitorName;

        private List<MonitorLocalResource> localResources = DefaultSdkAutoConstructList.getInstance();

        private List<MonitorRemoteResource> remoteResources = DefaultSdkAutoConstructList.getInstance();

        private String scopeArn;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitorRequest model) {
            super(model);
            monitorName(model.monitorName);
            localResources(model.localResources);
            remoteResources(model.remoteResources);
            scopeArn(model.scopeArn);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final List<MonitorLocalResource.Builder> getLocalResources() {
            List<MonitorLocalResource.Builder> result = CreateMonitorInputLocalResourcesListCopier
                    .copyToBuilder(this.localResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalResources(Collection<MonitorLocalResource.BuilderImpl> localResources) {
            this.localResources = CreateMonitorInputLocalResourcesListCopier.copyFromBuilder(localResources);
        }

        @Override
        public final Builder localResources(Collection<MonitorLocalResource> localResources) {
            this.localResources = CreateMonitorInputLocalResourcesListCopier.copy(localResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResources(MonitorLocalResource... localResources) {
            localResources(Arrays.asList(localResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResources(Consumer<MonitorLocalResource.Builder>... localResources) {
            localResources(Stream.of(localResources).map(c -> MonitorLocalResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorRemoteResource.Builder> getRemoteResources() {
            List<MonitorRemoteResource.Builder> result = MonitorRemoteResourcesCopier.copyToBuilder(this.remoteResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteResources(Collection<MonitorRemoteResource.BuilderImpl> remoteResources) {
            this.remoteResources = MonitorRemoteResourcesCopier.copyFromBuilder(remoteResources);
        }

        @Override
        public final Builder remoteResources(Collection<MonitorRemoteResource> remoteResources) {
            this.remoteResources = MonitorRemoteResourcesCopier.copy(remoteResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResources(MonitorRemoteResource... remoteResources) {
            remoteResources(Arrays.asList(remoteResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResources(Consumer<MonitorRemoteResource.Builder>... remoteResources) {
            remoteResources(Stream.of(remoteResources).map(c -> MonitorRemoteResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getScopeArn() {
            return scopeArn;
        }

        public final void setScopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
        }

        @Override
        public final Builder scopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMonitorRequest build() {
            return new CreateMonitorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
