/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.networkflowmonitor.model.AccessDeniedException;
import software.amazon.awssdk.services.networkflowmonitor.model.ConflictException;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateScopeRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateScopeResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.DeleteScopeRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.DeleteScopeResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetScopeRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetScopeResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.InternalServerException;
import software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorException;
import software.amazon.awssdk.services.networkflowmonitor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkflowmonitor.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.TagResourceRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.TagResourceResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ThrottlingException;
import software.amazon.awssdk.services.networkflowmonitor.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateScopeRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateScopeResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ValidationException;
import software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsIterable;
import software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataIterable;
import software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsIterable;
import software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsIterable;
import software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesIterable;

/**
 * Service client for accessing Network Flow Monitor. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Network Flow Monitor is a feature of Amazon CloudWatch Network Monitoring that provides visibility into the
 * performance of network flows for your Amazon Web Services workloads, between instances in subnets, as well as to and
 * from Amazon Web Services. Lightweight agents that you install on the instances capture performance metrics for your
 * network flows, such as packet loss and latency, and send them to the Network Flow Monitor backend. Then, you can view
 * and analyze metrics from the top contributors for each metric type, to help troubleshoot issues.
 * </p>
 * <p>
 * In addition, when you create a monitor, Network Flow Monitor provides a network health indicator (NHI) that informs
 * you whether there were Amazon Web Services network issues for one or more of the network flows tracked by a monitor,
 * during a time period that you choose. By using this value, you can independently determine if the Amazon Web Services
 * network is impacting your workload during a specific time frame, to help you focus troubleshooting efforts.
 * </p>
 * <p>
 * To learn more about Network Flow Monitor, see the <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-NetworkFlowMonitor.html">Network Flow
 * Monitor User Guide</a> in the Amazon CloudWatch User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NetworkFlowMonitorClient extends AwsClient {
    String SERVICE_NAME = "networkflowmonitor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "networkflowmonitor";

    /**
     * <p>
     * Create a monitor for specific network flows between local and remote resources, so that you can monitor network
     * performance for one or several of your workloads. For each monitor, Network Flow Monitor publishes detailed
     * end-to-end performance metrics and a network health indicator (NHI) that informs you whether there were Amazon
     * Web Services network issues for one or more of the network flows tracked by a monitor, during a time period that
     * you choose.
     * </p>
     *
     * @param createMonitorRequest
     * @return Result of the CreateMonitor operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/CreateMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMonitorResponse createMonitor(CreateMonitorRequest createMonitorRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a monitor for specific network flows between local and remote resources, so that you can monitor network
     * performance for one or several of your workloads. For each monitor, Network Flow Monitor publishes detailed
     * end-to-end performance metrics and a network health indicator (NHI) that informs you whether there were Amazon
     * Web Services network issues for one or more of the network flows tracked by a monitor, during a time period that
     * you choose.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMonitorRequest#builder()}
     * </p>
     *
     * @param createMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.CreateMonitorRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMonitor operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/CreateMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMonitorResponse createMonitor(Consumer<CreateMonitorRequest.Builder> createMonitorRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return createMonitor(CreateMonitorRequest.builder().applyMutation(createMonitorRequest).build());
    }

    /**
     * <p>
     * In Network Flow Monitor, you specify a scope for the service to generate metrics for. By using the scope, Network
     * Flow Monitor can generate a topology of all the resources to measure performance metrics for. When you create a
     * scope, you enable permissions for Network Flow Monitor.
     * </p>
     * <p>
     * A scope is a Region-account pair or multiple Region-account pairs. Network Flow Monitor uses your scope to
     * determine all the resources (the topology) where Network Flow Monitor will gather network flow performance
     * metrics for you. To provide performance metrics, Network Flow Monitor uses the data that is sent by the Network
     * Flow Monitor agents you install on the resources.
     * </p>
     * <p>
     * To define the Region-account pairs for your scope, the Network Flow Monitor API uses the following constucts,
     * which allow for future flexibility in defining scopes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Targets</i>, which are arrays of targetResources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Target resources</i>, which are Region-targetIdentifier pairs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Target identifiers</i>, made up of a targetID (currently always an account ID) and a targetType (currently
     * always an account).
     * </p>
     * </li>
     * </ul>
     *
     * @param createScopeRequest
     * @return Result of the CreateScope operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.CreateScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/CreateScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateScopeResponse createScope(CreateScopeRequest createScopeRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In Network Flow Monitor, you specify a scope for the service to generate metrics for. By using the scope, Network
     * Flow Monitor can generate a topology of all the resources to measure performance metrics for. When you create a
     * scope, you enable permissions for Network Flow Monitor.
     * </p>
     * <p>
     * A scope is a Region-account pair or multiple Region-account pairs. Network Flow Monitor uses your scope to
     * determine all the resources (the topology) where Network Flow Monitor will gather network flow performance
     * metrics for you. To provide performance metrics, Network Flow Monitor uses the data that is sent by the Network
     * Flow Monitor agents you install on the resources.
     * </p>
     * <p>
     * To define the Region-account pairs for your scope, the Network Flow Monitor API uses the following constucts,
     * which allow for future flexibility in defining scopes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Targets</i>, which are arrays of targetResources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Target resources</i>, which are Region-targetIdentifier pairs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Target identifiers</i>, made up of a targetID (currently always an account ID) and a targetType (currently
     * always an account).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScopeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScopeRequest#builder()}
     * </p>
     *
     * @param createScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.CreateScopeRequest.Builder} to create a
     *        request.
     * @return Result of the CreateScope operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.CreateScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/CreateScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateScopeResponse createScope(Consumer<CreateScopeRequest.Builder> createScopeRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return createScope(CreateScopeRequest.builder().applyMutation(createScopeRequest).build());
    }

    /**
     * <p>
     * Deletes a monitor in Network Flow Monitor.
     * </p>
     *
     * @param deleteMonitorRequest
     * @return Result of the DeleteMonitor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/DeleteMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMonitorResponse deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a monitor in Network Flow Monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMonitorRequest#builder()}
     * </p>
     *
     * @param deleteMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.DeleteMonitorRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMonitor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/DeleteMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMonitorResponse deleteMonitor(Consumer<DeleteMonitorRequest.Builder> deleteMonitorRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return deleteMonitor(DeleteMonitorRequest.builder().applyMutation(deleteMonitorRequest).build());
    }

    /**
     * <p>
     * Deletes a scope that has been defined.
     * </p>
     *
     * @param deleteScopeRequest
     * @return Result of the DeleteScope operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.DeleteScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/DeleteScope"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteScopeResponse deleteScope(DeleteScopeRequest deleteScopeRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ConflictException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a scope that has been defined.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScopeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScopeRequest#builder()}
     * </p>
     *
     * @param deleteScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.DeleteScopeRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteScope operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.DeleteScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/DeleteScope"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteScopeResponse deleteScope(Consumer<DeleteScopeRequest.Builder> deleteScopeRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ConflictException, ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkFlowMonitorException {
        return deleteScope(DeleteScopeRequest.builder().applyMutation(deleteScopeRequest).build());
    }

    /**
     * <p>
     * Gets information about a monitor in Network Flow Monitor based on a monitor name. The information returned
     * includes the Amazon Resource Name (ARN), create time, modified time, resources included in the monitor, and
     * status information.
     * </p>
     *
     * @param getMonitorRequest
     * @return Result of the GetMonitor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetMonitor" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMonitorResponse getMonitor(GetMonitorRequest getMonitorRequest) throws ResourceNotFoundException,
            ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a monitor in Network Flow Monitor based on a monitor name. The information returned
     * includes the Amazon Resource Name (ARN), create time, modified time, resources included in the monitor, and
     * status information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link GetMonitorRequest#builder()}
     * </p>
     *
     * @param getMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetMonitorRequest.Builder} to create a
     *        request.
     * @return Result of the GetMonitor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetMonitor" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMonitorResponse getMonitor(Consumer<GetMonitorRequest.Builder> getMonitorRequest)
            throws ResourceNotFoundException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getMonitor(GetMonitorRequest.builder().applyMutation(getMonitorRequest).build());
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. You specify the query that you want to
     * return results for by providing a query ID and a monitor name. This query returns the top contributors for a
     * specific monitor.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryMonitorTopContributors</code>. Use the scope ID that was returned for your account by
     * <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param getQueryResultsMonitorTopContributorsRequest
     * @return Result of the GetQueryResultsMonitorTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsMonitorTopContributorsResponse getQueryResultsMonitorTopContributors(
            GetQueryResultsMonitorTopContributorsRequest getQueryResultsMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. You specify the query that you want to
     * return results for by providing a query ID and a monitor name. This query returns the top contributors for a
     * specific monitor.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryMonitorTopContributors</code>. Use the scope ID that was returned for your account by
     * <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsMonitorTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link GetQueryResultsMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return Result of the GetQueryResultsMonitorTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsMonitorTopContributorsResponse getQueryResultsMonitorTopContributors(
            Consumer<GetQueryResultsMonitorTopContributorsRequest.Builder> getQueryResultsMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryResultsMonitorTopContributors(GetQueryResultsMonitorTopContributorsRequest.builder()
                .applyMutation(getQueryResultsMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsMonitorTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsIterable responses = client.getQueryResultsMonitorTopContributorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsIterable responses = client
     *             .getQueryResultsMonitorTopContributorsPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsIterable responses = client.getQueryResultsMonitorTopContributorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsMonitorTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getQueryResultsMonitorTopContributorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsMonitorTopContributorsIterable getQueryResultsMonitorTopContributorsPaginator(
            GetQueryResultsMonitorTopContributorsRequest getQueryResultsMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return new GetQueryResultsMonitorTopContributorsIterable(this, getQueryResultsMonitorTopContributorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsMonitorTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsIterable responses = client.getQueryResultsMonitorTopContributorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsIterable responses = client
     *             .getQueryResultsMonitorTopContributorsPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsIterable responses = client.getQueryResultsMonitorTopContributorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsMonitorTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsMonitorTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link GetQueryResultsMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsMonitorTopContributorsIterable getQueryResultsMonitorTopContributorsPaginator(
            Consumer<GetQueryResultsMonitorTopContributorsRequest.Builder> getQueryResultsMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryResultsMonitorTopContributorsPaginator(GetQueryResultsMonitorTopContributorsRequest.builder()
                .applyMutation(getQueryResultsMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. You specify the query that you want to
     * return results for by providing a query ID and a monitor name.
     * </p>
     * <p>
     * This query returns the top contributors for a scope for workload insights. Workload insights provide a high level
     * view of network flow performance data collected by agents. To return the data for the top contributors, see
     * <code>GetQueryResultsWorkloadInsightsTopContributorsData</code>.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryWorkloadInsightsTopContributors</code>. Use the scope ID that was returned for your account by
     * <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsRequest
     * @return Result of the GetQueryResultsWorkloadInsightsTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsResponse getQueryResultsWorkloadInsightsTopContributors(
            GetQueryResultsWorkloadInsightsTopContributorsRequest getQueryResultsWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. You specify the query that you want to
     * return results for by providing a query ID and a monitor name.
     * </p>
     * <p>
     * This query returns the top contributors for a scope for workload insights. Workload insights provide a high level
     * view of network flow performance data collected by agents. To return the data for the top contributors, see
     * <code>GetQueryResultsWorkloadInsightsTopContributorsData</code>.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryWorkloadInsightsTopContributors</code>. Use the scope ID that was returned for your account by
     * <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually
     * via {@link GetQueryResultsWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return Result of the GetQueryResultsWorkloadInsightsTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsResponse getQueryResultsWorkloadInsightsTopContributors(
            Consumer<GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder> getQueryResultsWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryResultsWorkloadInsightsTopContributors(GetQueryResultsWorkloadInsightsTopContributorsRequest.builder()
                .applyMutation(getQueryResultsWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsWorkloadInsightsTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsIterable responses = client.getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsIterable responses = client
     *             .getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsIterable responses = client.getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsWorkloadInsightsTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsIterable getQueryResultsWorkloadInsightsTopContributorsPaginator(
            GetQueryResultsWorkloadInsightsTopContributorsRequest getQueryResultsWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return new GetQueryResultsWorkloadInsightsTopContributorsIterable(this,
                getQueryResultsWorkloadInsightsTopContributorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsWorkloadInsightsTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsIterable responses = client.getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsIterable responses = client
     *             .getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsIterable responses = client.getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsWorkloadInsightsTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually
     * via {@link GetQueryResultsWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsIterable getQueryResultsWorkloadInsightsTopContributorsPaginator(
            Consumer<GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder> getQueryResultsWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryResultsWorkloadInsightsTopContributorsPaginator(GetQueryResultsWorkloadInsightsTopContributorsRequest
                .builder().applyMutation(getQueryResultsWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. Specify the query that you want to
     * return results for by providing a query ID and a scope ID.
     * </p>
     * <p>
     * This query returns the data for top contributors for workload insights for a specific scope. Workload insights
     * provide a high level view of network flow performance data collected by agents for a scope. To return just the
     * top contributors, see <code>GetQueryResultsWorkloadInsightsTopContributors</code>.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryWorkloadInsightsTopContributorsData</code>. Use the scope ID that was returned for your account
     * by <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <p>
     * The top contributor network flows overall are for a specific metric type, for example, the number of
     * retransmissions.
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsDataRequest
     * @return Result of the GetQueryResultsWorkloadInsightsTopContributorsData operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsDataResponse getQueryResultsWorkloadInsightsTopContributorsData(
            GetQueryResultsWorkloadInsightsTopContributorsDataRequest getQueryResultsWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. Specify the query that you want to
     * return results for by providing a query ID and a scope ID.
     * </p>
     * <p>
     * This query returns the data for top contributors for workload insights for a specific scope. Workload insights
     * provide a high level view of network flow performance data collected by agents for a scope. To return just the
     * top contributors, see <code>GetQueryResultsWorkloadInsightsTopContributors</code>.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryWorkloadInsightsTopContributorsData</code>. Use the scope ID that was returned for your account
     * by <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <p>
     * The top contributor network flows overall are for a specific metric type, for example, the number of
     * retransmissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one
     * manually via {@link GetQueryResultsWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return Result of the GetQueryResultsWorkloadInsightsTopContributorsData operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsDataResponse getQueryResultsWorkloadInsightsTopContributorsData(
            Consumer<GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder> getQueryResultsWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryResultsWorkloadInsightsTopContributorsData(GetQueryResultsWorkloadInsightsTopContributorsDataRequest
                .builder().applyMutation(getQueryResultsWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsWorkloadInsightsTopContributorsData(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataIterable responses = client.getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataIterable responses = client
     *             .getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataIterable responses = client.getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsWorkloadInsightsTopContributorsData(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsDataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsDataIterable getQueryResultsWorkloadInsightsTopContributorsDataPaginator(
            GetQueryResultsWorkloadInsightsTopContributorsDataRequest getQueryResultsWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return new GetQueryResultsWorkloadInsightsTopContributorsDataIterable(this,
                getQueryResultsWorkloadInsightsTopContributorsDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsWorkloadInsightsTopContributorsData(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataIterable responses = client.getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataIterable responses = client
     *             .getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataIterable responses = client.getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsWorkloadInsightsTopContributorsData(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one
     * manually via {@link GetQueryResultsWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryResultsWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsDataIterable getQueryResultsWorkloadInsightsTopContributorsDataPaginator(
            Consumer<GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder> getQueryResultsWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryResultsWorkloadInsightsTopContributorsDataPaginator(GetQueryResultsWorkloadInsightsTopContributorsDataRequest
                .builder().applyMutation(getQueryResultsWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * Returns the current status of a query for the Network Flow Monitor query interface, for a specified query ID and
     * monitor. This call returns the query status for the top contributors for a monitor.
     * </p>
     * <p>
     * When you create a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start (create) the query, <code>StartQueryMonitorTopContributors</code>.
     * </p>
     * <p>
     * When you run a query, use this call to check the status of the query to make sure that the query has
     * <code>SUCCEEDED</code> before you review the results.
     * </p>
     *
     * @param getQueryStatusMonitorTopContributorsRequest
     * @return Result of the GetQueryStatusMonitorTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryStatusMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryStatusMonitorTopContributorsResponse getQueryStatusMonitorTopContributors(
            GetQueryStatusMonitorTopContributorsRequest getQueryStatusMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of a query for the Network Flow Monitor query interface, for a specified query ID and
     * monitor. This call returns the query status for the top contributors for a monitor.
     * </p>
     * <p>
     * When you create a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start (create) the query, <code>StartQueryMonitorTopContributors</code>.
     * </p>
     * <p>
     * When you run a query, use this call to check the status of the query to make sure that the query has
     * <code>SUCCEEDED</code> before you review the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryStatusMonitorTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link GetQueryStatusMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryStatusMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return Result of the GetQueryStatusMonitorTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryStatusMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryStatusMonitorTopContributorsResponse getQueryStatusMonitorTopContributors(
            Consumer<GetQueryStatusMonitorTopContributorsRequest.Builder> getQueryStatusMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryStatusMonitorTopContributors(GetQueryStatusMonitorTopContributorsRequest.builder()
                .applyMutation(getQueryStatusMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. Specify the query that you want to
     * return results for by providing a query ID and a monitor name. This query returns the top contributors for
     * workload insights.
     * </p>
     * <p>
     * When you start a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start the query, <code>StartQueryWorkloadInsightsTopContributors</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param getQueryStatusWorkloadInsightsTopContributorsRequest
     * @return Result of the GetQueryStatusWorkloadInsightsTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryStatusWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryStatusWorkloadInsightsTopContributorsResponse getQueryStatusWorkloadInsightsTopContributors(
            GetQueryStatusWorkloadInsightsTopContributorsRequest getQueryStatusWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. Specify the query that you want to
     * return results for by providing a query ID and a monitor name. This query returns the top contributors for
     * workload insights.
     * </p>
     * <p>
     * When you start a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start the query, <code>StartQueryWorkloadInsightsTopContributors</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryStatusWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link GetQueryStatusWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryStatusWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return Result of the GetQueryStatusWorkloadInsightsTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryStatusWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryStatusWorkloadInsightsTopContributorsResponse getQueryStatusWorkloadInsightsTopContributors(
            Consumer<GetQueryStatusWorkloadInsightsTopContributorsRequest.Builder> getQueryStatusWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryStatusWorkloadInsightsTopContributors(GetQueryStatusWorkloadInsightsTopContributorsRequest.builder()
                .applyMutation(getQueryStatusWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Returns the current status of a query for the Network Flow Monitor query interface, for a specified query ID and
     * monitor. This call returns the query status for the top contributors data for workload insights.
     * </p>
     * <p>
     * When you start a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start the query, <code>StartQueryWorkloadInsightsTopContributorsData</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <p>
     * The top contributor network flows overall are for a specific metric type, for example, the number of
     * retransmissions.
     * </p>
     *
     * @param getQueryStatusWorkloadInsightsTopContributorsDataRequest
     * @return Result of the GetQueryStatusWorkloadInsightsTopContributorsData operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryStatusWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryStatusWorkloadInsightsTopContributorsDataResponse getQueryStatusWorkloadInsightsTopContributorsData(
            GetQueryStatusWorkloadInsightsTopContributorsDataRequest getQueryStatusWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of a query for the Network Flow Monitor query interface, for a specified query ID and
     * monitor. This call returns the query status for the top contributors data for workload insights.
     * </p>
     * <p>
     * When you start a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start the query, <code>StartQueryWorkloadInsightsTopContributorsData</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <p>
     * The top contributor network flows overall are for a specific metric type, for example, the number of
     * retransmissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryStatusWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one manually
     * via {@link GetQueryStatusWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param getQueryStatusWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return Result of the GetQueryStatusWorkloadInsightsTopContributorsData operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetQueryStatusWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryStatusWorkloadInsightsTopContributorsDataResponse getQueryStatusWorkloadInsightsTopContributorsData(
            Consumer<GetQueryStatusWorkloadInsightsTopContributorsDataRequest.Builder> getQueryStatusWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getQueryStatusWorkloadInsightsTopContributorsData(GetQueryStatusWorkloadInsightsTopContributorsDataRequest
                .builder().applyMutation(getQueryStatusWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * Gets information about a scope, including the name, status, tags, and target details. The scope in Network Flow
     * Monitor is an account.
     * </p>
     *
     * @param getScopeRequest
     * @return Result of the GetScope operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetScope" target="_top">AWS
     *      API Documentation</a>
     */
    default GetScopeResponse getScope(GetScopeRequest getScopeRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a scope, including the name, status, tags, and target details. The scope in Network Flow
     * Monitor is an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScopeRequest.Builder} avoiding the need to
     * create one manually via {@link GetScopeRequest#builder()}
     * </p>
     *
     * @param getScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetScopeRequest.Builder} to create a
     *        request.
     * @return Result of the GetScope operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.GetScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetScope" target="_top">AWS
     *      API Documentation</a>
     */
    default GetScopeResponse getScope(Consumer<GetScopeRequest.Builder> getScopeRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return getScope(GetScopeRequest.builder().applyMutation(getScopeRequest).build());
    }

    /**
     * <p>
     * List all monitors in an account. Optionally, you can list only monitors that have a specific status, by using the
     * <code>STATUS</code> parameter.
     * </p>
     *
     * @param listMonitorsRequest
     * @return Result of the ListMonitors operation returned by the service.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListMonitors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorsResponse listMonitors(ListMonitorsRequest listMonitorsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all monitors in an account. Optionally, you can list only monitors that have a specific status, by using the
     * <code>STATUS</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMonitors operation returned by the service.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListMonitors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorsResponse listMonitors(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkFlowMonitorException {
        return listMonitors(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMonitors(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsIterable responses = client
     *             .listMonitorsPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListMonitors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorsIterable listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkFlowMonitorException {
        return new ListMonitorsIterable(this, listMonitorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMonitors(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsIterable responses = client
     *             .listMonitorsPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListMonitors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorsIterable listMonitorsPaginator(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkFlowMonitorException {
        return listMonitorsPaginator(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * List all the scopes for an account.
     * </p>
     *
     * @param listScopesRequest
     * @return Result of the ListScopes operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListScopes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScopesResponse listScopes(ListScopesRequest listScopesRequest) throws ServiceQuotaExceededException,
            ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the scopes for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScopesRequest.Builder} avoiding the need to
     * create one manually via {@link ListScopesRequest#builder()}
     * </p>
     *
     * @param listScopesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest.Builder} to create a
     *        request.
     * @return Result of the ListScopes operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListScopes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScopesResponse listScopes(Consumer<ListScopesRequest.Builder> listScopesRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return listScopes(ListScopesRequest.builder().applyMutation(listScopesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScopes(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesIterable responses = client.listScopesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesIterable responses = client
     *             .listScopesPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesIterable responses = client.listScopesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScopes(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest)} operation.</b>
     * </p>
     *
     * @param listScopesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListScopes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScopesIterable listScopesPaginator(ListScopesRequest listScopesRequest) throws ServiceQuotaExceededException,
            ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkFlowMonitorException {
        return new ListScopesIterable(this, listScopesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScopes(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesIterable responses = client.listScopesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesIterable responses = client
     *             .listScopesPaginator(request);
     *     for (software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesIterable responses = client.listScopesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScopes(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScopesRequest.Builder} avoiding the need to
     * create one manually via {@link ListScopesRequest#builder()}
     * </p>
     *
     * @param listScopesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListScopes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScopesIterable listScopesPaginator(Consumer<ListScopesRequest.Builder> listScopesRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return listScopesPaginator(ListScopesRequest.builder().applyMutation(listScopesRequest).build());
    }

    /**
     * <p>
     * Returns all the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Create a query that you can use with the Network Flow Monitor query interface to return the top contributors for
     * a monitor. Specify the monitor that you want to create the query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsMonitorTopContributors.html">
     * GetQueryResultsMonitorTopContributors</a> to run the query and return the top contributors for a specific
     * monitor.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable APIs for the top contributors that you want to be returned.
     * </p>
     *
     * @param startQueryMonitorTopContributorsRequest
     * @return Result of the StartQueryMonitorTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StartQueryMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default StartQueryMonitorTopContributorsResponse startQueryMonitorTopContributors(
            StartQueryMonitorTopContributorsRequest startQueryMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a query that you can use with the Network Flow Monitor query interface to return the top contributors for
     * a monitor. Specify the monitor that you want to create the query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsMonitorTopContributors.html">
     * GetQueryResultsMonitorTopContributors</a> to run the query and return the top contributors for a specific
     * monitor.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable APIs for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQueryMonitorTopContributorsRequest.Builder}
     * avoiding the need to create one manually via {@link StartQueryMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param startQueryMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StartQueryMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return Result of the StartQueryMonitorTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StartQueryMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default StartQueryMonitorTopContributorsResponse startQueryMonitorTopContributors(
            Consumer<StartQueryMonitorTopContributorsRequest.Builder> startQueryMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return startQueryMonitorTopContributors(StartQueryMonitorTopContributorsRequest.builder()
                .applyMutation(startQueryMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * Create a query with the Network Flow Monitor query interface that you can run to return workload insights top
     * contributors. Specify the scope that you want to create a query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributors.html"
     * > GetQueryResultsWorkloadInsightsTopContributors</a> to run the query and return the top contributors for the
     * workload insights for a scope.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable APIs for the top contributors that you want to be returned.
     * </p>
     *
     * @param startQueryWorkloadInsightsTopContributorsRequest
     * @return Result of the StartQueryWorkloadInsightsTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StartQueryWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default StartQueryWorkloadInsightsTopContributorsResponse startQueryWorkloadInsightsTopContributors(
            StartQueryWorkloadInsightsTopContributorsRequest startQueryWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a query with the Network Flow Monitor query interface that you can run to return workload insights top
     * contributors. Specify the scope that you want to create a query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributors.html"
     * > GetQueryResultsWorkloadInsightsTopContributors</a> to run the query and return the top contributors for the
     * workload insights for a scope.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable APIs for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartQueryWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link StartQueryWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param startQueryWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return Result of the StartQueryWorkloadInsightsTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StartQueryWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default StartQueryWorkloadInsightsTopContributorsResponse startQueryWorkloadInsightsTopContributors(
            Consumer<StartQueryWorkloadInsightsTopContributorsRequest.Builder> startQueryWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return startQueryWorkloadInsightsTopContributors(StartQueryWorkloadInsightsTopContributorsRequest.builder()
                .applyMutation(startQueryWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Create a query with the Network Flow Monitor query interface that you can run to return data for workload
     * insights top contributors. Specify the scope that you want to create a query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributorsData.html"
     * > GetQueryResultsWorkloadInsightsTopContributorsData</a> to run the query and return the data for the top
     * contributors for the workload insights for a scope.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param startQueryWorkloadInsightsTopContributorsDataRequest
     * @return Result of the StartQueryWorkloadInsightsTopContributorsData operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StartQueryWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default StartQueryWorkloadInsightsTopContributorsDataResponse startQueryWorkloadInsightsTopContributorsData(
            StartQueryWorkloadInsightsTopContributorsDataRequest startQueryWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a query with the Network Flow Monitor query interface that you can run to return data for workload
     * insights top contributors. Specify the scope that you want to create a query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributorsData.html"
     * > GetQueryResultsWorkloadInsightsTopContributorsData</a> to run the query and return the data for the top
     * contributors for the workload insights for a scope.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartQueryWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one manually via
     * {@link StartQueryWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param startQueryWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return Result of the StartQueryWorkloadInsightsTopContributorsData operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StartQueryWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default StartQueryWorkloadInsightsTopContributorsDataResponse startQueryWorkloadInsightsTopContributorsData(
            Consumer<StartQueryWorkloadInsightsTopContributorsDataRequest.Builder> startQueryWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return startQueryWorkloadInsightsTopContributorsData(StartQueryWorkloadInsightsTopContributorsDataRequest.builder()
                .applyMutation(startQueryWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * Stop a top contributors query for a monitor. Specify the query that you want to stop by providing a query ID and
     * a monitor name.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param stopQueryMonitorTopContributorsRequest
     * @return Result of the StopQueryMonitorTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StopQueryMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default StopQueryMonitorTopContributorsResponse stopQueryMonitorTopContributors(
            StopQueryMonitorTopContributorsRequest stopQueryMonitorTopContributorsRequest) throws ServiceQuotaExceededException,
            ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop a top contributors query for a monitor. Specify the query that you want to stop by providing a query ID and
     * a monitor name.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopQueryMonitorTopContributorsRequest.Builder}
     * avoiding the need to create one manually via {@link StopQueryMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param stopQueryMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StopQueryMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return Result of the StopQueryMonitorTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StopQueryMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default StopQueryMonitorTopContributorsResponse stopQueryMonitorTopContributors(
            Consumer<StopQueryMonitorTopContributorsRequest.Builder> stopQueryMonitorTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return stopQueryMonitorTopContributors(StopQueryMonitorTopContributorsRequest.builder()
                .applyMutation(stopQueryMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * Stop a top contributors query for workload insights. Specify the query that you want to stop by providing a query
     * ID and a scope ID.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param stopQueryWorkloadInsightsTopContributorsRequest
     * @return Result of the StopQueryWorkloadInsightsTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StopQueryWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default StopQueryWorkloadInsightsTopContributorsResponse stopQueryWorkloadInsightsTopContributors(
            StopQueryWorkloadInsightsTopContributorsRequest stopQueryWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop a top contributors query for workload insights. Specify the query that you want to stop by providing a query
     * ID and a scope ID.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StopQueryWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link StopQueryWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param stopQueryWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return Result of the StopQueryWorkloadInsightsTopContributors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StopQueryWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default StopQueryWorkloadInsightsTopContributorsResponse stopQueryWorkloadInsightsTopContributors(
            Consumer<StopQueryWorkloadInsightsTopContributorsRequest.Builder> stopQueryWorkloadInsightsTopContributorsRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return stopQueryWorkloadInsightsTopContributors(StopQueryWorkloadInsightsTopContributorsRequest.builder()
                .applyMutation(stopQueryWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Stop a top contributors data query for workload insights. Specify the query that you want to stop by providing a
     * query ID and a scope ID.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param stopQueryWorkloadInsightsTopContributorsDataRequest
     * @return Result of the StopQueryWorkloadInsightsTopContributorsData operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StopQueryWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default StopQueryWorkloadInsightsTopContributorsDataResponse stopQueryWorkloadInsightsTopContributorsData(
            StopQueryWorkloadInsightsTopContributorsDataRequest stopQueryWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop a top contributors data query for workload insights. Specify the query that you want to stop by providing a
     * query ID and a scope ID.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StopQueryWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one manually via
     * {@link StopQueryWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param stopQueryWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return Result of the StopQueryWorkloadInsightsTopContributorsData operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.StopQueryWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default StopQueryWorkloadInsightsTopContributorsDataResponse stopQueryWorkloadInsightsTopContributorsData(
            Consumer<StopQueryWorkloadInsightsTopContributorsDataRequest.Builder> stopQueryWorkloadInsightsTopContributorsDataRequest)
            throws ServiceQuotaExceededException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return stopQueryWorkloadInsightsTopContributorsData(StopQueryWorkloadInsightsTopContributorsDataRequest.builder()
                .applyMutation(stopQueryWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update a monitor to add or remove local or remote resources.
     * </p>
     *
     * @param updateMonitorRequest
     * @return Result of the UpdateMonitor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UpdateMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMonitorResponse updateMonitor(UpdateMonitorRequest updateMonitorRequest) throws ResourceNotFoundException,
            ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a monitor to add or remove local or remote resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMonitorRequest#builder()}
     * </p>
     *
     * @param updateMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.UpdateMonitorRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMonitor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UpdateMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMonitorResponse updateMonitor(Consumer<UpdateMonitorRequest.Builder> updateMonitorRequest)
            throws ResourceNotFoundException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        return updateMonitor(UpdateMonitorRequest.builder().applyMutation(updateMonitorRequest).build());
    }

    /**
     * <p>
     * Update a scope to add or remove resources that you want to be available for Network Flow Monitor to generate
     * metrics for, when you have active agents on those resources sending metrics reports to the Network Flow Monitor
     * backend.
     * </p>
     *
     * @param updateScopeRequest
     * @return Result of the UpdateScope operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.UpdateScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UpdateScope"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateScopeResponse updateScope(UpdateScopeRequest updateScopeRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ConflictException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkFlowMonitorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a scope to add or remove resources that you want to be available for Network Flow Monitor to generate
     * metrics for, when you have active agents on those resources sending metrics reports to the Network Flow Monitor
     * backend.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScopeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateScopeRequest#builder()}
     * </p>
     *
     * @param updateScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.UpdateScopeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateScope operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request specifies a resource that doesn't exist.
     * @throws ConflictException
     *         The requested resource is in use.
     * @throws ValidationException
     *         Invalid request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFlowMonitorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFlowMonitorClient.UpdateScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UpdateScope"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateScopeResponse updateScope(Consumer<UpdateScopeRequest.Builder> updateScopeRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ConflictException, ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkFlowMonitorException {
        return updateScope(UpdateScopeRequest.builder().applyMutation(updateScopeRequest).build());
    }

    /**
     * Create a {@link NetworkFlowMonitorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NetworkFlowMonitorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NetworkFlowMonitorClient}.
     */
    static NetworkFlowMonitorClientBuilder builder() {
        return new DefaultNetworkFlowMonitorClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default NetworkFlowMonitorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
