/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitorLocalResourceType {
    AWS_EC2_VPC("AWS::EC2::VPC"),
    AWS_AVAILABILITY_ZONE("AWS::AvailabilityZone"),
    AWS_EC2_SUBNET("AWS::EC2::Subnet"),
    AWS_REGION("AWS::Region"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitorLocalResourceType> VALUE_MAP;
    private final String value;

    private MonitorLocalResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorLocalResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorLocalResourceType> knownValues() {
        EnumSet<MonitorLocalResourceType> knownValues = EnumSet.allOf(MonitorLocalResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitorLocalResourceType.class, MonitorLocalResourceType::toString);
    }
}

