/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkflowmonitor.NetworkFlowMonitorAsyncClient;
import software.amazon.awssdk.services.networkflowmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsRow;

public class GetQueryResultsWorkloadInsightsTopContributorsPublisher
implements SdkPublisher<GetQueryResultsWorkloadInsightsTopContributorsResponse> {
    private final NetworkFlowMonitorAsyncClient client;
    private final GetQueryResultsWorkloadInsightsTopContributorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetQueryResultsWorkloadInsightsTopContributorsPublisher(NetworkFlowMonitorAsyncClient client, GetQueryResultsWorkloadInsightsTopContributorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetQueryResultsWorkloadInsightsTopContributorsPublisher(NetworkFlowMonitorAsyncClient client, GetQueryResultsWorkloadInsightsTopContributorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetQueryResultsWorkloadInsightsTopContributorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetQueryResultsWorkloadInsightsTopContributorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkloadInsightsTopContributorsRow> topContributors() {
        Function<GetQueryResultsWorkloadInsightsTopContributorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topContributors() != null) {
                return response.topContributors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetQueryResultsWorkloadInsightsTopContributorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetQueryResultsWorkloadInsightsTopContributorsResponseFetcher
    implements AsyncPageFetcher<GetQueryResultsWorkloadInsightsTopContributorsResponse> {
        private GetQueryResultsWorkloadInsightsTopContributorsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsWorkloadInsightsTopContributorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetQueryResultsWorkloadInsightsTopContributorsResponse> nextPage(GetQueryResultsWorkloadInsightsTopContributorsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsWorkloadInsightsTopContributorsPublisher.this.client.getQueryResultsWorkloadInsightsTopContributors(GetQueryResultsWorkloadInsightsTopContributorsPublisher.this.firstRequest);
            }
            return GetQueryResultsWorkloadInsightsTopContributorsPublisher.this.client.getQueryResultsWorkloadInsightsTopContributors((GetQueryResultsWorkloadInsightsTopContributorsRequest)((Object)GetQueryResultsWorkloadInsightsTopContributorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

