/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkloadInsightsMetric {
    TIMEOUTS("TIMEOUTS"),
    RETRANSMISSIONS("RETRANSMISSIONS"),
    DATA_TRANSFERRED("DATA_TRANSFERRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkloadInsightsMetric> VALUE_MAP;
    private final String value;

    private WorkloadInsightsMetric(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkloadInsightsMetric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkloadInsightsMetric> knownValues() {
        EnumSet<WorkloadInsightsMetric> knownValues = EnumSet.allOf(WorkloadInsightsMetric.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkloadInsightsMetric.class, WorkloadInsightsMetric::toString);
    }
}

