/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkflowmonitor.model.DestinationCategory;
import software.amazon.awssdk.services.networkflowmonitor.model.KubernetesMetadata;
import software.amazon.awssdk.services.networkflowmonitor.model.TraversedComponent;
import software.amazon.awssdk.services.networkflowmonitor.model.TraversedConstructsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitorTopContributorsRow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitorTopContributorsRow> {
    private static final SdkField<String> LOCAL_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localIp").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localIp)).setter(MonitorTopContributorsRow.setter(Builder::localIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localIp").build()}).build();
    private static final SdkField<String> SNAT_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snatIp").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::snatIp)).setter(MonitorTopContributorsRow.setter(Builder::snatIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snatIp").build()}).build();
    private static final SdkField<String> LOCAL_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localInstanceId").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localInstanceId)).setter(MonitorTopContributorsRow.setter(Builder::localInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localInstanceId").build()}).build();
    private static final SdkField<String> LOCAL_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localVpcId").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localVpcId)).setter(MonitorTopContributorsRow.setter(Builder::localVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localVpcId").build()}).build();
    private static final SdkField<String> LOCAL_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localRegion").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localRegion)).setter(MonitorTopContributorsRow.setter(Builder::localRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localRegion").build()}).build();
    private static final SdkField<String> LOCAL_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localAz").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localAz)).setter(MonitorTopContributorsRow.setter(Builder::localAz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localAz").build()}).build();
    private static final SdkField<String> LOCAL_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localSubnetId").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localSubnetId)).setter(MonitorTopContributorsRow.setter(Builder::localSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localSubnetId").build()}).build();
    private static final SdkField<Integer> TARGET_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetPort").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::targetPort)).setter(MonitorTopContributorsRow.setter(Builder::targetPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPort").build()}).build();
    private static final SdkField<String> DESTINATION_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCategory").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::destinationCategoryAsString)).setter(MonitorTopContributorsRow.setter(Builder::destinationCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCategory").build()}).build();
    private static final SdkField<String> REMOTE_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteVpcId").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteVpcId)).setter(MonitorTopContributorsRow.setter(Builder::remoteVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteVpcId").build()}).build();
    private static final SdkField<String> REMOTE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteRegion").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteRegion)).setter(MonitorTopContributorsRow.setter(Builder::remoteRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteRegion").build()}).build();
    private static final SdkField<String> REMOTE_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteAz").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteAz)).setter(MonitorTopContributorsRow.setter(Builder::remoteAz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAz").build()}).build();
    private static final SdkField<String> REMOTE_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteSubnetId").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteSubnetId)).setter(MonitorTopContributorsRow.setter(Builder::remoteSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteSubnetId").build()}).build();
    private static final SdkField<String> REMOTE_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteInstanceId").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteInstanceId)).setter(MonitorTopContributorsRow.setter(Builder::remoteInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteInstanceId").build()}).build();
    private static final SdkField<String> REMOTE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteIp").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteIp)).setter(MonitorTopContributorsRow.setter(Builder::remoteIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIp").build()}).build();
    private static final SdkField<String> DNAT_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnatIp").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::dnatIp)).setter(MonitorTopContributorsRow.setter(Builder::dnatIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnatIp").build()}).build();
    private static final SdkField<Long> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("value").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::value)).setter(MonitorTopContributorsRow.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<List<TraversedComponent>> TRAVERSED_CONSTRUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("traversedConstructs").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::traversedConstructs)).setter(MonitorTopContributorsRow.setter(Builder::traversedConstructs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traversedConstructs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TraversedComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KubernetesMetadata> KUBERNETES_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kubernetesMetadata").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::kubernetesMetadata)).setter(MonitorTopContributorsRow.setter(Builder::kubernetesMetadata)).constructor(KubernetesMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesMetadata").build()}).build();
    private static final SdkField<String> LOCAL_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localInstanceArn").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localInstanceArn)).setter(MonitorTopContributorsRow.setter(Builder::localInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localInstanceArn").build()}).build();
    private static final SdkField<String> LOCAL_SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localSubnetArn").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localSubnetArn)).setter(MonitorTopContributorsRow.setter(Builder::localSubnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localSubnetArn").build()}).build();
    private static final SdkField<String> LOCAL_VPC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localVpcArn").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::localVpcArn)).setter(MonitorTopContributorsRow.setter(Builder::localVpcArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localVpcArn").build()}).build();
    private static final SdkField<String> REMOTE_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteInstanceArn").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteInstanceArn)).setter(MonitorTopContributorsRow.setter(Builder::remoteInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteInstanceArn").build()}).build();
    private static final SdkField<String> REMOTE_SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteSubnetArn").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteSubnetArn)).setter(MonitorTopContributorsRow.setter(Builder::remoteSubnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteSubnetArn").build()}).build();
    private static final SdkField<String> REMOTE_VPC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteVpcArn").getter(MonitorTopContributorsRow.getter(MonitorTopContributorsRow::remoteVpcArn)).setter(MonitorTopContributorsRow.setter(Builder::remoteVpcArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteVpcArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_IP_FIELD, SNAT_IP_FIELD, LOCAL_INSTANCE_ID_FIELD, LOCAL_VPC_ID_FIELD, LOCAL_REGION_FIELD, LOCAL_AZ_FIELD, LOCAL_SUBNET_ID_FIELD, TARGET_PORT_FIELD, DESTINATION_CATEGORY_FIELD, REMOTE_VPC_ID_FIELD, REMOTE_REGION_FIELD, REMOTE_AZ_FIELD, REMOTE_SUBNET_ID_FIELD, REMOTE_INSTANCE_ID_FIELD, REMOTE_IP_FIELD, DNAT_IP_FIELD, VALUE_FIELD, TRAVERSED_CONSTRUCTS_FIELD, KUBERNETES_METADATA_FIELD, LOCAL_INSTANCE_ARN_FIELD, LOCAL_SUBNET_ARN_FIELD, LOCAL_VPC_ARN_FIELD, REMOTE_INSTANCE_ARN_FIELD, REMOTE_SUBNET_ARN_FIELD, REMOTE_VPC_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitorTopContributorsRow.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String localIp;
    private final String snatIp;
    private final String localInstanceId;
    private final String localVpcId;
    private final String localRegion;
    private final String localAz;
    private final String localSubnetId;
    private final Integer targetPort;
    private final String destinationCategory;
    private final String remoteVpcId;
    private final String remoteRegion;
    private final String remoteAz;
    private final String remoteSubnetId;
    private final String remoteInstanceId;
    private final String remoteIp;
    private final String dnatIp;
    private final Long value;
    private final List<TraversedComponent> traversedConstructs;
    private final KubernetesMetadata kubernetesMetadata;
    private final String localInstanceArn;
    private final String localSubnetArn;
    private final String localVpcArn;
    private final String remoteInstanceArn;
    private final String remoteSubnetArn;
    private final String remoteVpcArn;

    private MonitorTopContributorsRow(BuilderImpl builder) {
        this.localIp = builder.localIp;
        this.snatIp = builder.snatIp;
        this.localInstanceId = builder.localInstanceId;
        this.localVpcId = builder.localVpcId;
        this.localRegion = builder.localRegion;
        this.localAz = builder.localAz;
        this.localSubnetId = builder.localSubnetId;
        this.targetPort = builder.targetPort;
        this.destinationCategory = builder.destinationCategory;
        this.remoteVpcId = builder.remoteVpcId;
        this.remoteRegion = builder.remoteRegion;
        this.remoteAz = builder.remoteAz;
        this.remoteSubnetId = builder.remoteSubnetId;
        this.remoteInstanceId = builder.remoteInstanceId;
        this.remoteIp = builder.remoteIp;
        this.dnatIp = builder.dnatIp;
        this.value = builder.value;
        this.traversedConstructs = builder.traversedConstructs;
        this.kubernetesMetadata = builder.kubernetesMetadata;
        this.localInstanceArn = builder.localInstanceArn;
        this.localSubnetArn = builder.localSubnetArn;
        this.localVpcArn = builder.localVpcArn;
        this.remoteInstanceArn = builder.remoteInstanceArn;
        this.remoteSubnetArn = builder.remoteSubnetArn;
        this.remoteVpcArn = builder.remoteVpcArn;
    }

    public final String localIp() {
        return this.localIp;
    }

    public final String snatIp() {
        return this.snatIp;
    }

    public final String localInstanceId() {
        return this.localInstanceId;
    }

    public final String localVpcId() {
        return this.localVpcId;
    }

    public final String localRegion() {
        return this.localRegion;
    }

    public final String localAz() {
        return this.localAz;
    }

    public final String localSubnetId() {
        return this.localSubnetId;
    }

    public final Integer targetPort() {
        return this.targetPort;
    }

    public final DestinationCategory destinationCategory() {
        return DestinationCategory.fromValue(this.destinationCategory);
    }

    public final String destinationCategoryAsString() {
        return this.destinationCategory;
    }

    public final String remoteVpcId() {
        return this.remoteVpcId;
    }

    public final String remoteRegion() {
        return this.remoteRegion;
    }

    public final String remoteAz() {
        return this.remoteAz;
    }

    public final String remoteSubnetId() {
        return this.remoteSubnetId;
    }

    public final String remoteInstanceId() {
        return this.remoteInstanceId;
    }

    public final String remoteIp() {
        return this.remoteIp;
    }

    public final String dnatIp() {
        return this.dnatIp;
    }

    public final Long value() {
        return this.value;
    }

    public final boolean hasTraversedConstructs() {
        return this.traversedConstructs != null && !(this.traversedConstructs instanceof SdkAutoConstructList);
    }

    public final List<TraversedComponent> traversedConstructs() {
        return this.traversedConstructs;
    }

    public final KubernetesMetadata kubernetesMetadata() {
        return this.kubernetesMetadata;
    }

    public final String localInstanceArn() {
        return this.localInstanceArn;
    }

    public final String localSubnetArn() {
        return this.localSubnetArn;
    }

    public final String localVpcArn() {
        return this.localVpcArn;
    }

    public final String remoteInstanceArn() {
        return this.remoteInstanceArn;
    }

    public final String remoteSubnetArn() {
        return this.remoteSubnetArn;
    }

    public final String remoteVpcArn() {
        return this.remoteVpcArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.snatIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.localInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localAz());
        hashCode = 31 * hashCode + Objects.hashCode(this.localSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAz());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnatIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraversedConstructs() ? this.traversedConstructs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.localInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.localSubnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.localVpcArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteSubnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteVpcArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorTopContributorsRow)) {
            return false;
        }
        MonitorTopContributorsRow other = (MonitorTopContributorsRow)obj;
        return Objects.equals(this.localIp(), other.localIp()) && Objects.equals(this.snatIp(), other.snatIp()) && Objects.equals(this.localInstanceId(), other.localInstanceId()) && Objects.equals(this.localVpcId(), other.localVpcId()) && Objects.equals(this.localRegion(), other.localRegion()) && Objects.equals(this.localAz(), other.localAz()) && Objects.equals(this.localSubnetId(), other.localSubnetId()) && Objects.equals(this.targetPort(), other.targetPort()) && Objects.equals(this.destinationCategoryAsString(), other.destinationCategoryAsString()) && Objects.equals(this.remoteVpcId(), other.remoteVpcId()) && Objects.equals(this.remoteRegion(), other.remoteRegion()) && Objects.equals(this.remoteAz(), other.remoteAz()) && Objects.equals(this.remoteSubnetId(), other.remoteSubnetId()) && Objects.equals(this.remoteInstanceId(), other.remoteInstanceId()) && Objects.equals(this.remoteIp(), other.remoteIp()) && Objects.equals(this.dnatIp(), other.dnatIp()) && Objects.equals(this.value(), other.value()) && this.hasTraversedConstructs() == other.hasTraversedConstructs() && Objects.equals(this.traversedConstructs(), other.traversedConstructs()) && Objects.equals(this.kubernetesMetadata(), other.kubernetesMetadata()) && Objects.equals(this.localInstanceArn(), other.localInstanceArn()) && Objects.equals(this.localSubnetArn(), other.localSubnetArn()) && Objects.equals(this.localVpcArn(), other.localVpcArn()) && Objects.equals(this.remoteInstanceArn(), other.remoteInstanceArn()) && Objects.equals(this.remoteSubnetArn(), other.remoteSubnetArn()) && Objects.equals(this.remoteVpcArn(), other.remoteVpcArn());
    }

    public final String toString() {
        return ToString.builder((String)"MonitorTopContributorsRow").add("LocalIp", (Object)this.localIp()).add("SnatIp", (Object)this.snatIp()).add("LocalInstanceId", (Object)this.localInstanceId()).add("LocalVpcId", (Object)this.localVpcId()).add("LocalRegion", (Object)this.localRegion()).add("LocalAz", (Object)this.localAz()).add("LocalSubnetId", (Object)this.localSubnetId()).add("TargetPort", (Object)this.targetPort()).add("DestinationCategory", (Object)this.destinationCategoryAsString()).add("RemoteVpcId", (Object)this.remoteVpcId()).add("RemoteRegion", (Object)this.remoteRegion()).add("RemoteAz", (Object)this.remoteAz()).add("RemoteSubnetId", (Object)this.remoteSubnetId()).add("RemoteInstanceId", (Object)this.remoteInstanceId()).add("RemoteIp", (Object)this.remoteIp()).add("DnatIp", (Object)this.dnatIp()).add("Value", (Object)this.value()).add("TraversedConstructs", this.hasTraversedConstructs() ? this.traversedConstructs() : null).add("KubernetesMetadata", (Object)this.kubernetesMetadata()).add("LocalInstanceArn", (Object)this.localInstanceArn()).add("LocalSubnetArn", (Object)this.localSubnetArn()).add("LocalVpcArn", (Object)this.localVpcArn()).add("RemoteInstanceArn", (Object)this.remoteInstanceArn()).add("RemoteSubnetArn", (Object)this.remoteSubnetArn()).add("RemoteVpcArn", (Object)this.remoteVpcArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "localIp": {
                return Optional.ofNullable(clazz.cast(this.localIp()));
            }
            case "snatIp": {
                return Optional.ofNullable(clazz.cast(this.snatIp()));
            }
            case "localInstanceId": {
                return Optional.ofNullable(clazz.cast(this.localInstanceId()));
            }
            case "localVpcId": {
                return Optional.ofNullable(clazz.cast(this.localVpcId()));
            }
            case "localRegion": {
                return Optional.ofNullable(clazz.cast(this.localRegion()));
            }
            case "localAz": {
                return Optional.ofNullable(clazz.cast(this.localAz()));
            }
            case "localSubnetId": {
                return Optional.ofNullable(clazz.cast(this.localSubnetId()));
            }
            case "targetPort": {
                return Optional.ofNullable(clazz.cast(this.targetPort()));
            }
            case "destinationCategory": {
                return Optional.ofNullable(clazz.cast(this.destinationCategoryAsString()));
            }
            case "remoteVpcId": {
                return Optional.ofNullable(clazz.cast(this.remoteVpcId()));
            }
            case "remoteRegion": {
                return Optional.ofNullable(clazz.cast(this.remoteRegion()));
            }
            case "remoteAz": {
                return Optional.ofNullable(clazz.cast(this.remoteAz()));
            }
            case "remoteSubnetId": {
                return Optional.ofNullable(clazz.cast(this.remoteSubnetId()));
            }
            case "remoteInstanceId": {
                return Optional.ofNullable(clazz.cast(this.remoteInstanceId()));
            }
            case "remoteIp": {
                return Optional.ofNullable(clazz.cast(this.remoteIp()));
            }
            case "dnatIp": {
                return Optional.ofNullable(clazz.cast(this.dnatIp()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "traversedConstructs": {
                return Optional.ofNullable(clazz.cast(this.traversedConstructs()));
            }
            case "kubernetesMetadata": {
                return Optional.ofNullable(clazz.cast(this.kubernetesMetadata()));
            }
            case "localInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.localInstanceArn()));
            }
            case "localSubnetArn": {
                return Optional.ofNullable(clazz.cast(this.localSubnetArn()));
            }
            case "localVpcArn": {
                return Optional.ofNullable(clazz.cast(this.localVpcArn()));
            }
            case "remoteInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.remoteInstanceArn()));
            }
            case "remoteSubnetArn": {
                return Optional.ofNullable(clazz.cast(this.remoteSubnetArn()));
            }
            case "remoteVpcArn": {
                return Optional.ofNullable(clazz.cast(this.remoteVpcArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("localIp", LOCAL_IP_FIELD);
        map.put("snatIp", SNAT_IP_FIELD);
        map.put("localInstanceId", LOCAL_INSTANCE_ID_FIELD);
        map.put("localVpcId", LOCAL_VPC_ID_FIELD);
        map.put("localRegion", LOCAL_REGION_FIELD);
        map.put("localAz", LOCAL_AZ_FIELD);
        map.put("localSubnetId", LOCAL_SUBNET_ID_FIELD);
        map.put("targetPort", TARGET_PORT_FIELD);
        map.put("destinationCategory", DESTINATION_CATEGORY_FIELD);
        map.put("remoteVpcId", REMOTE_VPC_ID_FIELD);
        map.put("remoteRegion", REMOTE_REGION_FIELD);
        map.put("remoteAz", REMOTE_AZ_FIELD);
        map.put("remoteSubnetId", REMOTE_SUBNET_ID_FIELD);
        map.put("remoteInstanceId", REMOTE_INSTANCE_ID_FIELD);
        map.put("remoteIp", REMOTE_IP_FIELD);
        map.put("dnatIp", DNAT_IP_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("traversedConstructs", TRAVERSED_CONSTRUCTS_FIELD);
        map.put("kubernetesMetadata", KUBERNETES_METADATA_FIELD);
        map.put("localInstanceArn", LOCAL_INSTANCE_ARN_FIELD);
        map.put("localSubnetArn", LOCAL_SUBNET_ARN_FIELD);
        map.put("localVpcArn", LOCAL_VPC_ARN_FIELD);
        map.put("remoteInstanceArn", REMOTE_INSTANCE_ARN_FIELD);
        map.put("remoteSubnetArn", REMOTE_SUBNET_ARN_FIELD);
        map.put("remoteVpcArn", REMOTE_VPC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitorTopContributorsRow, T> g) {
        return obj -> g.apply((MonitorTopContributorsRow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localIp;
        private String snatIp;
        private String localInstanceId;
        private String localVpcId;
        private String localRegion;
        private String localAz;
        private String localSubnetId;
        private Integer targetPort;
        private String destinationCategory;
        private String remoteVpcId;
        private String remoteRegion;
        private String remoteAz;
        private String remoteSubnetId;
        private String remoteInstanceId;
        private String remoteIp;
        private String dnatIp;
        private Long value;
        private List<TraversedComponent> traversedConstructs = DefaultSdkAutoConstructList.getInstance();
        private KubernetesMetadata kubernetesMetadata;
        private String localInstanceArn;
        private String localSubnetArn;
        private String localVpcArn;
        private String remoteInstanceArn;
        private String remoteSubnetArn;
        private String remoteVpcArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorTopContributorsRow model) {
            this.localIp(model.localIp);
            this.snatIp(model.snatIp);
            this.localInstanceId(model.localInstanceId);
            this.localVpcId(model.localVpcId);
            this.localRegion(model.localRegion);
            this.localAz(model.localAz);
            this.localSubnetId(model.localSubnetId);
            this.targetPort(model.targetPort);
            this.destinationCategory(model.destinationCategory);
            this.remoteVpcId(model.remoteVpcId);
            this.remoteRegion(model.remoteRegion);
            this.remoteAz(model.remoteAz);
            this.remoteSubnetId(model.remoteSubnetId);
            this.remoteInstanceId(model.remoteInstanceId);
            this.remoteIp(model.remoteIp);
            this.dnatIp(model.dnatIp);
            this.value(model.value);
            this.traversedConstructs(model.traversedConstructs);
            this.kubernetesMetadata(model.kubernetesMetadata);
            this.localInstanceArn(model.localInstanceArn);
            this.localSubnetArn(model.localSubnetArn);
            this.localVpcArn(model.localVpcArn);
            this.remoteInstanceArn(model.remoteInstanceArn);
            this.remoteSubnetArn(model.remoteSubnetArn);
            this.remoteVpcArn(model.remoteVpcArn);
        }

        public final String getLocalIp() {
            return this.localIp;
        }

        public final void setLocalIp(String localIp) {
            this.localIp = localIp;
        }

        @Override
        public final Builder localIp(String localIp) {
            this.localIp = localIp;
            return this;
        }

        public final String getSnatIp() {
            return this.snatIp;
        }

        public final void setSnatIp(String snatIp) {
            this.snatIp = snatIp;
        }

        @Override
        public final Builder snatIp(String snatIp) {
            this.snatIp = snatIp;
            return this;
        }

        public final String getLocalInstanceId() {
            return this.localInstanceId;
        }

        public final void setLocalInstanceId(String localInstanceId) {
            this.localInstanceId = localInstanceId;
        }

        @Override
        public final Builder localInstanceId(String localInstanceId) {
            this.localInstanceId = localInstanceId;
            return this;
        }

        public final String getLocalVpcId() {
            return this.localVpcId;
        }

        public final void setLocalVpcId(String localVpcId) {
            this.localVpcId = localVpcId;
        }

        @Override
        public final Builder localVpcId(String localVpcId) {
            this.localVpcId = localVpcId;
            return this;
        }

        public final String getLocalRegion() {
            return this.localRegion;
        }

        public final void setLocalRegion(String localRegion) {
            this.localRegion = localRegion;
        }

        @Override
        public final Builder localRegion(String localRegion) {
            this.localRegion = localRegion;
            return this;
        }

        public final String getLocalAz() {
            return this.localAz;
        }

        public final void setLocalAz(String localAz) {
            this.localAz = localAz;
        }

        @Override
        public final Builder localAz(String localAz) {
            this.localAz = localAz;
            return this;
        }

        public final String getLocalSubnetId() {
            return this.localSubnetId;
        }

        public final void setLocalSubnetId(String localSubnetId) {
            this.localSubnetId = localSubnetId;
        }

        @Override
        public final Builder localSubnetId(String localSubnetId) {
            this.localSubnetId = localSubnetId;
            return this;
        }

        public final Integer getTargetPort() {
            return this.targetPort;
        }

        public final void setTargetPort(Integer targetPort) {
            this.targetPort = targetPort;
        }

        @Override
        public final Builder targetPort(Integer targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        public final String getDestinationCategory() {
            return this.destinationCategory;
        }

        public final void setDestinationCategory(String destinationCategory) {
            this.destinationCategory = destinationCategory;
        }

        @Override
        public final Builder destinationCategory(String destinationCategory) {
            this.destinationCategory = destinationCategory;
            return this;
        }

        @Override
        public final Builder destinationCategory(DestinationCategory destinationCategory) {
            this.destinationCategory(destinationCategory == null ? null : destinationCategory.toString());
            return this;
        }

        public final String getRemoteVpcId() {
            return this.remoteVpcId;
        }

        public final void setRemoteVpcId(String remoteVpcId) {
            this.remoteVpcId = remoteVpcId;
        }

        @Override
        public final Builder remoteVpcId(String remoteVpcId) {
            this.remoteVpcId = remoteVpcId;
            return this;
        }

        public final String getRemoteRegion() {
            return this.remoteRegion;
        }

        public final void setRemoteRegion(String remoteRegion) {
            this.remoteRegion = remoteRegion;
        }

        @Override
        public final Builder remoteRegion(String remoteRegion) {
            this.remoteRegion = remoteRegion;
            return this;
        }

        public final String getRemoteAz() {
            return this.remoteAz;
        }

        public final void setRemoteAz(String remoteAz) {
            this.remoteAz = remoteAz;
        }

        @Override
        public final Builder remoteAz(String remoteAz) {
            this.remoteAz = remoteAz;
            return this;
        }

        public final String getRemoteSubnetId() {
            return this.remoteSubnetId;
        }

        public final void setRemoteSubnetId(String remoteSubnetId) {
            this.remoteSubnetId = remoteSubnetId;
        }

        @Override
        public final Builder remoteSubnetId(String remoteSubnetId) {
            this.remoteSubnetId = remoteSubnetId;
            return this;
        }

        public final String getRemoteInstanceId() {
            return this.remoteInstanceId;
        }

        public final void setRemoteInstanceId(String remoteInstanceId) {
            this.remoteInstanceId = remoteInstanceId;
        }

        @Override
        public final Builder remoteInstanceId(String remoteInstanceId) {
            this.remoteInstanceId = remoteInstanceId;
            return this;
        }

        public final String getRemoteIp() {
            return this.remoteIp;
        }

        public final void setRemoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
        }

        @Override
        public final Builder remoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
            return this;
        }

        public final String getDnatIp() {
            return this.dnatIp;
        }

        public final void setDnatIp(String dnatIp) {
            this.dnatIp = dnatIp;
        }

        @Override
        public final Builder dnatIp(String dnatIp) {
            this.dnatIp = dnatIp;
            return this;
        }

        public final Long getValue() {
            return this.value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final List<TraversedComponent.Builder> getTraversedConstructs() {
            List<TraversedComponent.Builder> result = TraversedConstructsListCopier.copyToBuilder(this.traversedConstructs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraversedConstructs(Collection<TraversedComponent.BuilderImpl> traversedConstructs) {
            this.traversedConstructs = TraversedConstructsListCopier.copyFromBuilder(traversedConstructs);
        }

        @Override
        public final Builder traversedConstructs(Collection<TraversedComponent> traversedConstructs) {
            this.traversedConstructs = TraversedConstructsListCopier.copy(traversedConstructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traversedConstructs(TraversedComponent ... traversedConstructs) {
            this.traversedConstructs(Arrays.asList(traversedConstructs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traversedConstructs(Consumer<TraversedComponent.Builder> ... traversedConstructs) {
            this.traversedConstructs(Stream.of(traversedConstructs).map(c -> (TraversedComponent)((TraversedComponent.Builder)TraversedComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final KubernetesMetadata.Builder getKubernetesMetadata() {
            return this.kubernetesMetadata != null ? this.kubernetesMetadata.toBuilder() : null;
        }

        public final void setKubernetesMetadata(KubernetesMetadata.BuilderImpl kubernetesMetadata) {
            this.kubernetesMetadata = kubernetesMetadata != null ? kubernetesMetadata.build() : null;
        }

        @Override
        public final Builder kubernetesMetadata(KubernetesMetadata kubernetesMetadata) {
            this.kubernetesMetadata = kubernetesMetadata;
            return this;
        }

        public final String getLocalInstanceArn() {
            return this.localInstanceArn;
        }

        public final void setLocalInstanceArn(String localInstanceArn) {
            this.localInstanceArn = localInstanceArn;
        }

        @Override
        public final Builder localInstanceArn(String localInstanceArn) {
            this.localInstanceArn = localInstanceArn;
            return this;
        }

        public final String getLocalSubnetArn() {
            return this.localSubnetArn;
        }

        public final void setLocalSubnetArn(String localSubnetArn) {
            this.localSubnetArn = localSubnetArn;
        }

        @Override
        public final Builder localSubnetArn(String localSubnetArn) {
            this.localSubnetArn = localSubnetArn;
            return this;
        }

        public final String getLocalVpcArn() {
            return this.localVpcArn;
        }

        public final void setLocalVpcArn(String localVpcArn) {
            this.localVpcArn = localVpcArn;
        }

        @Override
        public final Builder localVpcArn(String localVpcArn) {
            this.localVpcArn = localVpcArn;
            return this;
        }

        public final String getRemoteInstanceArn() {
            return this.remoteInstanceArn;
        }

        public final void setRemoteInstanceArn(String remoteInstanceArn) {
            this.remoteInstanceArn = remoteInstanceArn;
        }

        @Override
        public final Builder remoteInstanceArn(String remoteInstanceArn) {
            this.remoteInstanceArn = remoteInstanceArn;
            return this;
        }

        public final String getRemoteSubnetArn() {
            return this.remoteSubnetArn;
        }

        public final void setRemoteSubnetArn(String remoteSubnetArn) {
            this.remoteSubnetArn = remoteSubnetArn;
        }

        @Override
        public final Builder remoteSubnetArn(String remoteSubnetArn) {
            this.remoteSubnetArn = remoteSubnetArn;
            return this;
        }

        public final String getRemoteVpcArn() {
            return this.remoteVpcArn;
        }

        public final void setRemoteVpcArn(String remoteVpcArn) {
            this.remoteVpcArn = remoteVpcArn;
        }

        @Override
        public final Builder remoteVpcArn(String remoteVpcArn) {
            this.remoteVpcArn = remoteVpcArn;
            return this;
        }

        public MonitorTopContributorsRow build() {
            return new MonitorTopContributorsRow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitorTopContributorsRow> {
        public Builder localIp(String var1);

        public Builder snatIp(String var1);

        public Builder localInstanceId(String var1);

        public Builder localVpcId(String var1);

        public Builder localRegion(String var1);

        public Builder localAz(String var1);

        public Builder localSubnetId(String var1);

        public Builder targetPort(Integer var1);

        public Builder destinationCategory(String var1);

        public Builder destinationCategory(DestinationCategory var1);

        public Builder remoteVpcId(String var1);

        public Builder remoteRegion(String var1);

        public Builder remoteAz(String var1);

        public Builder remoteSubnetId(String var1);

        public Builder remoteInstanceId(String var1);

        public Builder remoteIp(String var1);

        public Builder dnatIp(String var1);

        public Builder value(Long var1);

        public Builder traversedConstructs(Collection<TraversedComponent> var1);

        public Builder traversedConstructs(TraversedComponent ... var1);

        public Builder traversedConstructs(Consumer<TraversedComponent.Builder> ... var1);

        public Builder kubernetesMetadata(KubernetesMetadata var1);

        default public Builder kubernetesMetadata(Consumer<KubernetesMetadata.Builder> kubernetesMetadata) {
            return this.kubernetesMetadata((KubernetesMetadata)((KubernetesMetadata.Builder)KubernetesMetadata.builder().applyMutation(kubernetesMetadata)).build());
        }

        public Builder localInstanceArn(String var1);

        public Builder localSubnetArn(String var1);

        public Builder localVpcArn(String var1);

        public Builder remoteInstanceArn(String var1);

        public Builder remoteSubnetArn(String var1);

        public Builder remoteVpcArn(String var1);
    }
}

