/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.TargetResource;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateScopeInputResourcesToAddListCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateScopeInputResourcesToDeleteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScopeRequest
extends NetworkFlowMonitorRequest
implements ToCopyableBuilder<Builder, UpdateScopeRequest> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeId").getter(UpdateScopeRequest.getter(UpdateScopeRequest::scopeId)).setter(UpdateScopeRequest.setter(Builder::scopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("scopeId").build()}).build();
    private static final SdkField<List<TargetResource>> RESOURCES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourcesToAdd").getter(UpdateScopeRequest.getter(UpdateScopeRequest::resourcesToAdd)).setter(UpdateScopeRequest.setter(Builder::resourcesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TargetResource>> RESOURCES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourcesToDelete").getter(UpdateScopeRequest.getter(UpdateScopeRequest::resourcesToDelete)).setter(UpdateScopeRequest.setter(Builder::resourcesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD, RESOURCES_TO_ADD_FIELD, RESOURCES_TO_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateScopeRequest.memberNameToFieldInitializer();
    private final String scopeId;
    private final List<TargetResource> resourcesToAdd;
    private final List<TargetResource> resourcesToDelete;

    private UpdateScopeRequest(BuilderImpl builder) {
        super(builder);
        this.scopeId = builder.scopeId;
        this.resourcesToAdd = builder.resourcesToAdd;
        this.resourcesToDelete = builder.resourcesToDelete;
    }

    public final String scopeId() {
        return this.scopeId;
    }

    public final boolean hasResourcesToAdd() {
        return this.resourcesToAdd != null && !(this.resourcesToAdd instanceof SdkAutoConstructList);
    }

    public final List<TargetResource> resourcesToAdd() {
        return this.resourcesToAdd;
    }

    public final boolean hasResourcesToDelete() {
        return this.resourcesToDelete != null && !(this.resourcesToDelete instanceof SdkAutoConstructList);
    }

    public final List<TargetResource> resourcesToDelete() {
        return this.resourcesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesToAdd() ? this.resourcesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesToDelete() ? this.resourcesToDelete() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScopeRequest)) {
            return false;
        }
        UpdateScopeRequest other = (UpdateScopeRequest)((Object)obj);
        return Objects.equals(this.scopeId(), other.scopeId()) && this.hasResourcesToAdd() == other.hasResourcesToAdd() && Objects.equals(this.resourcesToAdd(), other.resourcesToAdd()) && this.hasResourcesToDelete() == other.hasResourcesToDelete() && Objects.equals(this.resourcesToDelete(), other.resourcesToDelete());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateScopeRequest").add("ScopeId", (Object)this.scopeId()).add("ResourcesToAdd", this.hasResourcesToAdd() ? this.resourcesToAdd() : null).add("ResourcesToDelete", this.hasResourcesToDelete() ? this.resourcesToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scopeId": {
                return Optional.ofNullable(clazz.cast(this.scopeId()));
            }
            case "resourcesToAdd": {
                return Optional.ofNullable(clazz.cast(this.resourcesToAdd()));
            }
            case "resourcesToDelete": {
                return Optional.ofNullable(clazz.cast(this.resourcesToDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scopeId", SCOPE_ID_FIELD);
        map.put("resourcesToAdd", RESOURCES_TO_ADD_FIELD);
        map.put("resourcesToDelete", RESOURCES_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScopeRequest, T> g) {
        return obj -> g.apply((UpdateScopeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorRequest.BuilderImpl
    implements Builder {
        private String scopeId;
        private List<TargetResource> resourcesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<TargetResource> resourcesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScopeRequest model) {
            super(model);
            this.scopeId(model.scopeId);
            this.resourcesToAdd(model.resourcesToAdd);
            this.resourcesToDelete(model.resourcesToDelete);
        }

        public final String getScopeId() {
            return this.scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final List<TargetResource.Builder> getResourcesToAdd() {
            List<TargetResource.Builder> result = UpdateScopeInputResourcesToAddListCopier.copyToBuilder(this.resourcesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcesToAdd(Collection<TargetResource.BuilderImpl> resourcesToAdd) {
            this.resourcesToAdd = UpdateScopeInputResourcesToAddListCopier.copyFromBuilder(resourcesToAdd);
        }

        @Override
        public final Builder resourcesToAdd(Collection<TargetResource> resourcesToAdd) {
            this.resourcesToAdd = UpdateScopeInputResourcesToAddListCopier.copy(resourcesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToAdd(TargetResource ... resourcesToAdd) {
            this.resourcesToAdd(Arrays.asList(resourcesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToAdd(Consumer<TargetResource.Builder> ... resourcesToAdd) {
            this.resourcesToAdd(Stream.of(resourcesToAdd).map(c -> (TargetResource)((TargetResource.Builder)TargetResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TargetResource.Builder> getResourcesToDelete() {
            List<TargetResource.Builder> result = UpdateScopeInputResourcesToDeleteListCopier.copyToBuilder(this.resourcesToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcesToDelete(Collection<TargetResource.BuilderImpl> resourcesToDelete) {
            this.resourcesToDelete = UpdateScopeInputResourcesToDeleteListCopier.copyFromBuilder(resourcesToDelete);
        }

        @Override
        public final Builder resourcesToDelete(Collection<TargetResource> resourcesToDelete) {
            this.resourcesToDelete = UpdateScopeInputResourcesToDeleteListCopier.copy(resourcesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToDelete(TargetResource ... resourcesToDelete) {
            this.resourcesToDelete(Arrays.asList(resourcesToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToDelete(Consumer<TargetResource.Builder> ... resourcesToDelete) {
            this.resourcesToDelete(Stream.of(resourcesToDelete).map(c -> (TargetResource)((TargetResource.Builder)TargetResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScopeRequest build() {
            return new UpdateScopeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFlowMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScopeRequest> {
        public Builder scopeId(String var1);

        public Builder resourcesToAdd(Collection<TargetResource> var1);

        public Builder resourcesToAdd(TargetResource ... var1);

        public Builder resourcesToAdd(Consumer<TargetResource.Builder> ... var1);

        public Builder resourcesToDelete(Collection<TargetResource> var1);

        public Builder resourcesToDelete(TargetResource ... var1);

        public Builder resourcesToDelete(Consumer<TargetResource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

