/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkflowmonitor.NetworkFlowMonitorAsyncClient;
import software.amazon.awssdk.services.networkflowmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsDataPoint;

public class GetQueryResultsWorkloadInsightsTopContributorsDataPublisher
implements SdkPublisher<GetQueryResultsWorkloadInsightsTopContributorsDataResponse> {
    private final NetworkFlowMonitorAsyncClient client;
    private final GetQueryResultsWorkloadInsightsTopContributorsDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetQueryResultsWorkloadInsightsTopContributorsDataPublisher(NetworkFlowMonitorAsyncClient client, GetQueryResultsWorkloadInsightsTopContributorsDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetQueryResultsWorkloadInsightsTopContributorsDataPublisher(NetworkFlowMonitorAsyncClient client, GetQueryResultsWorkloadInsightsTopContributorsDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetQueryResultsWorkloadInsightsTopContributorsDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetQueryResultsWorkloadInsightsTopContributorsDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkloadInsightsTopContributorsDataPoint> datapoints() {
        Function<GetQueryResultsWorkloadInsightsTopContributorsDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.datapoints() != null) {
                return response.datapoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetQueryResultsWorkloadInsightsTopContributorsDataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetQueryResultsWorkloadInsightsTopContributorsDataResponseFetcher
    implements AsyncPageFetcher<GetQueryResultsWorkloadInsightsTopContributorsDataResponse> {
        private GetQueryResultsWorkloadInsightsTopContributorsDataResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsWorkloadInsightsTopContributorsDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetQueryResultsWorkloadInsightsTopContributorsDataResponse> nextPage(GetQueryResultsWorkloadInsightsTopContributorsDataResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsWorkloadInsightsTopContributorsDataPublisher.this.client.getQueryResultsWorkloadInsightsTopContributorsData(GetQueryResultsWorkloadInsightsTopContributorsDataPublisher.this.firstRequest);
            }
            return GetQueryResultsWorkloadInsightsTopContributorsDataPublisher.this.client.getQueryResultsWorkloadInsightsTopContributorsData((GetQueryResultsWorkloadInsightsTopContributorsDataRequest)((Object)GetQueryResultsWorkloadInsightsTopContributorsDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

