/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkflowmonitor.model.TargetId;
import software.amazon.awssdk.services.networkflowmonitor.model.TargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetIdentifier> {
    private static final SdkField<TargetId> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetId").getter(TargetIdentifier.getter(TargetIdentifier::targetId)).setter(TargetIdentifier.setter(Builder::targetId)).constructor(TargetId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetType").getter(TargetIdentifier.getter(TargetIdentifier::targetTypeAsString)).setter(TargetIdentifier.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ID_FIELD, TARGET_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TargetId targetId;
    private final String targetType;

    private TargetIdentifier(BuilderImpl builder) {
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
    }

    public final TargetId targetId() {
        return this.targetId;
    }

    public final TargetType targetType() {
        return TargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetIdentifier)) {
            return false;
        }
        TargetIdentifier other = (TargetIdentifier)obj;
        return Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TargetIdentifier").add("TargetId", (Object)this.targetId()).add("TargetType", (Object)this.targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "targetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetId", TARGET_ID_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetIdentifier, T> g) {
        return obj -> g.apply((TargetIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TargetId targetId;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetIdentifier model) {
            this.targetId(model.targetId);
            this.targetType(model.targetType);
        }

        public final TargetId.Builder getTargetId() {
            return this.targetId != null ? this.targetId.toBuilder() : null;
        }

        public final void setTargetId(TargetId.BuilderImpl targetId) {
            this.targetId = targetId != null ? targetId.build() : null;
        }

        @Override
        public final Builder targetId(TargetId targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public TargetIdentifier build() {
            return new TargetIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetIdentifier> {
        public Builder targetId(TargetId var1);

        default public Builder targetId(Consumer<TargetId.Builder> targetId) {
            return this.targetId((TargetId)((TargetId.Builder)TargetId.builder().applyMutation(targetId)).build());
        }

        public Builder targetType(String var1);

        public Builder targetType(TargetType var1);
    }
}

