/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkflowmonitor.NetworkFlowMonitorAsyncClient;
import software.amazon.awssdk.services.networkflowmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ScopeSummary;

public class ListScopesPublisher
implements SdkPublisher<ListScopesResponse> {
    private final NetworkFlowMonitorAsyncClient client;
    private final ListScopesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScopesPublisher(NetworkFlowMonitorAsyncClient client, ListScopesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScopesPublisher(NetworkFlowMonitorAsyncClient client, ListScopesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScopesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScopesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScopeSummary> scopes() {
        Function<ListScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scopes() != null) {
                return response.scopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScopesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScopesResponseFetcher
    implements AsyncPageFetcher<ListScopesResponse> {
        private ListScopesResponseFetcher() {
        }

        public boolean hasNextPage(ListScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScopesResponse> nextPage(ListScopesResponse previousPage) {
            if (previousPage == null) {
                return ListScopesPublisher.this.client.listScopes(ListScopesPublisher.this.firstRequest);
            }
            return ListScopesPublisher.this.client.listScopes((ListScopesRequest)((Object)ListScopesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

