/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkflowmonitor.model.DestinationCategory;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartQueryWorkloadInsightsTopContributorsRequest
extends NetworkFlowMonitorRequest
implements ToCopyableBuilder<Builder, StartQueryWorkloadInsightsTopContributorsRequest> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeId").getter(StartQueryWorkloadInsightsTopContributorsRequest.getter(StartQueryWorkloadInsightsTopContributorsRequest::scopeId)).setter(StartQueryWorkloadInsightsTopContributorsRequest.setter(Builder::scopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("scopeId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StartQueryWorkloadInsightsTopContributorsRequest.getter(StartQueryWorkloadInsightsTopContributorsRequest::startTime)).setter(StartQueryWorkloadInsightsTopContributorsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(StartQueryWorkloadInsightsTopContributorsRequest.getter(StartQueryWorkloadInsightsTopContributorsRequest::endTime)).setter(StartQueryWorkloadInsightsTopContributorsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(StartQueryWorkloadInsightsTopContributorsRequest.getter(StartQueryWorkloadInsightsTopContributorsRequest::metricNameAsString)).setter(StartQueryWorkloadInsightsTopContributorsRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> DESTINATION_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCategory").getter(StartQueryWorkloadInsightsTopContributorsRequest.getter(StartQueryWorkloadInsightsTopContributorsRequest::destinationCategoryAsString)).setter(StartQueryWorkloadInsightsTopContributorsRequest.setter(Builder::destinationCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCategory").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(StartQueryWorkloadInsightsTopContributorsRequest.getter(StartQueryWorkloadInsightsTopContributorsRequest::limit)).setter(StartQueryWorkloadInsightsTopContributorsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, METRIC_NAME_FIELD, DESTINATION_CATEGORY_FIELD, LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartQueryWorkloadInsightsTopContributorsRequest.memberNameToFieldInitializer();
    private final String scopeId;
    private final Instant startTime;
    private final Instant endTime;
    private final String metricName;
    private final String destinationCategory;
    private final Integer limit;

    private StartQueryWorkloadInsightsTopContributorsRequest(BuilderImpl builder) {
        super(builder);
        this.scopeId = builder.scopeId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.metricName = builder.metricName;
        this.destinationCategory = builder.destinationCategory;
        this.limit = builder.limit;
    }

    public final String scopeId() {
        return this.scopeId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final WorkloadInsightsMetric metricName() {
        return WorkloadInsightsMetric.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final DestinationCategory destinationCategory() {
        return DestinationCategory.fromValue(this.destinationCategory);
    }

    public final String destinationCategoryAsString() {
        return this.destinationCategory;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryWorkloadInsightsTopContributorsRequest)) {
            return false;
        }
        StartQueryWorkloadInsightsTopContributorsRequest other = (StartQueryWorkloadInsightsTopContributorsRequest)((Object)obj);
        return Objects.equals(this.scopeId(), other.scopeId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.destinationCategoryAsString(), other.destinationCategoryAsString()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"StartQueryWorkloadInsightsTopContributorsRequest").add("ScopeId", (Object)this.scopeId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("MetricName", (Object)this.metricNameAsString()).add("DestinationCategory", (Object)this.destinationCategoryAsString()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scopeId": {
                return Optional.ofNullable(clazz.cast(this.scopeId()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "destinationCategory": {
                return Optional.ofNullable(clazz.cast(this.destinationCategoryAsString()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scopeId", SCOPE_ID_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("destinationCategory", DESTINATION_CATEGORY_FIELD);
        map.put("limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartQueryWorkloadInsightsTopContributorsRequest, T> g) {
        return obj -> g.apply((StartQueryWorkloadInsightsTopContributorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorRequest.BuilderImpl
    implements Builder {
        private String scopeId;
        private Instant startTime;
        private Instant endTime;
        private String metricName;
        private String destinationCategory;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryWorkloadInsightsTopContributorsRequest model) {
            super(model);
            this.scopeId(model.scopeId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.metricName(model.metricName);
            this.destinationCategory(model.destinationCategory);
            this.limit(model.limit);
        }

        public final String getScopeId() {
            return this.scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(WorkloadInsightsMetric metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final String getDestinationCategory() {
            return this.destinationCategory;
        }

        public final void setDestinationCategory(String destinationCategory) {
            this.destinationCategory = destinationCategory;
        }

        @Override
        public final Builder destinationCategory(String destinationCategory) {
            this.destinationCategory = destinationCategory;
            return this;
        }

        @Override
        public final Builder destinationCategory(DestinationCategory destinationCategory) {
            this.destinationCategory(destinationCategory == null ? null : destinationCategory.toString());
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryWorkloadInsightsTopContributorsRequest build() {
            return new StartQueryWorkloadInsightsTopContributorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFlowMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartQueryWorkloadInsightsTopContributorsRequest> {
        public Builder scopeId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder metricName(String var1);

        public Builder metricName(WorkloadInsightsMetric var1);

        public Builder destinationCategory(String var1);

        public Builder destinationCategory(DestinationCategory var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

