/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ScopeStatus;
import software.amazon.awssdk.services.networkflowmonitor.model.TagMapCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.TargetResource;
import software.amazon.awssdk.services.networkflowmonitor.model.TargetResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScopeResponse
extends NetworkFlowMonitorResponse
implements ToCopyableBuilder<Builder, GetScopeResponse> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeId").getter(GetScopeResponse.getter(GetScopeResponse::scopeId)).setter(GetScopeResponse.setter(Builder::scopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetScopeResponse.getter(GetScopeResponse::statusAsString)).setter(GetScopeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SCOPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeArn").getter(GetScopeResponse.getter(GetScopeResponse::scopeArn)).setter(GetScopeResponse.setter(Builder::scopeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeArn").build()}).build();
    private static final SdkField<List<TargetResource>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(GetScopeResponse.getter(GetScopeResponse::targets)).setter(GetScopeResponse.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetScopeResponse.getter(GetScopeResponse::tags)).setter(GetScopeResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD, STATUS_FIELD, SCOPE_ARN_FIELD, TARGETS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetScopeResponse.memberNameToFieldInitializer();
    private final String scopeId;
    private final String status;
    private final String scopeArn;
    private final List<TargetResource> targets;
    private final Map<String, String> tags;

    private GetScopeResponse(BuilderImpl builder) {
        super(builder);
        this.scopeId = builder.scopeId;
        this.status = builder.status;
        this.scopeArn = builder.scopeArn;
        this.targets = builder.targets;
        this.tags = builder.tags;
    }

    public final String scopeId() {
        return this.scopeId;
    }

    public final ScopeStatus status() {
        return ScopeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String scopeArn() {
        return this.scopeArn;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<TargetResource> targets() {
        return this.targets;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScopeResponse)) {
            return false;
        }
        GetScopeResponse other = (GetScopeResponse)((Object)obj);
        return Objects.equals(this.scopeId(), other.scopeId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.scopeArn(), other.scopeArn()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetScopeResponse").add("ScopeId", (Object)this.scopeId()).add("Status", (Object)this.statusAsString()).add("ScopeArn", (Object)this.scopeArn()).add("Targets", this.hasTargets() ? this.targets() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scopeId": {
                return Optional.ofNullable(clazz.cast(this.scopeId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "scopeArn": {
                return Optional.ofNullable(clazz.cast(this.scopeArn()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scopeId", SCOPE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("scopeArn", SCOPE_ARN_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScopeResponse, T> g) {
        return obj -> g.apply((GetScopeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorResponse.BuilderImpl
    implements Builder {
        private String scopeId;
        private String status;
        private String scopeArn;
        private List<TargetResource> targets = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetScopeResponse model) {
            super(model);
            this.scopeId(model.scopeId);
            this.status(model.status);
            this.scopeArn(model.scopeArn);
            this.targets(model.targets);
            this.tags(model.tags);
        }

        public final String getScopeId() {
            return this.scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScopeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getScopeArn() {
            return this.scopeArn;
        }

        public final void setScopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
        }

        @Override
        public final Builder scopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
            return this;
        }

        public final List<TargetResource.Builder> getTargets() {
            List<TargetResource.Builder> result = TargetResourceListCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<TargetResource.BuilderImpl> targets) {
            this.targets = TargetResourceListCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<TargetResource> targets) {
            this.targets = TargetResourceListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(TargetResource ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<TargetResource.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (TargetResource)((TargetResource.Builder)TargetResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetScopeResponse build() {
            return new GetScopeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFlowMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScopeResponse> {
        public Builder scopeId(String var1);

        public Builder status(String var1);

        public Builder status(ScopeStatus var1);

        public Builder scopeArn(String var1);

        public Builder targets(Collection<TargetResource> var1);

        public Builder targets(TargetResource ... var1);

        public Builder targets(Consumer<TargetResource.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

