/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkflowmonitor.NetworkFlowMonitorClient;
import software.amazon.awssdk.services.networkflowmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorTopContributorsRow;

public class GetQueryResultsMonitorTopContributorsIterable
implements SdkIterable<GetQueryResultsMonitorTopContributorsResponse> {
    private final NetworkFlowMonitorClient client;
    private final GetQueryResultsMonitorTopContributorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetQueryResultsMonitorTopContributorsIterable(NetworkFlowMonitorClient client, GetQueryResultsMonitorTopContributorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetQueryResultsMonitorTopContributorsResponseFetcher();
    }

    public Iterator<GetQueryResultsMonitorTopContributorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitorTopContributorsRow> topContributors() {
        Function<GetQueryResultsMonitorTopContributorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topContributors() != null) {
                return response.topContributors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetQueryResultsMonitorTopContributorsResponseFetcher
    implements SyncPageFetcher<GetQueryResultsMonitorTopContributorsResponse> {
        private GetQueryResultsMonitorTopContributorsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsMonitorTopContributorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetQueryResultsMonitorTopContributorsResponse nextPage(GetQueryResultsMonitorTopContributorsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsMonitorTopContributorsIterable.this.client.getQueryResultsMonitorTopContributors(GetQueryResultsMonitorTopContributorsIterable.this.firstRequest);
            }
            return GetQueryResultsMonitorTopContributorsIterable.this.client.getQueryResultsMonitorTopContributors((GetQueryResultsMonitorTopContributorsRequest)((Object)GetQueryResultsMonitorTopContributorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

